#include "loadingwidget.h"
#include "ui_loadingwidget.h"

LoadingWidget::LoadingWidget(QWidget *parent) :
    QWidget(parent),
    ui(new Ui::LoadingWidget)
{
    ui->setupUi(this);
    setMinimumSize(127, 66);
#ifdef Q_WS_MAEMO_5
    setMinimumSize(220, 66);
#endif
    m_pixmap = QPixmap(":/icons/icons/busy.png");
    timeline = new QTimeLine(1300, this);
    timeline->setFrameRange(0, 360);
    timeline->setLoopCount(0);
    timeline->setEasingCurve(QEasingCurve::Custom);
    m_hiddenPos = QPoint((this->parentWidget()->width()/2)-this->width()/2, this->parentWidget()->y()-this->height());
    connect(timeline, SIGNAL(frameChanged(int)), this, SLOT(onFrameChanged(int)));
    bool whiteMode = QSettings().value("main/white-mode", false).toBool();
    if (whiteMode) {
        QPalette p(this->palette());
        p.setColor(QPalette::Foreground, Qt::black);
        ui->label->setPalette(p);
    }
}

LoadingWidget::~LoadingWidget()
{
    delete ui;
}

void LoadingWidget::onFrameChanged(int frame)
{
    QMatrix m;
    m.rotate(frame);
    QPixmap pixmap = m_pixmap;
    pixmap = m_pixmap.transformed(m, Qt::SmoothTransformation);
    ui->imageLabel->setPixmap(pixmap);
}

void LoadingWidget::setLoading(bool isLoading)
{
    m_isLoading = isLoading;
    if (isLoading)
        show();
    else
        hideWidget();
}

void LoadingWidget::hideWidget()
{
    if (isHidden())
        return;

    QPropertyAnimation *animation = new QPropertyAnimation(this, "pos", this);
    animation->setDuration(500);
    animation->setEasingCurve(QEasingCurve::InOutCirc);
    m_hiddenPos = QPoint((this->parentWidget()->width()/2)-this->width()/2, this->parentWidget()->y()-this->height());
    animation->setStartValue(m_shownPos);
    animation->setEndValue(m_hiddenPos);
    connect(animation, SIGNAL(finished()), timeline, SLOT(stop()));
    animation->start(QPropertyAnimation::DeleteWhenStopped);
    connect(animation, SIGNAL(finished()), this, SLOT(deleteLater()));
}

void LoadingWidget::showEvent(QShowEvent *)
{
    QPropertyAnimation *animation = new QPropertyAnimation(this, "pos", this);
    animation->setDuration(500);
    animation->setEasingCurve(QEasingCurve::InOutCirc);
    animation->setStartValue(m_hiddenPos);
    m_shownPos = QPoint((this->parentWidget()->width()/2)-(this->width()/2), this->parentWidget()->y()+50);
    animation->setEndValue(m_shownPos);
    animation->start(QPropertyAnimation::DeleteWhenStopped);
    timeline->start();
}
