#include "neweventdialog.h"
#include "ui_neweventdialog.h"

NewEventDialog::NewEventDialog(QWidget *parent, QString token, QFacebook *qfacebook) :
    QDialog(parent),
    ui(new Ui::NewEventDialog),
    accessToken(token),
    qfacebook(qfacebook)
{
    ui->setupUi(this);
#ifdef Q_WS_MAEMO_5
    setMinimumHeight(550);
#endif
    ui->fromDateEdit->setMinimumDate(QDate::currentDate());
    ui->toDateEdit->setMinimumDate(QDate::currentDate());
}

NewEventDialog::~NewEventDialog()
{
    delete ui;
}

void NewEventDialog::accept()
{
    if (ui->nameEdit->text().isEmpty()) {
#ifdef Q_WS_MAEMO_5
        QMaemo5InformationBox::information(this, tr("Name field cannot be empty!"));
#else
        QMessageBox::information(this, tr("Error"), tr("Name frield cannot be empty!"));
#endif
        return;
    }
    ui->closedRadio->setEnabled(false);
    ui->openRadio->setEnabled(false);
    ui->secretRadio->setEnabled(false);
    ui->nameEdit->setEnabled(false);
    ui->descriptionEdit->setEnabled(false);
    ui->fromDateEdit->setEnabled(false);
    ui->toDateEdit->setEnabled(false);
    ui->locationEdit->setEnabled(false);
    ui->buttonBox->setEnabled(false);

    QByteArray data;
    QString privacy;
    data.append("name=" + ui->nameEdit->text().toUtf8());
    if (!ui->descriptionEdit->text().isEmpty())
        data.append("&description=" + ui->descriptionEdit->text().toUtf8());
    if (!ui->locationEdit->text().isEmpty())
        data.append("&location=" + ui->locationEdit->text().toUtf8());
    data.append(QString("&start_time=%1").arg(ui->fromDateEdit->dateTime().toString(Qt::ISODate)));
    data.append(QString("&end_time=%1").arg(ui->toDateEdit->dateTime().toString(Qt::ISODate)));
    if (ui->openRadio->isChecked())
        privacy = "OPEN";
    else if (ui->closedRadio->isChecked())
        privacy = "CLOSED";
    else if (ui->secretRadio->isChecked())
        privacy = "SECRET";
    data.append(QString("&privacy_type=%1").arg(privacy));

    reply = qfacebook->putObject("me", "events", data);
    if (reply)
        connect(reply, SIGNAL(finished()), this, SLOT(onReplyReceived()));
}

void NewEventDialog::onReplyReceived()
{
    if (reply->error() != QNetworkReply::NoError) {
#ifdef Q_WS_MAEMO_5
        QMaemo5InformationBox::information(this, tr("Failed to create event!"));
#endif
        qDebug() << "Failed to create event!";
        reply->deleteLater();
        reply = 0;

        ui->closedRadio->setEnabled(true);
        ui->openRadio->setEnabled(true);
        ui->secretRadio->setEnabled(true);
        ui->nameEdit->setEnabled(true);
        ui->descriptionEdit->setEnabled(true);
        ui->fromDateEdit->setEnabled(true);
        ui->toDateEdit->setEnabled(true);
        ui->locationEdit->setEnabled(true);
        ui->buttonBox->setEnabled(true);

        return;
    }

    emit eventCreated();
    this->close();
}
