#include "chatlogindialog.h"
#include "ui_chatlogindialog.h"
#include <QDebug>

ChatLoginDialog::ChatLoginDialog(QWidget *parent) :
    QDialog(parent),
    ui(new Ui::ChatLoginDialog)
{
    ui->setupUi(this);
    m_accepted = false;
    m_isLoggingIn = false;
    ui->usernameEdit->setText(QSettings().value("chat/username", "").toString());
    ui->label_4->setText("If you do not have a Facebook username, please set one <a href=\"http://facebook.com/username\">here</a>");
}

ChatLoginDialog::~ChatLoginDialog()
{
    delete ui;
}

void ChatLoginDialog::accept()
{
    m_accepted = true;
    emit login(ui->usernameEdit->text(), ui->passwordEdit->text(), ui->checkBox->isChecked());
    m_isLoggingIn = true;
    this->close();
}

void ChatLoginDialog::reject()
{
    if (m_isLoggingIn) {
        this->close();
        return;
    }

    if (m_accepted && !m_isLoggingIn)
        return;

    if (!m_isLoggingIn)
        emit loginCanceled();
    this->close();
}
