#include "singlepostwindow.h"
#include "ui_singlepostwindow.h"
#include "profilewindow.h"

SinglePostWindow::SinglePostWindow(QWidget *parent, QString token) :
    QMainWindow(parent),
    ui(new Ui::SinglePostWindow),
    accessToken(token),
    qfacebook(new QFacebook(token, this)),
    nam(new QNetworkAccessManager(this))
{
    ui->setupUi(this);
    connect(ui->commentButton, SIGNAL(clicked()), this, SLOT(onPostButtonClicked()));
    connect(QApplication::desktop(), SIGNAL(resized(int)), this, SLOT(orientationChanged()));
    this->orientationChanged();
    gotMainPost = false;
    myId = QSettings().value("main/myId").toString();
#ifdef Q_WS_MAEMO_5
    setAttribute(Qt::WA_Maemo5StackedWindow);
#endif
}

SinglePostWindow::~SinglePostWindow()
{
    delete ui;
}

void SinglePostWindow::loadPost(QString id)
{
    this->postId = id;
    this->reply = qfacebook->getObject(id);
    connect(reply, SIGNAL(finished()), this, SLOT(onReplyReceived()));
}

void SinglePostWindow::orientationChanged()
{
    QRect screenGeometry = QApplication::desktop()->screenGeometry();
    ui->scrollAreaWidgetContents->setMaximumWidth(screenGeometry.width()-15);
}

void SinglePostWindow::setCountLabel(QString comments, QString likes)
{
    if (comments.toInt() == 0 && likes.toInt() == 0) {
        ui->count->clear();
        ui->count->hide();
        return;
    }

    QString text;
    text.append(comments + " ");

    if (comments.toInt() == 1)
        text.append(tr("comment"));
    else
        text.append(tr("comments"));

    if (likes.toInt() == 0) {
        ui->count->setText(text);
        return;
    }
    text.append(" " + tr("and") + " " + likes + " ");
    if (likes.toInt() == 1)
        text.append(tr("like"));
    else
        text.append(tr("likes"));
    ui->count->setText(text);
}

void SinglePostWindow::onReplyReceived()
{
    if (!posts.isEmpty()) {
        foreach (NewsFeedPost *post, posts) {
            ui->commentsLayout->addWidget(post);
            delete post;
        }
        posts.clear();
    }

    if (this->reply->error() != QNetworkReply::NoError) {
        qDebug() << "Failed to fetch comments!";
        this->reply->deleteLater();
        this->reply = 0;

        return;
    }

    bool deletable = false;
    QVariant jsonData = this->reply->data();
    QString name = jsonData.toMap().value("from").toMap().value("name").toString();
    QString userId = jsonData.toMap().value("from").toMap().value("id").toString();
    if (userId == myId)
        deletable = true;
    QVariantList toIds = jsonData.toMap().value("to").toMap().value("data").toList();
    foreach (QVariant toId, toIds) {
        if (toId.toMap().value("id").toString() == myId)
            deletable = true;
    }

    QString message = jsonData.toMap().value("message").toString();
    QString time = jsonData.toMap().value("created_time").toString();
    QString link = jsonData.toMap().value("link").toString();
    if (link.isEmpty())
        link = jsonData.toMap().value("source").toString();
    QString likesCount = jsonData.toMap().value("likes").toMap().value("count").toString();
    if (likesCount.isEmpty())
        likesCount = "0";
    if (!link.isEmpty()) {
        if (!message.isEmpty())
            message.append("\n");
        message.append(QString("<a href=\"%1\">%1</a>").arg(link) + "\n\n");
        message.append(jsonData.toMap().value("name").toString() + "\n");
        message.append(jsonData.toMap().value("caption").toString() + "\n");
        message.append(jsonData.toMap().value("description").toString() + "\n");
    }

    if (!gotMainPost) {
        NewsFeedPost *post = new NewsFeedPost(this, accessToken, qfacebook, nam);
        connect(post, SIGNAL(nameClicked(QString,QString)), this, SLOT(onNameClicked(QString,QString)));
        connect(post, SIGNAL(destroyed()), this, SLOT(close()));
        post->setCommentMode(true);
        post->setDeletable(deletable);
        post->setMessage(message);
        post->setName(name);
        post->setUserId(userId);
        post->setNumberOfLikesComments(likesCount, "0");
        post->getPixmapFromUrl(QString("http://graph.facebook.com/%1/picture").arg(userId));
        post->setId(this->postId);
        post->setTime(time);
        ui->mainPostLayout->addWidget(post);
        gotMainPost = true;
    }

    QVariantList listData;
    listData = jsonData.toMap().value("comments").toMap().value("data").toList();
    foreach(jsonData, listData) {
        NewsFeedPost *post = new NewsFeedPost(ui->commentsWidget, accessToken, qfacebook, nam);
        connect(post, SIGNAL(nameClicked(QString,QString)), this, SLOT(onNameClicked(QString,QString)));
        connect(post, SIGNAL(destroyed(QObject*)), this, SLOT(onPostDestroyed(QObject*)));
        post->setCommentMode(true);
        QString name = jsonData.toMap().value("from").toMap().value("name").toString();
        QString userId = jsonData.toMap().value("from").toMap().value("id").toString();
        if (userId == myId || deletable)
            post->setDeletable(true);
        QString message = jsonData.toMap().value("message").toString();
        QString icon = jsonData.toMap().value("icon").toString();
        QString time = jsonData.toMap().value("created_time").toString();
        QString link = jsonData.toMap().value("link").toString();
        if (!link.isEmpty()) {
            if (!message.isEmpty())
                message.append("\n");
            message.append(QString("<a href=\"%1\">%1</a>").arg(link) + "\n\n");
            message.append(jsonData.toMap().value("name").toString() + "\n");
            message.append(jsonData.toMap().value("caption").toString() + "\n");
            message.append(jsonData.toMap().value("description").toString() + "\n");
        }
        // Check if the currently logged in user likes the post
        QVariantList likes = jsonData.toMap().value("likes").toMap().value("data").toList();
        bool meLikesThis = false;
        QString myId = QSettings().value("main/myId").toString();
        foreach (QVariant likeId, likes) {
            QVariantMap map = likeId.value<QVariantMap>();
            QString likerId = map.value("id").toString();
            if (likerId.contains(myId))
                meLikesThis = true;
            else
                meLikesThis = false;
        }

        // Get like and comment count.
        QString likesCount = jsonData.toMap().value("likes").toMap().value("count").toString();
        if (likesCount.isEmpty())
            likesCount = "0";

        post->setName(name);
        post->setMessage(message);
        post->setId(jsonData.toMap().value("id").toString());
        post->getPixmapFromUrl(QString("http://graph.facebook.com/%1/picture").arg(userId));
        post->setLikedByMe(meLikesThis);
        post->setNumberOfLikesComments(likesCount, "0");
        post->setIconFromUrl(icon);
        post->setTime(time);
        posts.append(post);
        ui->commentsLayout->addWidget(post);
    }
}

void SinglePostWindow::onPostDestroyed(QObject *object)
{
    posts.removeOne((NewsFeedPost*)object);
}

void SinglePostWindow::onNameClicked(QString id, QString name)
{
    ProfileWindow *window = new ProfileWindow(this, accessToken);
    window->setWindowTitle(name);
    window->browseProfile(id);
    window->show();
}

void SinglePostWindow::onPostButtonClicked()
{
    if (ui->replyEdit->text().isEmpty()) {
#ifdef Q_WS_MAEMO_5
        QMaemo5InformationBox::information(this, tr("Unable to post empty comment!"));
#else
        QMessageBox::warning(this, tr("Error"), tr("Unable to post empty comment!"));
#endif
        return;
    }

    QByteArray data;
    data.append("message=" + ui->replyEdit->text().toUtf8());
    this->commentReply = qfacebook->putObject(this->postId, "comments", data);
    if (this->commentReply)
        connect(commentReply, SIGNAL(finished()), this, SLOT(onCommentReplyReceived()));
    ui->replyEdit->setEnabled(false);
}

void SinglePostWindow::onCommentReplyReceived()
{
    ui->replyEdit->setEnabled(true);

    if (this->commentReply->error() != QNetworkReply::NoError) {
        qDebug() << "Failed to post comment!";
#ifdef Q_WS_MAEMO_5
        QMaemo5InformationBox::information(this, tr("Failed to post comment!"));
#else
        QMessageBox::warning(this, tr("Error"), tr("Failed to post comment!"));
#endif
        this->commentReply->deleteLater();
        this->commentReply = 0;

        return;
    }

    ui->replyEdit->clear();
#ifdef Q_WS_MAEMO_5
    QMaemo5InformationBox::information(this, tr("Comment posted"));
#endif

    this->loadPost(this->postId);
}
