#ifndef PROFILEWINDOW_H
#define PROFILEWINDOW_H

#include <QMainWindow>
#include <QSettings>
#include <QDesktopWidget>
#include <qfacebook.h>
#include "newsfeedpost.h"
#include "newstatusupdatedialog.h"
#include "photowindow.h"
#include "singlepostwindow.h"
#ifdef Q_WS_MAEMO_5
    #include <QMaemo5InformationBox>
#else
    #include <QMessageBox>
#endif

namespace Ui {
    class ProfileWindow;
}

class ProfileWindow : public QMainWindow
{
    Q_OBJECT

public:
    explicit ProfileWindow(QWidget *parent = 0, QString token = "0");
    ~ProfileWindow();
    void browseProfile(QString id);

private:
    Ui::ProfileWindow *ui;
    QString profileId;
    QFacebook *qfacebook;
    QFacebookReply *reply;
    QFacebookReply *infoReply;
    QFacebookReply *postReply;
    QString accessToken;
    QNetworkAccessManager *nam;
    QList<NewsFeedPost*> posts;
    QNetworkReply *avatarReply;
    QByteArray dataToPost;
    void setAvatar(QPixmap avatar);

private slots:
    void onReplyReceived();
    void onAvatarReceived();
    void onTextBoxClicked();
    void onPostToWall(QString text, QString link, QString video);
    void onPosted();
    void updateProfile();
    void onAvatarClicked();
    void onInfoReplyReceived();
    void orientationChanged();
    void onNameClicked(QString id, QString name);
    void onCommentButtonClicked(QString id, QString comments, QString likes);
    void onNewsFeedPostDestroyed(QObject*);
    void onPhotosClicked();
};

#endif // PROFILEWINDOW_H
