#ifndef MESSAGESWINDOW_H
#define MESSAGESWINDOW_H

#include <QMainWindow>
#include <QDebug>
#include <QListWidgetItem>
#include <qfacebook.h>
#include "messageview.h"
#include "composemessage.h"
#include "newsfeedpost.h"

namespace Ui {
    class MessagesWindow;
}

class MessagesWindow : public QMainWindow
{
    Q_OBJECT

public:
    explicit MessagesWindow(QWidget *parent = 0, QString token = "0");
    ~MessagesWindow();

private:
    Ui::MessagesWindow *ui;
    QFacebook *qfacebook;
    QFacebookReply *reply;
    QString accessToken;
    QList<NewsFeedPost*> messages;
    QNetworkAccessManager *nam;

private slots:
    void updateMessages();
    void onReplyReceived();
    void onNewMessageButtonClicked();
    void onMessageClicked(QString id);
};

#endif // MESSAGESWINDOW_H
