#include "mainwindow.h"
#include "ui_mainwindow.h"
#ifdef Q_WS_MAEMO_5
    #include <X11/Xlib.h>
    #include <QX11Info>
#endif

MainWindow::MainWindow(QWidget *parent) :
    QMainWindow(parent),
    ui(new Ui::MainWindow),
    newsFeedWindow(0),
    friendsWindow(0),
    albumsWindow(0),
    profileWindow(0),
    groupsWindow(0),
    loginWindow(0),
    eventsWindow(0),
    nam(new QNetworkAccessManager(this))
{
    ui->setupUi(this);
#ifdef Q_WS_MAEMO_5
    setAttribute(Qt::WA_Maemo5StackedWindow);
    setAttribute(Qt::WA_Maemo5AutoOrientation);
#endif
    ThumbnailItemDelegate *delegate = new ThumbnailItemDelegate(ui->listWidget);
    ui->listWidget->setItemDelegate(delegate);
    this->connectSignals();
    if (!QSettings().contains("main/token"))
        this->createLoginWindow();
    else {
        this->accessToken = QSettings().value("main/token").toString();
        this->myName = QSettings().value("main/myName").toString();
        this->myId = QSettings().value("main/myId").toString();
        if (!QSettings().contains("main/myId")) {
            this->logout();
        }
        notificationsDialog = new NotificationsDialog(this, accessToken);
        connect(ui->pushButton, SIGNAL(clicked()), notificationsDialog, SLOT(show()));
        connect(notificationsDialog, SIGNAL(gotNotificationsCount(int)), this, SLOT(onGotNotificationCount(int)));
    }
#ifdef Q_WS_MAEMO_5
    QTimer::singleShot(1200, this, SLOT(takeScreenshot()));
#endif
}

MainWindow::~MainWindow()
{
    delete ui;
}

void MainWindow::connectSignals()
{
    connect(ui->actionAbout_Qt, SIGNAL(triggered()), qApp, SLOT(aboutQt()));
    connect(ui->actionAbout, SIGNAL(triggered()), this, SLOT(showAbout()));
    connect(ui->actionAdd_a_favorite, SIGNAL(triggered()), this, SLOT(onAddToFavoritesClicked()));
    connect(ui->actionLogout, SIGNAL(triggered()), this, SLOT(logout()));
    connect(ui->listWidget, SIGNAL(itemActivated(QListWidgetItem*)), this, SLOT(onItemActivated(QListWidgetItem*)));
    connect(QApplication::desktop(), SIGNAL(resized(int)), this, SLOT(orientationChanged()));
}

void MainWindow::showAbout()
{
    AboutDialog *about = new AboutDialog(this);
    about->show();
}

void MainWindow::onItemActivated(QListWidgetItem *item)
{
    if (item->text() == tr("News Feed")) {
        if (!newsFeedWindow)
            newsFeedWindow = new NewsFeedWindow(this, this->accessToken);
#ifdef Q_WS_S60
        newsFeedWindow->showMaximized();
#else
        newsFeedWindow->show();
#endif
    } else if (item->text() == tr("Messages")) {
        MessagesWindow *window = new MessagesWindow(this, this->accessToken);
#ifdef Q_WS_S60
        window->showMaximized();
#else
        window->show();
#endif
    } else if (item->text() == tr("Photos")) {
        if (!albumsWindow) {
            albumsWindow = new AlbumsWindow(this, this->accessToken);
            albumsWindow->browseAlbums("me");
        }
#ifdef Q_WS_S60
        albumsWindow->showMaximized();
#else
        albumsWindow->show();
#endif
    } else if (item->text() == tr("Profile")) {
        if (!profileWindow) {
            profileWindow = new ProfileWindow(this, this->accessToken);
            profileWindow->browseProfile("me");
            profileWindow->setWindowTitle(this->myName);
        }
#ifdef Q_WS_S60
        profileWindow->showMaximized();
#else
        profileWindow->show();
#endif
    }
    else if (item->text() == tr("Friends")) {
        if (!friendsWindow) {
            friendsWindow = new FriendsWindow(this, this->accessToken);
            friendsWindow->browseId("me");
        }
#ifdef Q_WS_S60
        friendsWindow->showMaximized();
#else
        friendsWindow->show();
#endif
    } else if (item->text() == tr("Groups")) {
        if (!groupsWindow) {
            groupsWindow = new GroupsWindow(this, this->accessToken);
            groupsWindow->browseGroups("me");
        }
#ifdef Q_WS_S60
        groupsWindow->showMaximized();
#else
        groupsWindow->show();
#endif
    } else if (item->text() == tr("Events")) {
        if (!eventsWindow) {
            eventsWindow = new EventsWindow(this, this->accessToken);
            eventsWindow->browseId("me");
        }
#ifdef Q_WS_S60
        eventsWindow->showMaximized();
#else
        eventsWindow->show();
#endif
    } else if (item->text() == tr("Places")) {
        PlacesWindow *placesWindow = new PlacesWindow(this, this->accessToken);
#ifdef Q_WS_S60
        placesWindow->showMaximized();
#else
        placesWindow->show();
#endif
    } else if (!item->data(Qt::UserRole).isNull()) {
        ProfileWindow *window = new ProfileWindow(this, this->accessToken);
        window->setWindowTitle(item->text());
        window->browseProfile(item->data(Qt::UserRole).toString());
        window->show();
    }
}

void MainWindow::orientationChanged()
{
    ui->listWidget->setFlow(ui->listWidget->flow());
}

void MainWindow::createFavorites()
{

}

void MainWindow::getRequestsCount()
{
    QString url = QString("https://api.facebook.com/method/notifications.get&access_token=%1").arg(accessToken);
    requestsReply = nam->get(QNetworkRequest(url));
    if (requestsReply)
        connect(requestsReply, SIGNAL(finished()), this, SLOT(onGotRequestCount()));
}

void MainWindow::onGotRequestCount()
{

}

void MainWindow::onGotNotificationCount(int count)
{
    if (count == 0)
        ui->pushButton->setText(tr("Notifications"));
    else
        ui->pushButton->setText(tr("Notifications (%1)").arg(count));
}

void MainWindow::createLoginWindow()
{
    if (!loginWindow) {
        loginWindow = new LoginWindow(this);
        connect(loginWindow, SIGNAL(loggedIn(QString)), this, SLOT(onLoggedIn(QString)));
    }
#ifdef Q_WS_S60
    loginWindow->showMaximized();
#else
    loginWindow->show();
#endif
    QTimer::singleShot(100, loginWindow, SLOT(raise()));
}

void MainWindow::onLoggedIn(QString token)
{
    this->accessToken = token;
    this->getMyId();
    QSettings().setValue("main/token", token);
}

void MainWindow::logout()
{
#ifdef Q_WS_MAEMO_5
    QMaemo5InformationBox::information(this, tr("Logging out..."));
#endif
    QSettings().remove("main/token");
    QSettings().remove("main/myName");
    QSettings().remove("main/myId");
    this->deleteWindows();
    QTimer::singleShot(1000, this, SLOT(createLoginWindow()));
}

void MainWindow::getMyId()
{
    qfacebook = new QFacebook(accessToken, this);
    this->reply = qfacebook->getObject("me&fields=id,name");
    if (this->reply)
        connect(reply, SIGNAL(finished()), this, SLOT(onGetMyIdReply()));
}

void MainWindow::onGetMyIdReply()
{
    QVariant jsonData = this->reply->data();
    this->myName = jsonData.toMap().value("name").toString();
    this->myId = jsonData.toMap().value("id").toString();
#ifdef Q_WS_MAEMO_5
    QMaemo5InformationBox::information(this, tr("Logged in as %1").arg(myName));
#endif
    QSettings().setValue("main/myName", this->myName);
    QSettings().setValue("main/myId", this->myId);
    disconnect(reply, SIGNAL(finished()), this, SLOT(onGetMyIdReply()));
    qfacebook->deleteLater();
    notificationsDialog = new NotificationsDialog(this, accessToken);
    connect(ui->pushButton, SIGNAL(clicked()), notificationsDialog, SLOT(show()));
    connect(notificationsDialog, SIGNAL(gotNotificationsCount(int)), this, SLOT(onGotNotificationCount(int)));
}

void MainWindow::onAddToFavoritesClicked()
{
    FriendsWindow *window = new FriendsWindow(this, accessToken);
    window->setAttribute(Qt::WA_DeleteOnClose);
    connect(window, SIGNAL(recepientsSelected(QList<QListWidgetItem*>)), this, SLOT(onFreidnSelected(QList<QListWidgetItem*>)));
    window->requestRecepientsList();
    window->setWindowFlags(Qt::Dialog);
    window->show();
}

void MainWindow::onFreidnSelected(QList<QListWidgetItem*> list)
{
    if (list.count() == 0)
        return;

    QListWidgetItem *item = list.first();
    QListWidgetItem *favItem = new QListWidgetItem(ui->listWidget);
    favItem->setText(item->text());
    favItem->setData(Qt::UserRole, item->data(Qt::UserRole));
    favItem->setIcon(item->icon());
}

void MainWindow::deleteWindows()
{
    if (newsFeedWindow) {
        delete newsFeedWindow;
        newsFeedWindow = 0;
    }
    if (friendsWindow) {
        delete friendsWindow;
        friendsWindow = 0;
    }
    if (albumsWindow) {
        delete albumsWindow;
        albumsWindow = 0;
    }
    if (profileWindow) {
        delete profileWindow;
        profileWindow = 0;
    }
}

#ifdef Q_WS_MAEMO_5
void MainWindow::takeScreenshot()
{
    // True takes a screenshot, false destroys it
    // See http://maemo.org/api_refs/5.0/5.0-final/hildon/hildon-Additions-to-GTK+.html#hildon-gtk-window-take-screenshot
    bool take = true;
    XEvent xev = { 0 };

    xev.xclient.type = ClientMessage;
    xev.xclient.serial = 0;
    xev.xclient.send_event = True;
    xev.xclient.display = QX11Info::display();
    xev.xclient.window = XDefaultRootWindow (xev.xclient.display);
    xev.xclient.message_type = XInternAtom (xev.xclient.display, "_HILDON_LOADING_SCREENSHOT", False);
    xev.xclient.format = 32;
    xev.xclient.data.l[0] = take ? 0 : 1;
    xev.xclient.data.l[1] = this->winId();

    XSendEvent (xev.xclient.display,
                xev.xclient.window,
                False,
                SubstructureRedirectMask | SubstructureNotifyMask,
                &xev);

    XFlush (xev.xclient.display);
    XSync (xev.xclient.display, False);
}
#endif
