#include "checkindialog.h"
#include "ui_checkindialog.h"

CheckinDialog::CheckinDialog(QWidget *parent, QString token) :
    QDialog(parent),
    ui(new Ui::CheckinDialog),
    accessToken(token),
    qfacebook(new QFacebook(token, this))
{
    ui->setupUi(this);
    setAttribute(Qt::WA_DeleteOnClose);
}

CheckinDialog::~CheckinDialog()
{
    delete ui;
}

void CheckinDialog::setCoordinates(double longitude, double latitude)
{
    m_longitude = longitude;
    m_latitude = latitude;
    m_locationString = QString::number(latitude) + "," + QString::number(longitude);
    this->refreshPlaces();
}

void CheckinDialog::refreshPlaces()
{
    reply = qfacebook->getObject(QString("search&type=place&center=%1&distance=1000").arg(m_locationString));
    if (reply)
        connect(reply, SIGNAL(finished()), this, SLOT(onReplyReceived()));
}

void CheckinDialog::onReplyReceived()
{
    if (this->reply->error() != QNetworkReply::NoError) {
        qDebug() << "Failed to fetch places!";
        this->reply->deleteLater();
        this->reply = 0;

        return;
    }

    ui->listWidget->clear();

    QVariant jsonData = this->reply->data();
    qDebug() << jsonData;
    QVariantList listData = jsonData.toMap().value("data").toList();
    foreach (jsonData, listData) {
        QListWidgetItem *item = new QListWidgetItem(ui->listWidget);
        QString id = jsonData.toMap().value("id").toString();
        QString name = jsonData.toMap().value("name").toString();
        QVariant latitude = jsonData.toMap().value("location").toMap().value("latitude");
        QVariant longitude = jsonData.toMap().value("location").toMap().value("longitude");
        item->setData(LocationId, id);
        item->setData(Latitude, latitude);
        item->setData(Longitude, longitude);
        item->setText(name);
    }
}

void CheckinDialog::accept()
{
    QListWidgetItem *selectedItem = ui->listWidget->selectedItems().first();
    emit placeSelected(selectedItem->text(),
                       selectedItem->data(LocationId).toString(),
                       selectedItem->data(Longitude).toString(),
                       selectedItem->data(Latitude).toString());
    this->close();
}
