#include "notificationitem.h"
#include "ui_notificationitem.h"

NotificationItem::NotificationItem(QWidget *parent, QString token, QNetworkAccessManager *nam) :
    QWidget(parent),
    ui(new Ui::NotificationItem),
    accessToken(token),
    nam(nam)
{
    ui->setupUi(this);
    ui->timeLabel->hide();
}

NotificationItem::~NotificationItem()
{
    delete ui;
}

void NotificationItem::setUserId(QString id)
{
    m_userId = id;
    this->getAvatar();
}

void NotificationItem::setUnread(bool isUnread)
{
    m_unread = isUnread;
    if (isUnread) {
        QPalette p = this->palette();
        p.setColor(QPalette::Foreground, p.highlight().color());
        ui->messageLabel->setPalette(p);
    }
}

bool NotificationItem::isUnread()
{
    return m_unread;
}

void NotificationItem::setObjectType(QString objectType)
{
    m_objectType = objectType;
}

void NotificationItem::setText(QString message)
{
    ui->messageLabel->setText(message);
}

void NotificationItem::setObjectId(QString id)
{
    m_objectId = id;
}

void NotificationItem::getAvatar()
{
    QString urlString = QString("https://graph.facebook.com/%1/picture&acccess_token=%2").arg(m_userId, accessToken);
    avatarReply = nam->get(QNetworkRequest(urlString));
    if (avatarReply)
        connect(avatarReply, SIGNAL(finished()), this, SLOT(onAvatarReceived()));
}

void NotificationItem::onAvatarReceived()
{
    QUrl redir = avatarReply->attribute(QNetworkRequest::RedirectionTargetAttribute).toUrl();
    if (!redir.isEmpty()) {
        avatarReply->deleteLater();
        avatarReply = nam->get(QNetworkRequest(redir));

        connect(avatarReply, SIGNAL(finished()), this, SLOT(onAvatarReceived()));
        return;
    }
    QPropertyAnimation *animation = new QPropertyAnimation(ui->avatarLabel, "pos", this);
    animation->setStartValue(QPoint(ui->avatarLabel->x(), ui->avatarLabel->y()-200));
    animation->setEndValue(ui->avatarLabel->pos());
    animation->setDuration(1000);
    animation->setEasingCurve(QEasingCurve::InOutBack);
    animation->start(QPropertyAnimation::DeleteWhenStopped);
    ui->avatarLabel->setPixmap(QPixmap::fromImage(QImage::fromData(avatarReply->readAll())));
    avatarReply->deleteLater();
}

QString NotificationItem::objectId()
{
    return m_objectId;
}

QString NotificationItem::objectType()
{
    return m_objectType;
}

QString NotificationItem::userId()
{
    return m_userId;
}

QString NotificationItem::text()
{
    return ui->messageLabel->text();
}

bool NotificationItem::isPressed()
{
    return m_pressed;
}

void NotificationItem::mousePressEvent(QMouseEvent *ev)
{
    if (ev->button() == Qt::LeftButton) {
        m_pressed = true;
        emit pressed();
    }
}

void NotificationItem::mouseReleaseEvent(QMouseEvent *ev)
{
    if (ev->button() == Qt::LeftButton) {
        m_pressed = false;
        emit released();
        if (rect().contains(ev->pos())) {
            emit clicked(this);
        }
    }
}
