#ifndef MESSAGEVIEW_H
#define MESSAGEVIEW_H

#include <QMainWindow>
#include <QDebug>
#include <QSettings>
#include <qfacebook.h>
#include "newsfeedpost.h"

namespace Ui {
    class MessageView;
}

class MessageView : public QMainWindow
{
    Q_OBJECT

public:
    explicit MessageView(QWidget *parent = 0, QString token = "0");
    ~MessageView();
    void parseMessageById(QString id);

private:
    Ui::MessageView *ui;
    QString accessToken;
    QFacebook *qfacebook;
    QFacebookReply *reply;
    QList<NewsFeedPost*> messages;
    QNetworkAccessManager *nam;
    QString myId;

private slots:
    void onReplyReceived();
};

#endif // MESSAGEVIEW_H
