#ifndef PLACEITEM_H
#define PLACEITEM_H

#include <QWidget>
#include <QNetworkAccessManager>
#include <QMouseEvent>
#include <qfacebook.h>

namespace Ui {
    class PlaceItem;
}

class PlaceItem : public QWidget
{
    Q_OBJECT

public:
    explicit PlaceItem(QWidget *parent = 0, QString token = "0", QNetworkAccessManager *nam = 0);
    ~PlaceItem();
    void setName(QString name);
    void setLocation(QString location);
    void setUserId(QString id);
    void setAvatarUrl(QString url);
    void setTime(QString time);
    bool isPressed();

protected:
    void mousePressEvent(QMouseEvent *);
    void mouseReleaseEvent(QMouseEvent *);

signals:
    void pressed();
    void released();
    void clicked(QString id);

private:
    Ui::PlaceItem *ui;
    QString accessToken;
    QNetworkAccessManager *nam;
    QNetworkReply *avatarReply;
    QString m_userId;
    QString checkinId;
    bool m_pressed;

private slots:
    void onAvatarReceived();
};

#endif // PLACEITEM_H
