#include "placeitem.h"
#include "ui_placeitem.h"

PlaceItem::PlaceItem(QWidget *parent, QString token, QNetworkAccessManager *nam) :
    QWidget(parent),
    ui(new Ui::PlaceItem),
    accessToken(token),
    nam(nam)
{
    ui->setupUi(this);
}

PlaceItem::~PlaceItem()
{
    delete ui;
}

void PlaceItem::setName(QString name)
{
    ui->nameLabel->setText(name);
}

void PlaceItem::setLocation(QString location)
{
    ui->locationLabel->setText(location);
}

void PlaceItem::setTime(QString time)
{
    ui->timeLabel->setText(time);
}

void PlaceItem::setUserId(QString id)
{
    m_userId = id;
}

void PlaceItem::setAvatarUrl(QString url)
{
    avatarReply = nam->get(QNetworkRequest(url));
    if (avatarReply)
        connect(avatarReply, SIGNAL(finished()), this, SLOT(onAvatarReceived()));
}

void PlaceItem::onAvatarReceived()
{
    QUrl redir = avatarReply->attribute(QNetworkRequest::RedirectionTargetAttribute).toUrl();
    if (!redir.isEmpty()) {
        avatarReply->deleteLater();
        avatarReply = nam->get(QNetworkRequest(redir));

        connect(avatarReply, SIGNAL(finished()), this, SLOT(onAvatarReceived()));
        return;
    }
    ui->avatarLabel->setPixmap(QPixmap::fromImage(QImage::fromData(avatarReply->readAll())));
    avatarReply->deleteLater();
}

void PlaceItem::mousePressEvent(QMouseEvent *ev)
{
    if (ev->button() == Qt::LeftButton) {
        m_pressed = true;
        emit pressed();
    }
}

void PlaceItem::mouseReleaseEvent(QMouseEvent *ev)
{
    if (ev->button() == Qt::LeftButton) {
        m_pressed = false;
        emit released();
        if (rect().contains(ev->pos())) {
            emit clicked(checkinId);
        }
    }
}

bool PlaceItem::isPressed()
{
    return m_pressed;
}
