#ifndef PHOTOWINDOW_H
#define PHOTOWINDOW_H

#include <QMainWindow>
#include <QNetworkAccessManager>
#include <QDebug>
#include <qfacebook.h>

namespace Ui {
    class PhotoWindow;
}

class PhotoWindow : public QMainWindow
{
    Q_OBJECT

public:
    explicit PhotoWindow(QWidget *parent = 0, QString token = "0");
    ~PhotoWindow();
    void showPhoto(QString photoId);
    void setPhoto(QString filename);
    void showPhotoFromId(QString id);

private:
    Ui::PhotoWindow *ui;
    QFacebook *qfacebook;
    QNetworkReply *reply;
    QString accessToken;
    QNetworkAccessManager *nam;
    QString photoId;

private slots:
    void onReplyReceived();
    void onClicked(QPoint);
};

#endif // PHOTOWINDOW_H
