#ifndef NEWSFEEDPOST_H
#define NEWSFEEDPOST_H

#include <QWidget>
#include <QNetworkAccessManager>
#include <QDesktopWidget>
#include <QDebug>
#include <QDateTime>
#include <QPainter>
#include <QMainWindow>
#ifdef Q_WS_MAEMO_5
    #include <QMaemo5InformationBox>
#endif
#include <qfacebook.h>

namespace Ui {
    class NewsFeedPost;
}

class NewsFeedPost : public QWidget
{
    Q_OBJECT

public:
    explicit NewsFeedPost(QWidget *parent = 0, QString token = "0", QFacebook *qfacebook = 0, QNetworkAccessManager *nam = 0);
    ~NewsFeedPost();
    void setName(QString name);
    void setDate(QString date);
    void setAvatar(QPixmap pixmap);
    void setMessage(QString message);
    void setId(QString id);
    void getPixmapFromUrl(QString pixmapUrl);
    void setIconFromUrl(QString url);
    void setNumberOfLikesComments(QString likes, QString comments);
    void hideBottomBar(bool hide);
    void setLikedByMe(bool liked);
    void setTime(QString time);
    void setDeletable(bool deletable);
    void setUserId(QString id);
    void setCommentMode(bool isComment);
    void setMessageMode(bool isMessage);
    void setTimeFromString(QString timeAsString);

protected:
    void paintEvent(QPaintEvent *);
    void resizeEvent(QResizeEvent *);
    void mousePressEvent(QMouseEvent *);
    void mouseReleaseEvent(QMouseEvent *);

signals:
    void commentButtonClicked(QString id, QString comments, QString likes);
    void likeButtonClicked(QString id, QString comments, QString likes);
    void nameClicked(QString id, QString name);
    void clicked(QString id);
    void pressed();
    void released();

private:
    Ui::NewsFeedPost *ui;
    QString accessToken;
    QFacebook *qfacebook;
    QFacebookReply *reply;
    QNetworkReply *deleteReply;
    QString id;
    QNetworkAccessManager *nam;
    QString comments;
    QString likes;
    QString userId;
    bool isLikedByMe;
    bool isDeletable;
    bool isComment;
    bool m_pressed;

private slots:
    void avatarReceived();
    void iconReceived();
    void orientationChanged();
    void onLikeButtonClicked();
    void onCommentButtonClicked();
    void onLikeReplyReceived();
    void onDeleteButtonClicked();
    void onDeleteReplyReceived();
    void onNameClicked();
};

#endif // NEWSFEEDPOST_H
