#ifndef MAINWINDOW_H
#define MAINWINDOW_H

#include <QMainWindow>
#include <QTimer>
#include <QSettings>
#include <QListWidgetItem>
#include <QNetworkReply>
#include <QNetworkAccessManager>
#include "loginwindow.h"
#include "friendswindow.h"
#include "newsfeedwindow.h"
#include "messageswindow.h"
#include "albumswindow.h"
#include "notificationsdialog.h"
#include "groupswindow.h"
#include "eventswindow.h"
#include "placeswindow.h"
#include "delegates/thumbnailitemdelegate.h"

namespace Ui {
    class MainWindow;
}

class MainWindow : public QMainWindow
{
    Q_OBJECT

public:
    explicit MainWindow(QWidget *parent = 0);
    ~MainWindow();

private:
    Ui::MainWindow *ui;
    void connectSignals();
    QString accessToken;
    QString myId;
    QString myName;
    QFacebook *qfacebook;
    QFacebookReply *reply;
    NewsFeedWindow *newsFeedWindow;
    FriendsWindow *friendsWindow;
    AlbumsWindow *albumsWindow;
    ProfileWindow *profileWindow;
    GroupsWindow *groupsWindow;
    LoginWindow *loginWindow;
    EventsWindow *eventsWindow;
    NotificationsDialog *notificationsDialog;
    QNetworkAccessManager *nam;
    QNetworkReply *requestsReply;
    void getMyId();

private slots:
    void createLoginWindow();
    void logout();
    void deleteWindows();
    void onLoggedIn(QString token);
    void onItemActivated(QListWidgetItem *item);
    void orientationChanged();
    void onGetMyIdReply();
    void createFavorites();
    void onGotNotificationCount(int count);
    void getRequestsCount();
    void onGotRequestCount();

#ifdef Q_WS_MAEMO_5
    void takeScreenshot();
#endif
};

#endif // MAINWINDOW_H
