#include "albumwindow.h"
#include "ui_albumwindow.h"

AlbumWindow::AlbumWindow(QWidget *parent, QString token) :
    QMainWindow(parent),
    ui(new Ui::AlbumWindow),
    qfacebook(new QFacebook(token, this)),
    accessToken(token),
    nam(new QNetworkAccessManager(this))
{
    ui->setupUi(this);
    setAttribute(Qt::WA_DeleteOnClose);
    connect(ui->actionUpload_photo, SIGNAL(triggered()), this, SLOT(uploadPhoto()));
#ifdef Q_WS_MAEMO_5
    setAttribute(Qt::WA_Maemo5StackedWindow);
#endif
}

AlbumWindow::~AlbumWindow()
{
    delete ui;
}

void AlbumWindow::browseAlbum(QString id, QString albumCount)
{
    this->albumId = id;
    this->albumCount = albumCount;
    this->updateAlbum();
}

void AlbumWindow::uploadPhoto()
{
    ImageUploadDialog *dialog = new ImageUploadDialog(this);
    dialog->show();
}

void AlbumWindow::updateAlbum()
{
#ifdef Q_WS_MAEMO_5
    setAttribute(Qt::WA_Maemo5ShowProgressIndicator, true);
#endif
    this->reply = qfacebook->getObject(this->albumId + QString("/photos&fields=images&limit=40"));
    if (this->reply)
        connect(reply, SIGNAL(finished()), this, SLOT(onReplyReceived()));
}

void AlbumWindow::onReplyReceived()
{
    ui->photoList->clear();

    if (this->reply->error() != QNetworkReply::NoError) {
        qDebug() << "Failed to fetch album!";
        this->reply->deleteLater();
        this->reply = 0;
#ifdef Q_WS_MAEMO_5
    setAttribute(Qt::WA_Maemo5ShowProgressIndicator, false);
#endif
        return;
    }

    QVariant jsonData = this->reply->data();
    QVariantList listData;
    listData = jsonData.toMap().value("data").toList();
    foreach(jsonData, listData) {
        QVariantList imagesList = jsonData.toMap().value("images").toList();
        foreach (QVariant imageVariant, imagesList) {
            QString imageUrl = imageVariant.toMap().value("source").toString();
            if (!imageUrl.endsWith("n.jpg"))
                break;
            QListWidgetItem *item = new QListWidgetItem("", ui->photoList);
            item->setTextAlignment(Qt::AlignCenter);
            Image *image = new Image(this, item);
            connect(image, SIGNAL(imageProcessed(QString,QPixmap)), this, SLOT(onImageProcessed(QString,QPixmap)));
            QNetworkReply *reply =
                    nam->get(QNetworkRequest(imageUrl));
            connect(reply, SIGNAL(finished()), image, SLOT(imageReceived()));
        }
    }

#ifdef Q_WS_MAEMO_5
    setAttribute(Qt::WA_Maemo5ShowProgressIndicator, false);
#endif

    reply->deleteLater();
}

void AlbumWindow::onImageProcessed(QString id, QPixmap pixmap)
{
    for (int i = 0; i < ui->photoList->count(); i++) {
        if (ui->photoList->item(i)->data(Qt::UserRole).toString() == id)
            ui->photoList->item(i)->setIcon(QIcon(pixmap));
    }
}

Image::Image(QWidget *parent, QListWidgetItem *item) :
    item(item)
{
    this->setParent(parent);
}

Image::~Image() {}

void Image::imageReceived()
{
    QNetworkReply *reply = qobject_cast<QNetworkReply*>(sender());
    QUrl redir = reply->attribute(QNetworkRequest::RedirectionTargetAttribute).toUrl();
    if (!redir.isEmpty()) {
        reply->deleteLater();
        QNetworkAccessManager *nam = qobject_cast<QNetworkAccessManager*>(sender()->parent());
        QNetworkReply *reply = nam->get(QNetworkRequest(redir));

        connect(reply, SIGNAL(finished()), this, SLOT(imageReceived()));
        return;
    }
    item->setIcon(QIcon(QPixmap::fromImage(QImage::fromData(reply->readAll()))));
    //emit imageProcessed(this->id, QPixmap::fromImage(QImage::fromData(reply->readAll())));
    reply->deleteLater();
    this->deleteLater();
}
