#include "qclickablelabel.h"

QClickableLabel::QClickableLabel(QWidget *parent) :
    QLabel(parent)
{
}

void QClickableLabel::mousePressEvent(QMouseEvent *ev)
{
    if (ev->button() == Qt::LeftButton) {
        this->labelPressed = true;
        emit pressed();
    }
}

void QClickableLabel::mouseReleaseEvent(QMouseEvent *ev)
{
    if (ev->button() == Qt::LeftButton) {
        this->labelPressed = false;
        emit released();
        if (rect().contains(ev->pos())) {
            emit clicked();
            emit clickedPos(ev->pos());
        }
    }
}

bool QClickableLabel::isPressed()
{
    return labelPressed;
}

void QClickableLabel::setData(QVariant data)
{
    this->variant = data;
}

QVariant QClickableLabel::data()
{
    return variant;
}
