/* Based on qobi-wmhint-fix (http://talk.maemo.org/showpost.php?p=429114&postcount=23) and set-focus (http://talk.maemo.org/showpost.php?p=429703&postcount=29) by qobi */
#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <stdio.h>
#include <stdlib.h>

int main(int argc, char **argv) {
	Display *display;
	Window window = 0;
	XWMHints *input_hints;
	
	if (argc!=2) {
		fprintf(stderr, "usage: set-focus <id>\n");
		exit(EXIT_FAILURE);
	}
	if (sscanf(argv[1], "0x%lx", &window)!=1) {
		fprintf(stderr, "id must be in parsable by 0x%%lx\n");
		exit(EXIT_FAILURE);
	}
	
	display = XOpenDisplay("");
	if (display==NULL) {
		fprintf(stderr, "can't open display\n");
		exit(EXIT_FAILURE);
	}
	
	input_hints = XGetWMHints(display, window);
	if (input_hints==NULL) {
		XWMHints input_hints = { .input = True, .flags = InputHint };
		XSetWMHints(display, window, &input_hints);
	}
	else {
		input_hints->input = True;
		input_hints->flags |= InputHint;
		XSetWMHints(display, window, input_hints);
		XFree(input_hints);
	}
	XSetInputFocus(display, window, RevertToParent, CurrentTime);
	XFlush(display);
	return EXIT_SUCCESS;
	}
