#ifndef OPTIONWIDGET_H
#define OPTIONWIDGET_H

#include <QWidget>

class QComboBox;
class QCheckBox;
class QPushButton;
class QStackedLayout;

class OptionWidget : public QWidget
{
    Q_OBJECT
public:
    explicit OptionWidget(QWidget *parent = 0);

signals:

    void optionDone();

public slots:

private:

    QWidget* optionWidget();

    void setCurrentSpeed();

private slots:

    void speedChanged(const QString& aText);

    void accelerometerChanged( int aNewState );

    void keyboardDone();

    void changeKeyboardSetting();

private://data

    QComboBox* mComboBox;
    QCheckBox* mAccelerometerCheckBox;
    QPushButton* mKeyboardBtn;

    QWidget* mOptionWidget;
    QWidget* mKeyboardWidget;

    QStackedLayout* mStackLayout;

};

#endif // OPTIONWIDGET_H
