import time
import os
import dbus
import gobject
from dbus.mainloop.glib import DBusGMainLoop
import gtk
import hildondesktop
import hildon
from sqlite3 import dbapi2 as sqlite

# set the database variables - assumption: we are running on PR1.2 release software
# rtcom_database = '/home/user/.rtcom-eventlogger/el-v1.db'
# sql_template = "SELECT sum(CASE WHEN length(free_text)>160 THEN length(free_text) / 153 + 1 ELSE 1 END) FROM Events WHERE service_id=3 AND event_type_id=7 AND outgoing=%d AND start_time>%d"
# outgoing = 1 
# incoming = 0

# test if the rtcom database exists
# if not, set variables to correct values for PR1.1 and sales release
# if not os.path.exists(rtcom_database):
rtcom_database = '/home/user/.rtcom-eventlogger/el.db'
sql_template = "SELECT sum(CASE WHEN length(free_text)>160 THEN length(free_text) / 153 + 1 ELSE 1 END) FROM Events WHERE service_id=3 AND event_type_id=%d AND start_time>%d"
outgoing = 8 
incoming = 7

class sms_counter():
	def __init__(self):
		self.sent_messages = 0
		self.received_messages = 0

	def update_counters(self, start_time):
		conn = sqlite.connect(rtcom_database)
		sql_query = sql_template %(outgoing, start_time)
		results = conn.execute(sql_query)
		self.sent_messages = results.fetchone()[0]
		sql_query = sql_template %(incoming, start_time)
		results = conn.execute(sql_query)
		self.received_messages = results.fetchone()[0]
		conn.close()

class SMS_widget(hildondesktop.HomePluginItem):
	def callback_function(self, button, data=""):
		self.update_widget()

	def __init__(self):
		hildondesktop.HomePluginItem.__init__(self)
		self.set_settings(True)
		self.connect("show-settings", self.show_settings)

		self.this_month = sms_counter()
		self.all = sms_counter()
		self.period_start = 1    #operators might have different invoicing periods, user can change this through settings

		self.table = gtk.Table(4,3,False)

		self.this_month_sent = gtk.Label('0')
		self.this_month_received = gtk.Label('0')
		self.this_month_total = gtk.Label('0')
		self.all_sent = gtk.Label('0')
		self.all_received = gtk.Label('0')
		self.all_total = gtk.Label('0')
#		self.button = gtk.Button("Update")
#		self.button.connect("clicked", self.update_widget)

		self.table.attach(self.this_month_sent, 1, 2, 1, 2)
		self.table.attach(self.this_month_received, 1, 2, 2, 3)
		self.table.attach(self.this_month_total, 1, 2, 3, 4)
		self.table.attach(self.all_sent, 2, 3, 1, 2)
		self.table.attach(self.all_received, 2, 3, 2, 3)
		self.table.attach(self.all_total, 2, 3, 3, 4)
#		self.table.attach(self.button, 0, 1, 0, 1)
		
		self.sent_title = gtk.Label('Sent SMSs')
		self.box_for_sent = gtk.HBox()
		self.box_for_sent.pack_end(self.sent_title, False, False)
		self.table.attach(self.box_for_sent, 0, 1, 1, 2, xpadding=6)

		self.received_title = gtk.Label('Received SMSs')
		self.box_for_received = gtk.HBox()
		self.box_for_received.pack_end(self.received_title, False, False)
		self.table.attach(self.box_for_received, 0, 1, 2, 3, xpadding=6)

		self.total_title = gtk.Label('Total SMSs')
		self.box_for_total = gtk.HBox()
		self.box_for_total.pack_end(self.total_title, False, False)
		self.table.attach(self.box_for_total, 0, 1, 3, 4, xpadding=6)

		self.table.attach(gtk.Label('Month'), 1, 2, 0, 1, xpadding=6)
		self.table.attach(gtk.Label('All-time'), 2, 3, 0, 1, xpadding=6)

		self.update_widget()
		self.table.show_all()
		self.add(self.table)

		self.listen()

	def update_widget(self, dummy1="", dummy2="", dummy3="", dummy4="", dummy5=""):
		t = time.localtime(time.time())
		if t[2] < self.period_start:
                        if t[1] == 1:
                                # need to roll back one year, and to the period start day in December
                                self.this_month.update_counters(time.mktime((t[0]-1, 12, self.period_start, 0, 0, 0, 0, 0, t[8])))
                        else:
                                # rolling back to period start day in previous month
                                self.this_month.update_counters(time.mktime((t[0], t[1]-1, self.period_start, 0, 0, 0, 0, 0, t[8])))
                else:        
                        self.this_month.update_counters(time.mktime((t[0], t[1], self.period_start, 0, 0, 0, 0, 0, t[8])))
		self.all.update_counters(0)
		self.this_month_sent.set_text(str(self.this_month.sent_messages))
		self.this_month_received.set_text(str(self.this_month.received_messages))
		self.this_month_total.set_text(str(self.this_month.sent_messages + self.this_month.received_messages))
		self.all_sent.set_text(str(self.all.sent_messages))
		self.all_received.set_text(str(self.all.received_messages))
		self.all_total.set_text(str(self.all.sent_messages + self.all.received_messages))

	def listen(self):
		DBusGMainLoop(set_as_default=True)
		self.bus = dbus.SystemBus()
		self.bus.add_signal_receiver(self.update_widget, path='/com/nokia/phone/SMS', dbus_interface='Phone.SMS', signal_name='IncomingSegment')
		self.bus.add_signal_receiver(self.update_widget, path='/com/nokia/phone/SMS/ba212ae1', dbus_interface='com.nokia.csd.SMS.Outgoing', signal_name='OutgoingSegment')

        def show_settings(self, widget):
                dialog = gtk.Dialog()
                dialog.set_transient_for(self)
                dialog.set_title("SMS Counter Settings")
                dialog.add_button("Save", gtk.RESPONSE_OK)
                selector = hildon.TouchSelector(text = True)
                for i in range(1,28):     # works for all months, if 29th or 30th are needed, then some extra logic needs to be inserted in the code
                        selector.append_text("%d" % (i))
                num_itemsPicker = hildon.PickerButton(gtk.HILDON_SIZE_AUTO_WIDTH | gtk.HILDON_SIZE_FINGER_HEIGHT, hildon.BUTTON_ARRANGEMENT_VERTICAL)
                num_itemsPicker.set_title("First day of period")
                num_itemsPicker.set_selector(selector)
                num_itemsPicker.set_alignment(0.0, 0.5, 1.0, 1.0)
                num_itemsPicker.set_active(self.period_start-1)
                dialog.vbox.add(num_itemsPicker)

                dialog.show_all()
                response = dialog.run()
                dialog.destroy()

                if response == gtk.RESPONSE_OK:
                        new_period_start = num_itemsPicker.get_active() + 1
                        if new_period_start != self.period_start:
                                self.period_start = new_period_start
                                self.update_widget()

hd_plugin_type = SMS_widget

if __name__ == "__main__":
	import gobject
	gobject.type_register(hd_plugin_type)
	obj = gobject.new(hd_plugin_type, plugin_id="SMS_counter")
	obj.show_all()
	gobject.MainLoop().run()
#	gtk.main()

