#!/usr/bin/python
# -*- coding: utf-8 -*-

__author__="nerdknight"
__date__ ="$06/03/2011 00:40:36$"

from PyQt4 import QtCore, QtGui, QtMaemo5
import sys
import pexpect
import threading
from graph import Graph
import calendar
from datetime import datetime,timedelta
from time import mktime
DB_FILE="/home/user/.rtcom-eventlogger/el-v1.db"
EVT_SMS="""RTCOM_EL_EVENTTYPE_SMS_MESSAGE"""
EVT_CALL="""RTCOM_EL_EVENTTYPE_CALL"""
EVT_CALL_MISS="""RTCOM_EL_EVENTTYPE_CALL_MISSED"""
EVT_CALL_VOICEMAIL="""RTCOM_EL_EVENTTYPE_CALL_VOICEMAIL"""
def getSQL(sqlstr):
    #print sqlstr
    sql=pexpect.spawn("sqlite3",[DB_FILE,sqlstr])
    res=sql.readline()
    sql.sendeof()
    return res
def getSQLTot(evt_type):
    sql="""select count(id) from Events where event_type_id=(select id from EventTypes where name=\""""
    sql+=evt_type+"""\")"""
    return sql
def getDateFilter(date,greater):
    res=""
    if date!=None:
        res=" AND storage_time"
        if greater==True:
            res=res+">="
        else:
            res=res+"<="
        res=res+str(date)
    return res

def getSentSMS(d1=None,d2=None):
    sqlstr=getSQLTot(EVT_SMS)+getDateFilter(d1,True)+getDateFilter(d2,False)+ """ AND outgoing=1"""
    return int(getSQL(sqlstr))
def getReceivedSMS(d1=None,d2=None):
    sqlstr=getSQLTot(EVT_SMS)+getDateFilter(d1,True)+getDateFilter(d2,False) + """   AND outgoing=0"""
    return int(getSQL(sqlstr))
def getSpamSMS(d1=None,d2=None):
    sqlstr=getSQLTot(EVT_SMS)+ getDateFilter(d1,True)+getDateFilter(d2,False)+ """ AND length(remote_uid)<=5"""
    return int(getSQL(sqlstr))

def getMadeCalls(d1=None,d2=None):
    sqlstr=getSQLTot(EVT_CALL)+getDateFilter(d1,True)+getDateFilter(d2,False)+ """ AND outgoing=1"""
    return int(getSQL(sqlstr))
def getReceivedCalls(d1=None,d2=None):
    sqlstr=getSQLTot(EVT_CALL)+getDateFilter(d1,True)+getDateFilter(d2,False) + """   AND outgoing=0"""
    return int(getSQL(sqlstr))
def getMissedCalls(d1=None,d2=None):
    sqlstr=getSQLTot(EVT_CALL_MISS)+getDateFilter(d1,True)+getDateFilter(d2,False) + """   AND outgoing=0"""
    return int(getSQL(sqlstr))
def getMinDate():
    d=None
    sqlstr="""select min(storage_time) from Events;"""
    d=int(getSQL(sqlstr))
    d=datetime.fromtimestamp(d)
    return d
def strDateToBD(dateStr):
    d=datetime.strptime(dateStr,"%d.%m.%Y")
    d=d.replace(hour=0,minute=0,second=0)
    d1=int(mktime(d.timetuple()))
    return d1
def datetimeToBD(dt):
    return int(mktime(dt.timetuple()))

class About(object):
    def setupUi(self, Form):
        Form.setObjectName("About")
        Form.resize(400, 300)
        self.verticalLayout = QtGui.QVBoxLayout(Form)
        self.verticalLayout.setObjectName("verticalLayout")
        self.label = QtGui.QLabel(Form)
        self.label.setAlignment(QtCore.Qt.AlignCenter)
        self.label.setObjectName("label")
        self.verticalLayout.addWidget(self.label)

        self.retranslateUi(Form)
        QtCore.QMetaObject.connectSlotsByName(Form)

    def retranslateUi(self, Form):
        Form.setWindowTitle(QtGui.QApplication.translate("About", "About", None, QtGui.QApplication.UnicodeUTF8))
        self.label.setText(QtGui.QApplication.translate("About", "<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.0//EN\" \"http://www.w3.org/TR/REC-html40/strict.dtd\">\n"
"<html><head><meta name=\"qrichtext\" content=\"1\" /><style type=\"text/css\">\n"
"p, li { white-space: pre-wrap; }\n"
"</style></head><body style=\" font-family:\'Ubuntu\'; font-size:11pt; font-weight:400; font-style:normal;\">\n"
"<p align=\"center\" style=\" margin-top:0px; margin-bottom:0px; margin-left:0px; margin-right:0px; -qt-block-indent:0; text-indent:0px;\"><span style=\" font-size:16pt; font-weight:600;\">SMS Counter</span></p>\n"
"<p align=\"center\" style=\" margin-top:0px; margin-bottom:0px; margin-left:0px; margin-right:0px; -qt-block-indent:0; text-indent:0px;\"><span style=\" font-size:12pt; font-weight:600;\">v0.1</span></p>\n"
"<p align=\"center\" style=\"-qt-paragraph-type:empty; margin-top:0px; margin-bottom:0px; margin-left:0px; margin-right:0px; -qt-block-indent:0; text-indent:0px; font-size:12pt; font-weight:600;\"></p>\n"
"<p align=\"center\" style=\" margin-top:0px; margin-bottom:0px; margin-left:0px; margin-right:0px; -qt-block-indent:0; text-indent:0px;\"><img src=\"/usr/share/icons/hicolor/64x64/hildon/smscounter.png\" /></p>\n"
"<p align=\"center\" style=\"-qt-paragraph-type:empty; margin-top:0px; margin-bottom:0px; margin-left:0px; margin-right:0px; -qt-block-indent:0; text-indent:0px; font-size:12pt; font-weight:600;\"></p>\n"
"<p align=\"center\" style=\" margin-top:0px; margin-bottom:0px; margin-left:0px; margin-right:0px; -qt-block-indent:0; text-indent:0px;\">by NerdKnight </p>\n"
"<p align=\"center\" style=\" margin-top:0px; margin-bottom:0px; margin-left:0px; margin-right:0px; -qt-block-indent:0; text-indent:0px;\">&lt;<a href=\"mailto:nerdknight@gmail.com\">nerdknight@gmail.com</a>&gt;</p></body></html>", None, QtGui.QApplication.UnicodeUTF8))

class QueryThread(threading.Thread):
    def __init__(self,mainW):
        threading.Thread.__init__(self)
        self.mainW=mainW
    def run(self):
        self.mainW.query()

class Data(object):
    def __init__(self):
        self.d1=None
        self.d2=None
        self.rSms=0
        self.sSms=0
        self.cSms=0
        self.rCalls=0
        self.sCalls=0
        self.mCalls=0
    def getPeriod(self):
        res=""  
        if self.d1.year==self.d2.year and self.d1.month==self.d2.month and self.d1.day==1 and self.d2.day==calendar.monthrange(self.d2.year,self.d2.month)[1]:
            res=self.d1.strftime("%b %Y")
        else:
            res=self.d1.strftime("%x")+" - "+self.d2.strftime("%x")
        return res
    def fillData(self):
        d1=datetimeToBD(self.d1)
        d2=datetimeToBD(self.d2)
        self.rSms=getReceivedSMS(d1,d2)
        self.sSms=getSentSMS(d1,d2)
        self.cSms=getSpamSMS(d1,d2)
        self.rCalls=getReceivedCalls(d1,d2)
        self.sCalls=getMadeCalls(d1,d2)
        self.mCalls=getMissedCalls(d1,d2)
        
class MainWidget(object):
    def setupUi(self, Form):
	self.mw=Form
        Form.setObjectName("Form")
        Form.resize(421, 372)
        self.gridLayout = QtGui.QGridLayout(Form)
        self.gridLayout.setObjectName("gridLayout")
        self.pnlTab = QtGui.QTabWidget(Form)
        self.pnlTab.setObjectName("pnlTab")
        self.pnlTab.setTabPosition(QtGui.QTabWidget.West)
        self.tab = QtGui.QWidget()
        self.tab.setObjectName("tab")        
        self.gridLayout.addWidget(self.pnlTab, 1, 0, 1, 1)
        self.gridLayout_2 = QtGui.QGridLayout()
        self.gridLayout_2.setObjectName("gridLayout_2")
        self.btnGo = QtGui.QPushButton(Form)
        sizePolicy = QtGui.QSizePolicy(QtGui.QSizePolicy.Fixed, QtGui.QSizePolicy.Fixed)
        sizePolicy.setHorizontalStretch(0)
        sizePolicy.setVerticalStretch(0)
        sizePolicy.setHeightForWidth(self.btnGo.sizePolicy().hasHeightForWidth())
        self.btnGo.setSizePolicy(sizePolicy)
        self.btnGo.setObjectName("btnGo")
        self.gridLayout_2.addWidget(self.btnGo, 0, 4, 1, 1)
        self.fromDate=QtMaemo5.QMaemo5DatePickSelector()
        self.fromDate.setObjectName("fromDate")
        self.btnFrom=QtMaemo5.QMaemo5ValueButton()
        self.btnFrom.setPickSelector(self.fromDate)
        self.gridLayout_2.addWidget(self.btnFrom, 0, 1, 1, 1)
        self.toDate=QtMaemo5.QMaemo5DatePickSelector()
        self.toDate.setObjectName("toDate")
        self.btnTo=QtMaemo5.QMaemo5ValueButton()
        self.btnTo.setPickSelector(self.toDate)
        self.gridLayout_2.addWidget(self.btnTo, 0, 3, 1, 1)
        self.chkFrom = QtGui.QCheckBox(Form)
        sizePolicy = QtGui.QSizePolicy(QtGui.QSizePolicy.Fixed, QtGui.QSizePolicy.Fixed)
        sizePolicy.setHorizontalStretch(0)
        sizePolicy.setVerticalStretch(0)
        sizePolicy.setHeightForWidth(self.chkFrom.sizePolicy().hasHeightForWidth())
        self.chkFrom.setSizePolicy(sizePolicy)
        self.chkFrom.setText("")
        self.chkFrom.setObjectName("chkFrom")
        self.gridLayout_2.addWidget(self.chkFrom, 0, 0, 1, 1)
        self.chkTo = QtGui.QCheckBox(Form)
        sizePolicy = QtGui.QSizePolicy(QtGui.QSizePolicy.Fixed, QtGui.QSizePolicy.Fixed)
        sizePolicy.setHorizontalStretch(0)
        sizePolicy.setVerticalStretch(0)
        sizePolicy.setHeightForWidth(self.chkTo.sizePolicy().hasHeightForWidth())
        self.chkTo.setSizePolicy(sizePolicy)
        self.chkTo.setText("")
        self.chkTo.setObjectName("chkTo")
        self.gridLayout_2.addWidget(self.chkTo, 0, 2, 1, 1)
        self.gridLayout.addLayout(self.gridLayout_2, 0, 0, 1, 1)

        self.dataWidget=DataWidget(Form)
        self.pnlTab.addTab(self.dataWidget, "Totals")
        self.dataGraph=DataGraph(Form)
        self.pnlTab.addTab(self.dataGraph, "Graph")
	
	self.menuBar = QtGui.QMenuBar(Form)
	self.actionAbout = QtGui.QAction(Form)
        self.actionAbout.setObjectName("actionAbout")
        self.menuBar.addAction(self.actionAbout)
	self.actionExit = QtGui.QAction(Form)
        self.actionExit.setObjectName("actionExit")
        self.menuBar.addAction(self.actionExit)

	QtCore.QObject.connect(self.menuBar, QtCore.SIGNAL("triggered(QAction*)"), self.menuEvt)

        self.retranslateUi(Form)
        self.pnlTab.setCurrentIndex(0)
        QtCore.QMetaObject.connectSlotsByName(Form)
        QtCore.QObject.connect(self.btnGo, QtCore.SIGNAL("clicked()"), self.btnGoAction)

    def retranslateUi(self, Form):
        Form.setWindowTitle(QtGui.QApplication.translate("Form", "SMS Counter", None, QtGui.QApplication.UnicodeUTF8))
        self.btnFrom.setText("From")
        self.btnTo.setText("To")
	self.actionAbout.setText("About")
	self.actionExit.setText("Exit")
        self.btnGo.setText(QtGui.QApplication.translate("Form", "Go!", None, QtGui.QApplication.UnicodeUTF8))
    
    def menuEvt(self,qa):
        if qa==self.actionExit:
            self.mw.close()
        elif qa==self.actionAbout:
            Form = QtGui.QDialog(self.mw)
            ui = About()
            ui.setupUi(Form)
            Form.setModal(True)
            Form.show()

    def getFrom(self):
        d1=None
        if self.chkFrom.checkState():
            d1=strDateToBD(str(self.fromDate.currentDate().toString("dd.MM.yyyy")))
        return d1
    def getTo(self):
        d1=None
        if self.chkTo.checkState():
            d1=strDateToBD(str(self.toDate.currentDate().toString("dd.MM.yyyy")))
        return d1
    def btnGoAction(self):
        t=QueryThread(self)
        t.start()
    def query(self):
	self.btnGo.setEnabled(False)
	self.btnGo.setText("Wait")
	self.pnlTab.setEnabled(False)
        dF=None
        dT=None
        if self.chkFrom.checkState():
            d=self.fromDate.currentDate()
            dF=datetime(d.year(),d.month(),d.day())
        if dF==None:
            dF=getMinDate()
        if self.chkTo.checkState():
            d=self.toDate.currentDate()
            dT=datetime(d.year(),d.month(),d.day())
        if dT==None:
            dT=datetime.now()
        d1=dF
        td=timedelta(microseconds=1)
        data=[]
        ld=calendar.monthrange(d1.year,d1.month)[1]
        d2=datetime(d1.year,d1.month,ld,23,59,59,999999)
        while d2<dT:
            dat=Data()
            dat.d1=d1
            dat.d2=d2
            dat.fillData()
            data.append(dat)
            d1=d2+td
            ld=calendar.monthrange(d1.year,d1.month)[1]
            d2=datetime(d1.year,d1.month,ld,23,59,59,999999)
        d2=dT
        dat=Data()
        dat.d1=d1
        dat.d2=d2
        dat.fillData()
        data.append(dat)
        self.dataWidget.query(data)
        self.dataGraph.query(data)
        self.btnGo.setText("Go!")
	self.pnlTab.setEnabled(True)
	self.btnGo.setEnabled(True)
class DataWidget(QtGui.QWidget):
    def __init__(self, parent=None):
        QtGui.QWidget.__init__(self, parent)
        self.gridLayout = QtGui.QGridLayout(self)
        self.gridLayout.setObjectName("gridLayout")
        
        self.lblTotSMS = QtGui.QLabel(self)
        self.lblTotSMS.setObjectName("lblTotSMS")
        self.gridLayout.addWidget(self.lblTotSMS, 3, 0, 1, -1)
        self.lblSentSMS = QtGui.QLabel(self)
        self.lblSentSMS.setObjectName("lblSentSMS")
        self.gridLayout.addWidget(self.lblSentSMS, 2, 0, 1, -1)
        self.lblReceivedSMS = QtGui.QLabel(self)
        self.lblReceivedSMS.setObjectName("lblReceivedSMS")
        self.gridLayout.addWidget(self.lblReceivedSMS, 1, 0, 1, 1)
        self.lblSpamSMS = QtGui.QLabel(self)
        self.lblSpamSMS.setObjectName("lblSpamSMS")
        self.gridLayout.addWidget(self.lblSpamSMS, 1, 1, 1, 1)

	self.lblTotCalls = QtGui.QLabel(self)
        self.lblTotCalls.setObjectName("lblTotCalls")
        self.gridLayout.addWidget(self.lblTotCalls, 7, 0, 1, -1)
        self.lblMadeCalls = QtGui.QLabel(self)
        self.lblMadeCalls.setObjectName("lblMadeCalls")
        self.gridLayout.addWidget(self.lblMadeCalls, 6, 0, 1,-1)
        self.lblMissedCalls = QtGui.QLabel(self)
	self.lblMissedCalls.setObjectName("lblMissedCalls")
        self.gridLayout.addWidget(self.lblMissedCalls, 5, 0, 1, -1)
	self.lblReceivedCalls = QtGui.QLabel(self)
        self.lblReceivedCalls.setObjectName("lblReceivedCalls")
        self.gridLayout.addWidget(self.lblReceivedCalls, 4, 0, 1, -1)
	
        self.retranslateUi()
        
    def retranslateUi(self):
        self.lblTotSMS.setText("Total SMS:")
        self.lblSentSMS.setText("Sent SMS:")
        self.lblReceivedSMS.setText("Received SMS:")
        self.lblSpamSMS.setText("Spam:")
	self.lblTotCalls.setText("Total Calls:")
        self.lblMadeCalls.setText("Calls made:")
        self.lblReceivedCalls.setText("Calls received:")
	self.lblMissedCalls.setText("Calls missed:")
    
    
    def query(self,data):
        receivedS=0
        sentS=0
	totS=0
        Spam=0
        receivedC=0
        sentC=0
	totC=0
        missedC=0
        for dat in data:
            receivedS+=dat.rSms
            sentS+=dat.sSms
            Spam+=dat.cSms
            receivedC+=dat.rCalls
            sentC+=dat.sCalls
            missedC+=dat.mCalls
        totS=receivedS+sentS
        totC=receivedC+sentC+missedC
        
            
        rr=0
        if receivedS>0:
            rr=round(float(Spam)/receivedS*100,2)
        Spam=str(Spam)+" ("+str(rr)+"%)"
        rr=0
        if totS>0:
            rr=round(float(receivedS)/totS*100,2)
        receivedS=str(receivedS)+" ("+str(rr)+"%)"
        rr=0
        if totS>0:
            rr=round(float(sentS)/totS*100,2)
        sentS=str(sentS)+" ("+str(rr)+"%)"
        totS=str(totS)
        self.lblTotSMS.setText("Total SMS: "+totS)
        self.lblReceivedSMS.setText("Received SMS: "+receivedS)
        self.lblSentSMS.setText("Sent SMS: "+sentS)
        self.lblSpamSMS.setText("Spam: "+Spam)
	
	rr=0
        if totC>0:
            rr=round(float(receivedC)/totC*100,2)
        receivedC=str(receivedC)+" ("+str(rr)+"%)"
	rr=0
        if totC>0:
            rr=round(float(missedC)/totC*100,2)
        missedC=str(missedC)+" ("+str(rr)+"%)"
        rr=0
        if totC>0:
            rr=round(float(sentC)/totC*100,2)
        sentC=str(sentC)+" ("+str(rr)+"%)"
        totC=str(totC)
	self.lblTotCalls.setText("Total Calls: "+totC)
        self.lblReceivedCalls.setText("Calls received: "+receivedC)
        self.lblMadeCalls.setText("Calls made: "+sentC)
	self.lblMissedCalls.setText("Calls missed: "+missedC)

class DataGraph(QtGui.QWidget):
    def __init__(self, parent=None):
        QtGui.QWidget.__init__(self, parent)
        hl=QtGui.QHBoxLayout(self)
        self.graph=Graph(self)
        self.graph.dataGap=65
        hl.addWidget(self.graph)

    def query(self,data):
        xData=[]
        yData=[[],[],[],[],[],[]]
        yLabels=["SMS Received ","SMS Sent","Spam SMS","Calls Received","Calls Made","Missed Calls"]
        for dat in data:
            period=dat.getPeriod()
            xData.append(period)
            yData[0].append(dat.rSms)
            yData[1].append(dat.sSms)
            yData[2].append(dat.cSms)
            yData[3].append(dat.rCalls)
            yData[4].append(dat.sCalls)
            yData[5].append(dat.mCalls)
        self.graph.setData(xData, yData, yLabels)

class Main(QtGui.QWidget):
    def __init__(self, parent=None):
        QtGui.QWidget.__init__(self, parent)
        self.mw=MainWidget()
        self.mw.setupUi(self)
if __name__ == "__main__":
    app = QtGui.QApplication(sys.argv)
    qb = Main()
    qb.show()
    sys.exit(app.exec_())
