#!/usr/bin/python2.5
import sys, os
import time
from PyQt4 import QtGui,QtCore
from smsBomb import *

class MyForm(QtGui.QMainWindow):
	def __init__(self, parent=None):
		#build parent user interface
		QtGui.QWidget.__init__(self, parent)
		self.ui = Ui_MainWindow()
		self.ui.setupUi(self)
		# Create button actions
		self.running = False
		# Send Messages Button
		QtCore.QObject.connect(self.ui.btnSendMessages, QtCore.SIGNAL('clicked()'), self.queueMessages)
		self.maintimer = QtCore.QTimer(self);
		self.connect(self.maintimer, QtCore.SIGNAL('timeout()'), self.processMessages)
		# Changed index (combobox) action - hide flashsms checkbox
		QtCore.QObject.connect(self.ui.cmbAccount, QtCore.SIGNAL("currentIndexChanged(QString)"), self.cmbAccountChange)
		# Add items to the combo box.
		#self.cmbAccount=QComboBox(FALSE, row1)
		self.ui.cmbAccount.addItems(["SIM", "Google Voice - QGVDial"])
		
	def queueMessages(self):
		if self.running:
			self.running = False
			self.counter = 0
			self.maintimer.stop()
			self.ui.btnSendMessages.setText("Send Messages")
		else:
			if self.maintimer.isActive():
				self.maintimer.stop()
			# Queue messages!
			self.running = True
			self.counter = 1
			self.number = str(self.ui.txtNumber.text())
			self.message = str(self.ui.txtMessage.text())
			self.delay = int(self.ui.txtDelay.text())
			self.repetitions = int(self.ui.txtRepetitions.text())
			self.method = self.ui.cmbAccount.currentIndex()
			self.flashSMS = self.ui.cbxFlashSMS.isChecked()
			if self.repetitions >= 1:
				self.sendMessage(self.method)
			if self.repetitions > 1:
				self.ui.btnSendMessages.setText("Stop (1 of " + str(self.repetitions) + ")")
				self.maintimer.start(self.delay * 1000)
			if self.repetitions <= 1:
				self.running = False
		
	def processMessages(self):
		"""Send Queued Messages as needed"""
		if self.running == True:
			print "Counter: " + str(self.counter)
			print "Delay: " + str(self.delay)
			print "Repetitions: " + str(self.repetitions)
			self.sendMessage(self.method)
			self.counter=self.counter+1
			self.ui.btnSendMessages.setText("Stop (" + str(self.counter) + " of " + str(self.repetitions) + ")")
			if (self.counter >= self.repetitions):
				print "All messages sent!"
				self.running = False
				self.ui.btnSendMessages.setText("Send Messages")
		
	def sendMessage(self, method):
		"""Send message using defined method (GV, SMS, etc)"""
		if method == 0: # SIM
			if self.flashSMS:
				os.system('/usr/bin/smssend -f -s -n ' + self.number + ' -m "' + self.message + '"')
			else:
				os.system('sudo /opt/smsbomb/smsMsg.py ' + self.number + ' "' + self.message + '"')
		elif method == 1: # Google Voice
			# Import to use proper python sending technique
			os.system('dbus-send --dest=org.QGVDial.TextServer --session --print-reply /org/QGVDial/TextServer org.QGVDial.TextServer.Text array:string:"' + self.number + '" string:"' + self.message + '"')
		else:
			print "Message sending method not recognized."
		
	def cmbAccountChange(self):
		"""Hide or re-enable flashsms textbox when depending on choice"""
		if self.ui.cmbAccount.currentIndex() == 0: # SIM
			self.ui.cbxFlashSMS.show()
		else:
			self.ui.cbxFlashSMS.hide()
		
if __name__ == "__main__":
	app = QtGui.QApplication(sys.argv)
	myapp = MyForm()
	myapp.show()
	sys.exit(app.exec_())
