# -*- coding: utf-8 -*-

###########################################################################
## File:        functions_alarm.py
## Description: This file includes the functions needed to set and modify
##                the alarms
###########################################################################


import data

if(data.UsePySide == True):
    from PySide import QtCore, QtGui
else:    
    from PyQt4 import QtCore, QtGui

import sys
import os
import random
import time
from time import strftime
import math
import array
import string

import os, os.path

import records #record data

#own functions
from functions_general import *
from functions_record import *


try:
    import alarm #maemo specific
except:
    pass

import i18n #load language file
_ = i18n.language.ugettext







###########################################################################
## Function:    CalculateAlarmtime
## Description: Takes the choosen alarm hour and minute and generates the resulting timestamp
## Parameters:  none
## Returns:     none
###########################################################################
def CalculateAlarmtime(h, m):
    hour_and_minute_now=int(strftime("%H", time.localtime()))*3600+int(strftime("%M", time.localtime()))*60 #hour and minute now in sec
    hour_and_minute_alarm=int(h)*3600+int(m)*60 #hour and minute of alarm in sec
    alarmdiff=hour_and_minute_alarm-hour_and_minute_now
    if(alarmdiff<0):  #set to tomorrow if time already is elapsed today
        alarmdiff=alarmdiff+86400
    alarm=Tuple2Seconds(time.localtime())+alarmdiff
    alarm=int((alarm)/60)*60 #set seconds to zero
#    print alarm
    return alarm






###########################################################################
## Function:    SetAlarm
## Description: This function adds the alarm to the MAEMO alarm queue
## Parameters:  none
## Returns:     none
###########################################################################
def SetAlarm():
    Alarm_successfully_set=True
    if(data.DeviceIsN900==True): #We are on a N900
        event = alarm.Event()
        event.appid = 'SleepAnalyser'
        txt=_('Wake up (SleepAnalyser)')
        event.message =str(txt.encode( "utf-8" ))


#        now=Tuple2Seconds(time.localtime())
#        if(now<=records.AlarmTime_seconds):
#            records.AlarmTime_seconds=now+2
        event.alarm_time = records.AlarmTime_seconds #in seconds

        if(data.UseAlternativeAlarm==False): #use normal MAEMO alarm
            action_snooze, action_stop = event.add_actions(2)
            txt=_('Snooze')
            action_snooze.label=str(txt.encode( "utf-8" ))
            action_snooze.flags |= alarm.ACTION_WHEN_RESPONDED | alarm.ACTION_TYPE_SNOOZE
            txt=_('Stop')
            action_stop.label =str(txt.encode( "utf-8" ))
            action_stop.flags |= alarm.ACTION_WHEN_RESPONDED | alarm.ACTION_TYPE_NOP
        else: #use own (alternative) alarm
            print "* Use alternative alarm: "+data.AlternativeAlarm
            action_run = event.add_actions(1)[0]
            action_run.flags |= alarm.ACTION_WHEN_TRIGGERED | alarm.ACTION_TYPE_EXEC
            action_run.command = data.AlternativeAlarm

        try:
            print "Event details:"
#            print event
            print event.appid
#            print event.message
            print Seconds2Tuple(event.alarm_time)
        except:
            print "Could not print event data"

        #python-alarm seems to throw an InvalidEventException error if the alarm time is in the past!
        for i in range(0, 10):
            print "Try to add alarm event (Try", i, "/ 10)"
            try:
                print "Alarm time:",  event.alarm_time,  "now:",  Tuple2Seconds(time.localtime())
                data.AlarmID = alarm.add_event(event) #Try to add alarm event
                print "AlarmID:", data.AlarmID
                break #alarm is set, leave loop
            except:
                print "Could not add alarm event, might be in the past"
                records.AlarmTime_seconds =records.AlarmTime_seconds +2 #move it one second ahead in case its already in the past
                event.alarm_time = records.AlarmTime_seconds #in seconds
                if(i<9): #give it another try
                    pass
                else:
                    print i+1, "trials without success, raise the error"
                    raise #ok, now really raise the error
                    Alarm_successfully_set=False #Alarm might not be set successfully! Make sure old alarm (if existing) will not get deleted

        print "Ok, could set the alarm"

        try:
            event = alarm.get_event(data.AlarmID) #read out again to check if set correctly
            print "* Alarm will go off on:", time.ctime(event.trigger)
        except:
            print "* Could not read out the alarm again. How ever it might still go off as planed."
            Alarm_successfully_set=False #Alarm might not be set successfully! Make sure old alarm (if existing) will not get deleted
            
            
    else:
        print "* Will not set alarm, Maemo interface not available"
        data.AlarmID=1

    data.AlarmIsActive=False
    return Alarm_successfully_set






###########################################################################
## Function:    delete_all_Alarms
## Description: This function searchs for any SleepAnalyser alarms in the
##                MAEMO alarm queue and deletes them
##                In case SleepAnalyser crashed during recording, an alarm
##                might still be in the queue
## Parameters:  none
## Returns:     none
###########################################################################
def delete_all_Alarms():
    print "* Search and delete all alarms from SleepAnalyser"
    if(data.DeviceIsN900==True): #We are on a N900
        event = alarm.query_event(0, 0, 0, 0, "") #get list of all set alarm in N900
        i=0
        for e in event:
            e2=alarm.get_event(e)
            if(e2.appid=="SleepAnalyser"): #filter our alarms
#                print "Found one of our Alarms:", time.ctime(e2.trigger), e2.appid , e2.title, e2.message #print our alarms
                alarm.delete_event(e)
                i=i+1
        if(i==0): print "* No old alarms found"
        else: print "* Found", i, "of our alarms and deleted them"
    else:
        print "* Will not delete alarm, Maemo interface not available"





###########################################################################
## Function:    print_list_of_all_alarms
## Description: This function searchs for any SleepAnalyser alarms in the
##                MAEMO alarm queue and shows them
##                This function is mainly used for debugging
## Parameters:  none
## Returns:     none
###########################################################################
def print_list_of_all_alarms():
    print "* Print list of all SleepAnalyser alarms"
    if(data.DeviceIsN900==True): #We are on a N900
        event = alarm.query_event(0, 0, 0, 0, "") #get list of all set alarm in N900
        i=0
        for e in event:
            e2=alarm.get_event(e)
            if(e2.appid=="SleepAnalyser"): #filter our alarms
                print "Found alarm:", time.ctime(e2.trigger), e2.appid , e2.title, e2.message #print our alarms
                i=i+1
        if(i==0): print "* No old alarms found"
        else: print "* Found", i, "of our alarms"





###########################################################################
## Function:    DeleteAlarm
## Description: This function delets a specific alarm from the AMEMO alarm queue
## Parameters:  none
## Returns:     none
###########################################################################
def DeleteAlarm(AlarmID):
    if(AlarmID!=-1): #there is an old alarm to be deleted
        if(data.DeviceIsN900==True): #We are on a N900
            try:
                event = alarm.get_event(AlarmID) #get data of to be deleted alarm
                alarm.delete_event(AlarmID)

                print "* Delete old alarm:", time.ctime(event.trigger)
            except:
                pass
        else:
            print "* Will not delete alarm, Maemo interface not available"

        AlarmID=-1

#        if(data.AlarmIsActive==False): #if alarm never came, remove from record
#            records.AlarmTime_seconds=-1
#            records.AlarmTime_tuple=-1
    else:
        if(data.debug==True): print "* No alarm to be deleted"

    data.AlarmIsActive=False

    return AlarmID




###########################################################################
## Function:    ProcessAlarm
## Description: This function checks if the latest value of the blue sleep
##                alarm curve is over the trigger level and sets off an alarm
##                or the wake up music
## Parameters:  none
## Returns:     0: no action needed, 1: start Wake Up Music, 2: Stop wakeUp Music
###########################################################################
def ProcessAlarm():
    r=0
    i=records.Index-data.Derivation
    if(i>1): peak=records.arrData[6][i-1] #New: use blue graph for triggering
    else: peak=0
    now=Tuple2Seconds(time.localtime())
    if(peak>(data.Trigger*data.Yscale_Sleep_Pattern*3/40) and now<=records.AlarmTimeWindowEnd_seconds): #Movement over trigger level and not yet beyond alarm time window => Trigger Alarm
       if(records.AlarmIsSet==True and data.AlarmIsActive==False): #alarm is set
            if(now>=records.AlarmTimeWindowStart_seconds and now<records.AlarmTimeWindowEnd_seconds): # we are in alarm time window
                if(data.WakeUp_SongIsActive==False):#wake up song (if enabled) is not yet playing
                    print strftime("%x %X"), "************ ALARM ALARM (Movement over trigger level)"
#                    print "*", strftime("%x %X"), "ProcessAlarm => DeleteAlarm" #for log file
#                    data.AlarmID=DeleteAlarm(data.AlarmID) #delete old alarm if existing
                    records.AlarmTime_tuple=time.localtime()#set to now
                    records.AlarmTime_seconds=Tuple2Seconds(records.AlarmTime_tuple)


                    print "Use_WakeUp_Song:", records.Use_WakeUp_Song

                    if(records.Use_WakeUp_Song==True): #Delay alarm, so we can first play wake up song
                        print "* Alarm would be now:", records.AlarmTime_tuple
                        print "* But wake Up song is enabled, delay alarm for", records.WakeUp_Song_Duration/60, "minutes"
                        records.AlarmTime_seconds=min(records.AlarmTime_seconds+records.WakeUp_Song_Duration, records.AlarmTimeWindowEnd_seconds) #add delay time, but max until alarm time window
                        records.AlarmTime_tuple=Seconds2Tuple(records.AlarmTime_seconds)
                        data.WakeUp_SongIsActive=True
                        records.WakeUp_Song_Start_tuple=Seconds2Tuple(now)
                        print "* Delay alarm until:", records.AlarmTime_tuple

                        print "** Play wake up song"
#                        PlaySong(0, records.WakeUp_Song) #start quiet, get louder over time
#                        MusicPlayer_Stop() #close media player in case still in use from the lucid dream option
                        data.CurrentVolume=data.WakeUp_Song_Start_Volume
#                        MusicPlayer_Play(data.WakeUp_Song_Start_Volume, records.WakeUp_Song, records.WakeUp_Song_Duration) #start quiet, get louder over time
                        r=1

                    print "*", strftime("%x %X"), "ProcessAlarm => SetAlarm" #for log file
                    old_AlarmID=data.AlarmID #backup old alarm ID
                    
                    try:
                        Alarm_successfully_set=SetAlarm() #set alarm to go off now (or with wake up song delay)                       
                    except:
                        Alarm_successfully_set=False
                        
                    if(Alarm_successfully_set==True): #New alarm succesfully set
#                        print "New alarm got sucessfully set, now we can delete the old one"
#                        print "*", strftime("%x %X"), "ProcessAlarm => DeleteAlarm" #for log file
#                        DeleteAlarm(old_AlarmID) #delete old alarm if existing
                        print "Could now delete old alarm, but are not going to do it!"
                        print "Its a backup in case the new one does not go off or the user ignores it."
                        print "Both alarms anyway will get deleted when the application gets closed."
                    else: #Could not set new alarm, so do not delete old alarm
                        print "!!! WARNING !!!!"
                        print "Could not set new alarm!"
                        print "Will keep old alarm!"


                if(now >= records.AlarmTime_seconds): #alarm is due
                    records.Trigger=data.Trigger #update Trigger level on alarm occurence
                    data.AlarmIsActive=True
                    data.Lucid_Dream_SongIsActive=True #make sure lucid dream option will not run after wake up option got active
#                    PauseSong() #stop playing song, in case it was playing
#                    MusicPlayer_Stop() #close media player
                    r=2

    elif(now>=records.AlarmTimeWindowEnd_seconds): #Beyond of alarm time window, set alarm off anyway
        if(records.AlarmIsSet==True and data.AlarmIsActive==False): #Alarm is set and not active yet
            print strftime("%x %X"), "************ ALARM ALARM (End of Alarm Time Window)"
            records.Trigger=data.Trigger #update Trigger level on alarm occurence
            data.AlarmIsActive=True
            data.Lucid_Dream_SongIsActive=True #make sure lucid dream option will not run after wake up option got active
#            PauseSong() #stop playing song, in case it was playing
#            MusicPlayer_Stop() #close media player
            r=2

    elif(records.Use_WakeUp_Song==True and (now+records.WakeUp_Song_Duration>=records.AlarmTimeWindowEnd_seconds)): #almost at end of alarm time window, play wake up song
        if(data.WakeUp_SongIsActive==False):#wake up song (if enabled) is not yet playing
            data.WakeUp_SongIsActive=True
            records.WakeUp_Song_Start_tuple=Seconds2Tuple(now)
            print "** Play wake up song"
#            MusicPlayer_Stop() #close media player in case still in use from the lucid dream option
            data.CurrentVolume=data.WakeUp_Song_Start_Volume
#            MusicPlayer_Play(data.WakeUp_Song_Start_Volume, records.WakeUp_Song, records.WakeUp_Song_Duration) #start quiet, get louder over time
            r=1

    if(data.WakeUp_SongIsActive==True and data.SongIsPlaying==True): #when WakeUp music is active, increase volume over time
#        print records.WakeUp_Song_Volume,  data.CurrentVolume, data.CurrentVolume, float(data.WakeUp_Song_Volume_Increase_Step)/10, data.WakeUp_Song_Volume_Increase_Step
        if(records.WakeUp_Song_Volume>=data.CurrentVolume):
            data.CurrentVolume=data.CurrentVolume+(float(data.WakeUp_Song_Volume_Increase_Step)/10) #increase the volume slowly
            SetVolume(data.CurrentVolume)
            print "Increase volume to:", data.CurrentVolume

    return r




###########################################################################
## Function:    ProcessLucid_Dream
## Description: This function sets off the lucid dream music if we are
##                longer than required time in light or deep sleep
## Parameters:  none
## Returns:     0: no action needed , 1: Start Lucid dream music
###########################################################################
def ProcessLucid_Dream(self): #Lucid dream option
    if(records.Use_Lucid_Dream_Song==True and data.Lucid_Dream_SongIsActive==False):
        GenerateStatisticData()
        if(records.arrStatData[1][2] >= records.Lucid_Dream_Song_Delay or records.arrStatData[2][2] >= records.Lucid_Dream_Song_Delay):
            data.Lucid_Dream_SongIsActive=True
            records.Lucid_Dream_Song_Start_tuple=time.localtime() #now
            print "Play Lucid dream song"
#            PlaySong(records.Lucid_Dream_Song_Volume, records.Lucid_Dream_Song)
#            duration=GetSongLength(records.Lucid_Dream_Song)
#            MusicPlayer_Play(records.Lucid_Dream_Song_Volume, records.Lucid_Dream_Song, duration)
            return 1 #start lucid dream music
    return 0
