#!/usr/bin/env python

import sys, os, time, thread
import glib, gobject
import pygst
pygst.require("0.10")
import gst




def convert_time(time):
      time = time / 1000000000
      string = ""
      
      mins = time % 3600
      time = time - mins
      
      secs = mins % 60
      mins = mins - secs
      
      hours = int(time / 3600)
      mins = int(mins / 60)
      secs = int(secs)
      
      if hours > 0:
         string = string + str(hours) + ':'
         if mins < 10:
            string = string + '0'
      
      if mins > 0:
         string = string + str(mins) + ':'
      else:
         string = string + '0:'
      
      if secs > 9:
         string = string + str(secs)
      elif secs > 0:
         string = string + '0' + str(secs)
      else:
         string = string + '00'
         
      return string







class CLI_Main:
	
	def __init__(self):
		self.player = gst.element_factory_make("playbin2", "player")
		fakesink = gst.element_factory_make("fakesink", "fakesink")
		self.player.set_property("video-sink", fakesink)
		bus = self.player.get_bus()
		bus.add_signal_watch()
		bus.connect("message", self.on_message)

	def on_message(self, bus, message):
		t = message.type
		#print "got a message:", t
		if t == gst.MESSAGE_EOS:
			self.player.set_state(gst.STATE_NULL)
			self.playmode = False
		elif t == gst.MESSAGE_ERROR:
			self.player.set_state(gst.STATE_NULL)
			err, debug = message.parse_error()
#			sys.stdout.write( "E: ", err, debug)
			sys.stdout.write( "E: "+str(err)+"\n")
			self.playmode = False

	def start(self):
		
		self.playmode = True
		self.player.set_property("uri", "file://" + filepath)
		self.player.set_state(gst.STATE_PLAYING)
		while self.playmode:
		    time.sleep(1)
		    
		    try:
			nanosecs, format = self.player.query_position(gst.FORMAT_TIME)
			duration_nanosecs, format = self.player.query_duration(gst.FORMAT_TIME)
			
			sys.stdout.write("I: "+ str(convert_time(nanosecs)) +", "+ str(nanosecs*100/duration_nanosecs)+"%, "+str(convert_time(duration_nanosecs))+"\n")
			sys.stdout.flush()
		    except:
		      pass
			
				
	
		sys.stdout.write( "I: EOF\n")
		sys.stdout.flush()
			
		loop.quit()





sys.argv.pop(0)
if(len(sys.argv)>0):  #at least one parameter
  filepath=sys.argv[0]

  if os.path.isfile(filepath):    
    sys.stdout.write( "I: Play: "+filepath+"\n")
    sys.stdout.flush()

    mainclass = CLI_Main()
    thread.start_new_thread(mainclass.start, ())
    gobject.threads_init()
    loop = glib.MainLoop()
    loop.run()
    
  else:
    sys.stdout.write( "E: File does not exist: "+filepath)



else:
  sys.stdout.write( "E: No file given")















