#!/usr/bin/env python2.5
# -*- coding: utf-8 -*-

from PyQt4.QtCore import *
from PyQt4.QtGui import *
import os, sys
import string

#GUI files, generated with QT designer
from Ui_BugReportWindow import *








class frmBugReportWindow(QDialog):
    def __init__(self, parent=None):
        QMainWindow.__init__(self, parent) # Notice that you must give a parent window as parameter to the constuctor
       
        self.ui = Ui_BugReportWindow()
        self.ui.setupUi(self)
        
        
        QtCore.QObject.connect(self.ui.bSend, QtCore.SIGNAL("clicked()"), self.Send)


    def Send(self):
        
        body="There is a bug in SleepAnalyser.\n\n"
        
        body = body + "When does this bug happen? "+ self.ui.cbOccurence.currentText()+"\n"
        
        body = str(body)
        
        body = body + "Did the alarm still go off? "+ self.ui.cbAlarm.currentText()+"\n"
        
        body = str(body)
        
        try:
            body = body + "Do you have any clue why it happened? "+ unicode(self.ui.txtClue.text()).encode( "utf-8" )+"\n"
            body = body + "Anything else I should know? "+ unicode(self.ui.txtNote.text()).encode( "utf-8" )+"\n"       
        except:
            pass
        
        body= body + "\nBelow is the log file from /home/user/MyDocs/SleepAnalyser/error.log\n"
        
        
        body = body + "\n-------------------------------------------------\nStack trace:\n"
        trace =  os.popen("cat /home/user/MyDocs/SleepAnalyser/error.log").read() # run tail and make the output look like a file I can read
        trace=string.replace(trace, "  ", "__")
        
        body = body + trace


        body = body + "\nFolder structure:\n/opt/Sleepanalyser/\n"
        body = body + os.popen("ls -C1sh /opt/SleepAnalyser/").read() # run tail and make the output look like a file I can read
        
        
        try:
            body = str(body)
        except:
            pass


        body=string.replace(body, "\n", "<br>\n")
        

        cmd="dbus-send --type=method_call --dest=com.nokia.modest /com/nokia/modest com.nokia.modest.MailTo string:\"" +\
        "mailto:george@ruinelli.ch?subject=Bug in SleepAnalyser "+version+"&body="+ body+"\""
       
        print cmd
       

        os.popen(cmd)

        quit(1)














app = QApplication(sys.argv)

BugReportWindow = frmBugReportWindow()

try:
    file = open("/opt/SleepAnalyser/version", 'r')
    version = file.readline()
    version=version[:-1]
    build = file.readline()
    version=str(version)+ "-"+str(build)
except:
    version=""
    




ret = QMessageBox.question(None, "Oops! Error in SleepAnalyser "+version, "SleepAnalyser did not get closed correctly. " + \
                           "Please send an email to the author so he can fix it."
                        , QMessageBox.Yes, QMessageBox.Discard)
if ret == QMessageBox.Yes:
    BugReportWindow.show()
    
    sys.exit(app.exec_())

quit(0)
