# -*- coding: utf-8 -*-

###########################################################################
## File:        functions_file.py
## Description: This file includes the functions to read,  write and modify
##                the record files
###########################################################################

import sys
import os
import random
import time
from time import strftime
import math
import array
import string

import ConfigParser
import os, os.path

import data
import records #record data

#own functions
from functions_general import *
from functions_record import *

import i18n #load language file
_ = i18n.language.ugettext


###########################################################################
## Function:    CreateRecordFile
## Description: This function creats the record data file
## Parameters:  none
## Returns:     none
###########################################################################
def CreateRecordFile():
    #if not on the N900, use another place for the record file
    if(data.DeviceIsN900==False): data.RecordFolder=data.developmentRecordFolder #folder on devel PC
    else: data.RecordFolder=data.defaultRecordFolder

    print "RecordFolder:", data.RecordFolder
    if(not os.path.exists(str(data.RecordFolder))): #create record folder
        try:
            os.mkdir(data.RecordFolder)
        except:
            print "Failed to create RecordFolder!"

    if(data.debug==True): PrintRecordData()

    #create file, write header
    d=strftime("%Y-%m-%d_%H-%M-%S", records.StartTime_tuple)
    data.RecordFilename="SleepAnalyser_"+d+".csv"
    try:
        data.RecordFile = open(data.RecordFolder+data.RecordFilename, 'w')
    except:
        print "ERROR! Can not open file for write access"
        Notify(_("Can not create record file! File system might be read only"))
        return 1


    print "Created RecordFile "+data.RecordFilename

    h=CreateHeader()
    data.RecordFile.write(h)
    data.RecordFile.flush()

    return 0




###########################################################################
## Function:    CreateHeader
## Description: This function creats the header data for the record data file
## Parameters:  none
## Returns:     none
###########################################################################
def CreateHeader():
    if(records.SWversion<1.8): records.SWversion=1.8 #Workaround for missing version variable, update file version as header gets saved in new version

    h=" , , , User: " + str(records.User.encode( "utf-8" ))+ \
        ", SW version: " + str(records.SWversion)+ \
        ", Sampling interval: " + str(records.Sampling_interval)+ \
        ", Sample smoothing: " + str(records.Sample_smoothing)+ \
        ", Value smoothing: " + str(records.Value_smoothing) + \
        ", Trigger level: " + str(records.Trigger)

    h=h+"\n"+"Start time: "+strftime(data.dateformat, records.StartTime_tuple)

    if(records.AlarmIsSet==True):
        if(records.AlarmTime_tuple!=-1):
            h=h+"\n"+"Alarm: "+strftime(data.dateformat,records.AlarmTime_tuple)
        else:
            h=h+"\n"+"No alarm set"
        h=h+"\n"+"Alarm Time Window Start: "+strftime(data.dateformat,records.AlarmTimeWindowStart_tuple)
        h=h+"\n"+"Alarm Time Window End: "+strftime(data.dateformat,records.AlarmTimeWindowEnd_tuple)
        h=h+"\n"+"Use alternative Alarm: "+str(data.UseAlternativeAlarm)
        if(data.UseAlternativeAlarm==True):
            h=h+"\n"+"Alternative Alarm: "+str(data.AlternativeAlarm)
        else:
            h=h+"\n"+"Alternative Alarm: "

    else:
        h=h+"\n"+"No alarm set"
        h=h+"\n"+"Alarm Time Window Start: Not set"
        h=h+"\n"+"Alarm Time Window End: Not set"
        h=h+"\n"+"Use alternative Alarm: False"
        h=h+"\n"+"Alternative Alarm: "

    h=h+"\n"+"Note: "+str(records.Note.encode( "utf-8" ))


    if(records.Use_Lucid_Dream_Song==True):
        if(records.Lucid_Dream_Song_Start_tuple != -1):
            h=h+"\n"+ "Lucid dream song start: "+strftime(data.dateformat, records.Lucid_Dream_Song_Start_tuple)
        else:
            h=h+"\n"+ "Lucid dream song start: never"
        h=h+"\n"+ "Lucid dream song: "+str(records.Lucid_Dream_Song)
        h=h+"\n"+ "Lucid dream song delay: "+str(records.Lucid_Dream_Song_Delay)
        h=h+"\n"+ "Lucid dream song duration: "+str(records.Lucid_Dream_Song_Duration)
        h=h+"\n"+ "Lucid dream song volume: "+str(records.Lucid_Dream_Song_Volume)
    else:
        h=h+"\n"+ "Lucid dream song start: Not set"
        h=h+"\n"+ "Lucid dream song: Not set"
        h=h+"\n"+ "Lucid dream song delay: Not set"
        h=h+"\n"+ "Lucid dream song duration: Not set"
        h=h+"\n"+ "Lucid dream song volume: Not set"


    if(records.Use_WakeUp_Song==True):
        if(records.WakeUp_Song_Start_tuple != -1):
            h=h+"\n"+ "WakeUp song start: "+strftime(data.dateformat, records.WakeUp_Song_Start_tuple)
        else:
            h=h+"\n"+ "WakeUp song start: never"
        h=h+"\n"+ "WakeUp song: "+str(records.WakeUp_Song)
        h=h+"\n"+ "WakeUp song duration: "+str(records.WakeUp_Song_Duration)
        h=h+"\n"+ "WakeUp song volume: "+str(records.WakeUp_Song_Volume)
    else:
        h=h+"\n"+ "WakeUp song start: Not set"
        h=h+"\n"+ "WakeUp song: Not set"
        h=h+"\n"+ "WakeUp song duration: Not set"
        h=h+"\n"+ "WakeUp song volume: Not set"

    #reserved for future usage
    h=h+"\n"+"Spare"
    h=h+"\n"+"Spare"
    h=h+"\n"+"Spare"
    h=h+"\n"+"Spare"
    h=h+"\n"+"Spare"

    h=h+"\n"+"Time, AccX, AccY, AccY:\n" #not really used, only here for understanding of file structure

    if(data.debug==True): print "##############################\nHeader:\n"+h+"\n##############################"
    return h





###########################################################################
## Function:    WriteRecord
## Description: This function writes the acceleration data into the record data file
## Parameters:  none
## Returns:     none
###########################################################################
def WriteRecord():
    d=str(records.arrData[0][records.Index-1]) + ", " +  \
        str(records.arrData[1][records.Index-1]) + ", " +  \
        str(records.arrData[2][records.Index-1]) + ", " +  \
        str(records.arrData[3][records.Index-1])

    data.RecordFile.write(d+"\n")
#    if(data.debug==True): print "Write to file:",d

    if(records.Index % 30 == 0):
        if(data.debug==True): print "Flush data from IO buffer into file"
        data.RecordFile.flush() #Every 30 indices (5 minutes in normal mode), write data from IO buffer into file






###########################################################################
## Function:    StopRecordFile
## Description: This function closes the record data file after recording end
## Parameters:  none
## Returns:     none
###########################################################################
def StopRecordFile():
    if(records.AlarmIsSet==True):
        records.LastIndex=max(records.Index, Tuple2Index(records.AlarmTimeWindowEnd_tuple)+5) #the very last index to be shown (incl. AlarmTimeWindowEnd
    else: records.LastIndex=records.Index
    data.RecordFile.close()




###########################################################################
## Function:    LoadFileList
## Description: This function creates a list of all record data files in the
##                folder defined in defaultRecordFolder
## Parameters:  none
## Returns:     none
###########################################################################
def LoadFileList():
    try:
        print "Load list of all csv files in folder:", data.RecordFolder
    except:
        pass
    data.arrRecordFiles=getFileList(data.RecordFolder,  "*.csv")
    if(data.debug==True): print data.arrRecordFiles
    if(data.RecordFilename>""):
        if(data.debug==True): print data.RecordFilename
        data.arrRecordFilesIndex=0
        for i in range(len(data.arrRecordFiles)):
            if(data.RecordFilename==data.arrRecordFiles[i]): data.arrRecordFilesIndex=i

    if(data.debug==True): print "LoadFileList, Index:", data.arrRecordFilesIndex





###########################################################################
## Function:    LoadRecord
## Description: This function loads the complete record data file into the record array
## Parameters:  none
## Returns:     none
###########################################################################
def LoadRecord():
    InitRecord() #clear all old data

    data.RecordFolder=string.replace(data.RecordFolder, "~", data.homedir) #workaround
    print "Open recordfile:", data.RecordFolder+data.RecordFilename, "to load data..."
    if(not os.path.exists(str(data.RecordFolder))): #create record folder (dirty workaround for if folder is not existing
        os.mkdir(data.RecordFolder)
        data.LastRecord=""
    f=data.RecordFolder+data.RecordFilename
    if(not os.path.exists(str(f)) or data.RecordFilename==""): return 2 #selected file or folder does not exist

    file = open(f, 'r')

    try: #read header data
       #process header line 1
        tmp=file.readline()
        header=string.split(tmp, ", ")
        records.SWversion=float(string.replace(header[4], "SW version:", ""))
        print "File has software version", records.SWversion
        if(records.SWversion<1.6): #workaround for old files
            print "Record is older than SW version 1.6, use old protocol"
            records.User=string.replace(header[3].decode("utf-8") , "User:", "")
            Startdate_date=string.replace(header[5], "Date:", "")
            x=string.replace(header[6], "Sampling interval:", "")
            records.Sampling_interval=int(string.replace(x, " ms", ""))
            records.Sample_smoothing=int(string.replace(header[7], "sampling smoothing:", ""))
            records.Value_smoothing=int(string.replace(header[8], "value_smoothing:", ""))
            records.Trigger=30
        else:
            records.User=string.replace(header[3].decode("utf-8") , "User:", "")
            records.Sampling_interval=int(string.replace(header[5], "Sampling interval:", ""))
            records.Sample_smoothing=int(string.replace(header[6], "Sample smoothing:", ""))
            records.Value_smoothing=int(string.replace(header[7], "Value smoothing:", ""))
            records.Trigger=int(string.replace(header[8], "Trigger level:", ""))

        if(records.SWversion<1.2): #workaround for old files
            records.Notes=""
        elif(records.SWversion<1.6): #workaround for old files
            #process header line 2
            tmp=file.readline()
            records.Note=string.replace(tmp[:-1].decode("utf-8"), "Note: ", "")
        else:
           #process header line 2
            tmp=file.readline()
            tmp=string.replace(tmp[:-1], "Start time: ", "")
            records.StartTime_tuple=time.strptime(tmp, data.dateformat)
            records.StartTime_seconds=Tuple2Seconds( records.StartTime_tuple)

           #process header line 3
            tmp=file.readline()
            if(tmp[:-1]!="No alarm set"):
                if(data.debug==True): print "An alarm is set"
                tmp=string.replace(tmp[:-1], "Alarm: ", "")
                records.AlarmTime_tuple=time.strptime(tmp, data.dateformat)
                records.AlarmTime_seconds=Tuple2Seconds( records.AlarmTime_tuple)
            else:
                if(data.debug==True): print "No alarm is set"

           #process header line 4
            tmp=file.readline()
            tmp=string.replace(tmp[:-1], "Alarm Time Window Start: ", "")
            if(tmp!="Not set"):
                records.AlarmTimeWindowStart_tuple=time.strptime(tmp, data.dateformat)
                records.AlarmTimeWindowStart_seconds=Tuple2Seconds(records.AlarmTimeWindowStart_tuple)

           #process header line 5
            tmp=file.readline()
            tmp=string.replace(tmp[:-1], "Alarm Time Window End: ", "")
            if(tmp!="Not set"):
                records.AlarmTimeWindowEnd_tuple=time.strptime(tmp, data.dateformat)
                records.AlarmTimeWindowEnd_seconds=Tuple2Seconds( records.AlarmTimeWindowEnd_tuple)
                records.AlarmTimeWindow_minutes=int((records.AlarmTimeWindowEnd_seconds-records.AlarmTimeWindowStart_seconds)/60)
                if(records.AlarmTimeWindowStart_tuple!=-1): records.AlarmIsSet=True

            if(records.SWversion>=2.1):
                #process header line 6
                tmp=file.readline()
                tmp=string.replace(tmp[:-1], "Use alternative Alarm: ", "")
                if(tmp=="False"): records.UseAlternativeAlarm=False
                else: records.UseAlternativeAlarm=True

                #process header line 7
                tmp=file.readline()
                records.AlternativeAlarm=string.replace(tmp[:-1], "Alternative Alarm: ", "")

           #process header line 8
            tmp=file.readline()
            records.Note=string.replace(tmp[:-1].decode("utf-8"), "Note: ", "")

            if(records.SWversion>=2.0):
                #process header line 9..12
                tmp=file.readline()
                tmp=string.replace(tmp[:-1], "Lucid dream song start: ", "")
                if(tmp=="Not set"):
                    records.Use_Lucid_Dream_Song=False
                    file.readline() #drop line
                    file.readline() #drop line
                    file.readline() #drop line
                    file.readline() #drop line
                else: #used lucid dream option
                    records.Use_Lucid_Dream_Song=True
                    if(tmp!="never"):
                        records.Lucid_Dream_Song_Start_tuple=time.strptime(tmp, data.dateformat)
                    else:
                        records.Lucid_Dream_Song_Start_tuple=-1
                    tmp=file.readline()
                    records.Lucid_Dream_Song=string.replace(tmp[:-1], "Lucid dream song: ", "")
                    tmp=file.readline()
                    records.Lucid_Dream_Song_Delay=int(string.replace(tmp[:-1], "Lucid dream song delay: ", ""))
                    tmp=file.readline()
                    records.Lucid_Dream_Song_Duration=int(string.replace(tmp[:-1], "Lucid dream song duration: ", ""))
                    tmp=file.readline()
                    records.Lucid_Dream_Song_Volume=int(string.replace(tmp[:-1], "Lucid dream song volume: ", ""))

                #process header line 13..16
                tmp=file.readline()
                tmp=string.replace(tmp[:-1], "WakeUp song start: ", "")
                if(tmp=="Not set"):
                    records.Use_WakeUp_Song=False
                    file.readline() #drop line
                    file.readline() #drop line
                    file.readline() #drop line
                else: #used lucid dream option
                    records.Use_WakeUp_Song=True
                    if(tmp!="never"):
                        records.WakeUp_Song_Start_tuple=time.strptime(tmp, data.dateformat)
                    else:
                        records.WakeUp_Song_Start_tuple=-1
                    tmp=file.readline()
                    records.WakeUp_Song=string.replace(tmp[:-1], "WakeUp song: ", "")
                    tmp=file.readline()
                    records.WakeUp_Song_Duration=int(string.replace(tmp[:-1], "WakeUp song duration: ", ""))
                    tmp=file.readline()
                    records.WakeUp_Song_Volume=int(string.replace(tmp[:-1], "WakeUp song volume: ", ""))

            if(records.SWversion>=2.0):
                #spare lines 17..21
                tmp=file.readline() #drop line
                tmp=file.readline() #drop line
                tmp=file.readline() #drop line
                tmp=file.readline() #drop line
                tmp=file.readline() #drop line

          #process header line 22
            tmp=file.readline()  #not used, column header

        print "Record header successful read"
    except:
        print "Record header data corrupt"
        records.status=_("File header corrupted or not compatible")
        records.statusID="HEADER_CORRUPTED"
#        print sys.exc_info()
        file.close()
        return 8

    #header loaded, now load data
    records.Index=0
    try: #get data
        for line in file:
    #        d=string.split(line[:-1], ", ")
    #        print line
            d=string.split(line, ",")
            records.arrData[0][records.Index]=d[0] #time
            records.arrData[1][records.Index]=int(d[1]) #X
            records.arrData[2][records.Index]=int(d[2]) #Y
            if(records.SWversion<1.8): #workaround for old files (versions <1.8 had only X and Y axis stored)
                records.arrData[3][records.Index]=0 #Z
            else:
#                print d[3]
                records.arrData[3][records.Index]=int(d[3]) #Z

            records.Index=records.Index+1
            if(records.Index==records.MaxArrayDataLen-1):
                print "Stopped, array is full, file is to big. Loaded ", records.Index, "lines"
                records.status="Data array is full"
                records.statusID="ARRAY_FULL"
                break
    except:
        print "File is corrupted!!!"
        records.status=_("File is corrupted or not compatible")
        records.statusID="FILE_CORRUPTED"
        file.close()
        return 3 #corrupted file
    finally:
        file.close()

    if(records.Index==0):
        print "No movement data in record"
        records.status=_("No movement data in file to be shown")
        records.statusID="NO_DATA"
        return 4

    if(records.SWversion<1.6): #workaround for old files
        if(records.Index>0): records.StartTime_tuple=time.strptime(Startdate_date+" "+str(records.arrData[0][0]), " %d-%m-%Y %H:%M:%S") #no data anyway
        else: records.StartTime_tuple=time.strptime(Startdate_date+" 00:00:00", " %d-%m-%Y %H:%M:%S") #no data anyway
        records.StartTime_seconds=Tuple2Seconds(records.StartTime_tuple)

    #calculate end time
    records.EndTime_seconds=Tuple2Seconds(records.StartTime_tuple)+records.Index*records.Sampling_interval*records.Value_smoothing/1000
    records.EndTime_tuple=Seconds2Tuple(records.EndTime_seconds)

    print "Loaded successful", records.Index, "lines"
    if(records.AlarmIsSet==True):
        records.LastIndex=max(records.Index, Tuple2Index(records.AlarmTimeWindowEnd_tuple)+5) #the very last index to be shown (incl. AlarmTimeWindowEnd
        if(data.debug==True): print "But will show up to index", records.LastIndex, "as the AlarmTimeWindow ends there"
    else: records.LastIndex=records.Index

    records.status=_("Data successful loaded")
    records.statusID="OK"

    if(data.debug==True): PrintRecordData(False)
    print "Data successful loaded"
    return 0 #all ok





###########################################################################
## Function:    UpdateFileHeader
## Description: This function updates the header data
## Parameters:  none
## Returns:     none
###########################################################################
def UpdateFileHeader():
    try:
        file = open(data.RecordFolder+data.RecordFilename, 'w')
    except: #can not open, might be read only file system
        print "ERROR! Can not open file for write access"
        Notify(_("Can not update the data! File system might be read only"))
        return


    print "Update header in RecordFile", data.RecordFilename

    h=CreateHeader()
    file.write(h)
    i=0
    for i in range(0, records.Index):
        d=str(records.arrData[0][i]) + ", " + str(records.arrData[1][i]) + ", " +  str(records.arrData[2][i]) + \
            ", " +  str(records.arrData[3][i])
#        d=str(records.arrData[0][i]) + ", " + str(records.arrData[1][i]) + ", " +  str(records.arrData[2][i]) + \
#            ", " +  str(records.arrData[3][i]) + ", " +  str(records.arrData[5][i])
        file.write(d+"\n")
    file.close()
    if(data.debug==True): print "Wrote", i +1, "records into file"
