# -*- coding: utf-8 -*-

###########################################################################
## File:        functions_general.py
## Description: This file includes various functions
###########################################################################

from PyQt4.QtCore import *
from PyQt4.QtGui import *
from PyQt4 import QtCore, QtGui

import sys
import os
#import random
import time
from time import strftime
#import math
#import array
import string

import ConfigParser
import os, os.path

import dbus
from dbus.mainloop.qt import DBusQtMainLoop

#import shlex, subprocess

#import pygst
#pygst.require("0.10")
##import gobject
##gobject.threads_init()
#import gst

import data
import filter_data #filter
import records #record data

import i18n #load language file
_ = i18n.language.ugettext




###########################################################################
## Function:    LoadConfig
## Description: This function loads the preset names from the preset names file
##                If the parameter is missing in the file, it uses the default value
## Parameters:  none
## Returns:     none
###########################################################################
def LoadPresetNames():
    global PresetNames
    print "Load preset names"

    PresetNames = ConfigParser.SafeConfigParser()
    try:
        PresetNames.read(data.configFolder+data.PresetNamesFile)
    except: #use default PresetNames
        print "PresetNames file "+data.configFolder+data.PresetNamesFile + " not existing or not compatible"

    try:
        PresetNames.add_section('main')
    except:
        pass

    for i in range(0, 4):
        try:
            tmp=PresetNames.get('main', 'preset'+str(i+1))
            data.preset_names[i] = tmp.decode("utf-8")
        except:
            data.preset_names[i]=str(_("Preset")+" "+str(i+1))
            PresetNames.set('main', 'preset'+str(i+1), data.preset_names[i])

  #  print data.preset_names




###########################################################################
## Function:    WritePresetNames
## Description: This function loads the preset names into the preset names file
## Parameters:  none
## Returns:     none
###########################################################################
def WritePresetNames():
    global PresetNames
    print "Write preset names"

    for i in range(0, 3):
        PresetNames.set('main', 'Preset'+str(i+1),  str(data.preset_names[i].encode( "utf-8" )))


    f=data.configFolder+data.PresetNamesFile
    if(data.debug==True): print "Save preset names ("+f+")"
    if (not os.path.exists(str(data.configFolder))):
        print "Create configuration folder: ", data.configFolder
        os.mkdir(data.configFolder)
    try:
        handle = open(f, 'w')
        PresetNames.write(handle)
        handle.close()
        print "Preset names saved"
    except:
        print "Failed to write preset names file!"






###########################################################################
## Function:    LoadConfig
## Description: This function loads the data from the config file
##                If the parameter is missing in the config file, it uses
##                the default value from file data.py
## Parameters:  none
## Returns:     none
###########################################################################
def LoadConfig():
    #get configuration
    global config
    if(data.debug==True): print "Configuration file:", data.configFolder+data.ConfigFile
    config = ConfigParser.SafeConfigParser()
    try:
        config.read(data.configFolder+data.ConfigFile)
    except: #use default config
        print "Configuration file "+data.configFolder+data.ConfigFile + " not existing or not compatible"

    try:
        config.add_section('main')
    except:
        pass




    data.Sampling_interval = Config_Load_Int('main', 'sampling', data.Sampling_interval)
    data.Sample_smoothing = Config_Load_Int('main', 'Sample_smoothing', data.Sample_smoothing)
    data.Value_smoothing = Config_Load_Int('main', 'Value_smoothing', data.Value_smoothing)
    data.Trigger = Config_Load_Int('main', 'Trigger', data.Trigger)
    data.Derivation = Config_Load_Int('main', 'Derivation', data.Derivation)
    data.Ysize = Config_Load_Int('main', 'Ysize', data.Ysize)
    data.Xscale = Config_Load_Int('main', 'Xscale', data.Xscale)
    data.Yscale_Movement = Config_Load_Int('main', 'Yscale_Movement', data.Yscale_Movement_default)
    data.derivation_offset = Config_Load_Int('main', 'derivation_offset', data.derivation_offset)
    data.Yscale_Sleep_Pattern = Config_Load_Int('main', 'Yscale_Sleep_Pattern', data.Yscale_Sleep_Pattern_default)
    data.Yoffset_Sleep_Pattern = Config_Load_Int('main', 'Yoffset_Sleep_Pattern', data.Yoffset_Sleep_Pattern_default)
    data.limitMovement = Config_Load_Int('main', 'limitMovement', data.limitMovement)
    data.DelayStartTime = Config_Load_Int('main', 'DelayStartTime', data.DelayStartTime)
    data.AlarmHour = Config_Load_Int('main', 'AlarmHour', data.AlarmHour)
    data.AlarmMinute = Config_Load_Int('main', 'AlarmMinute', data.AlarmMinute)
    data.AlarmTimeWindow = Config_Load_Int('main', 'AlarmTimeWindow', data.AlarmTimeWindow)
    data.Lucid_Dream_Song_Volume = Config_Load_Int('main', 'Lucid_Dream_Song_Volume', data.Lucid_Dream_Song_Volume)
    data.Lucid_Dream_Song_Delay = Config_Load_Int('main', 'Lucid_Dream_Song_Delay', data.Lucid_Dream_Song_Delay)
    data.Lucid_Dream_Song_Duration = Config_Load_Int('main', 'Lucid_Dream_Song_Duration', data.Lucid_Dream_Song_Duration)
    data.WakeUp_Song_Volume_Increase_Step = Config_Load_Int('main', 'WakeUp_Song_Volume_Increase_Step', data.WakeUp_Song_Volume_Increase_Step)
    data.WakeUp_Song_Volume = Config_Load_Int('main', 'WakeUp_Song_Volume', data.WakeUp_Song_Volume)
    data.WakeUp_Song_Duration = Config_Load_Int('main', 'WakeUp_Song_Duration', data.WakeUp_Song_Duration)
    data.Light_Sleep_Level = Config_Load_Int('main', 'Light_Sleep_Level', data.Light_Sleep_Level_default)
    data.Deep_Sleep_Level = Config_Load_Int('main', 'Deep_Sleep_Level', data.Deep_Sleep_Level_default)


#    data.user = Config_Load_String('main', 'user', data.user)
    try:
        tmp=config.get('main', 'user')
        data.user = tmp.decode("utf-8")
    except:
        config.set('main', 'user', str(data.user.encode( "utf-8" )))

    data.LastRecord = Config_Load_String('main', 'LastRecord', data.LastRecord)
    data.AlternativeAlarm = Config_Load_String('main', 'AlternativeAlarm', data.AlternativeAlarm)
    data.Lucid_Dream_Song = Config_Load_String('main', 'Lucid_Dream_Song', data.Lucid_Dream_Song)
    data.WakeUp_Song = Config_Load_String('main', 'WakeUp_Song', data.WakeUp_Song)
    data.cliStart = Config_Load_String('main', 'cliStart', data.cliStart)
    data.cliStop = Config_Load_String('main', 'cliStop', data.cliStop)


    data.OfflineMode = Config_Load_Bool('main', 'OfflineMode', data.OfflineMode)
    data.SilentProfile = Config_Load_Bool('main', 'SilentProfile', data.SilentProfile)
    data.DimmDisplay = Config_Load_Bool('main', 'DimmDisplay', data.DimmDisplay)
    data.UseAlarm = Config_Load_Bool('main', 'UseAlarm', data.UseAlarm)
    data.StopAfterAlarm = Config_Load_Bool('main', 'StopAfterAlarm', data.StopAfterAlarm)
    data.Use_Lucid_Dream_Song = Config_Load_Bool('main', 'Use_Lucid_Dream_Song', data.Use_Lucid_Dream_Song)
    data.Use_WakeUp_Song = Config_Load_Bool('main', 'Use_WakeUp_Song', data.Use_WakeUp_Song)
    data.UseAlternativeAlarm = Config_Load_Bool('main', 'UseAlternativeAlarm', data.UseAlternativeAlarm)




## Add forced configuration changes here
    configFileVersion = Config_Load_Int('main', 'configFileVersion', 0)
    if(configFileVersion<data.configFileVersion): #config file is old, update some parameters...
        if(data.configFileVersion<=3):
            data.Yscale_Movement=data.Yscale_Movement_default
            config.set('main', 'Yscale_Movement', str(data.Yscale_Movement_default))

        QMessageBox.critical(None, "Changes in SleepAnalyser",
        "There are many new functions and changes in SleepAnalyser. " + \
        "Please have a look in the help menu to see what has changed. " + \
        "Because of the changes some parameters might need readjustment. " + \
        "You can change them in the configuration menu.")

    else: #config file up to date
        pass

    print "Configuration successful loaded from "+data.ConfigFile
#    PrintConfig() ##debug only
    return config






###########################################################################
## Function:    Config_Load_String
## Description: Loads a string from the configuration. Uses default value in case econfig ntry does not exist
## Parameters:  section,  entry,  default
## Returns:     value
###########################################################################
def Config_Load_String(section,  entry,  default):
    try:
 #       return (config.get(section, entry)).decode("utf-8")
        return (config.get(section, entry))
    except:
        config.set(section, entry, str(default))
#        config.set(section, entry, str(default.encode( "utf-8" )))
        return str(default)






###########################################################################
## Function:    Config_Load_Bool
## Description: Loads a bool value from the configuration. Uses default value in case econfig ntry does not exist
## Parameters:  section,  entry,  default
## Returns:     value
###########################################################################
def Config_Load_Bool(section,  entry,  default):
    try:
        tmp=config.get(section, entry)
        if(tmp=="True"):  return True
        else: return False
    except:
        config.set(section, entry, str(default))
        return default





###########################################################################
## Function:    Config_Load_Int
## Description: Loads an integer from the configuration. Uses default value in case econfig ntry does not exist
## Parameters:  section,  entry,  default
## Returns:     value
###########################################################################
def Config_Load_Int(section,  entry,  default):
    try:
        return config.getint(section, entry)
    except:
        config.set(section, entry, str(default))
        return int(default)





###########################################################################
## Function:    WriteConfig
## Description: This function loads the config into the config file
## Parameters:  none
## Returns:     none
###########################################################################
def WriteConfig():
    global config
    config.set('main', 'Trigger', str(data.Trigger))
    config.set('main', 'ConfigFileVersion', str(data.configFileVersion))

    f=data.configFolder+data.ConfigFile
    if(data.debug==True): print "Save configuration ("+f+")"
    if (not os.path.exists(str(data.configFolder))):
        print "Create configuration folder: ", data.configFolder
        os.mkdir(data.configFolder)
    try:
        handle = open(f, 'w')
        config.write(handle)
        handle.close()
        print "Configuration saved"
    except:
        print "Failed to write configuration file!"




###########################################################################
## Function:    PrintConfig
## Description: This function prints out the current configuration
##                It is for debugging only
## Parameters:  none
## Returns:     none
###########################################################################
def PrintConfig():
    print "###################### CONFIG DATA #######################"
    a=config.items("main")
    for i in range(0, len(a)): #print data
        print a[i]
    print "##########################################################"




###########################################################################
## Function:    Seconds2Tuple
## Description: This function converts the integer value of seconds since 1970
##                into a time tuple
## Parameters:  seconds since 1970
## Returns:     time tuple
###########################################################################
def Seconds2Tuple(secs):
    tuple=time.localtime(secs)
    return tuple




###########################################################################
## Function:    Tuple2Seconds
## Description: This function converts the time tupple into an integer
##                of seconds since 1970
## Parameters:  time tuple
## Returns:     seconds since 1970
###########################################################################
def Tuple2Seconds(Tuple):
    secs=int(time.mktime(Tuple))
    return secs




###########################################################################
## Function:    Tuple2Index
## Description: This function calculates the index in the recod array from
##                the parameter Tuple, relative to the record start time
## Parameters:  time Tuple
## Returns:     record array index
###########################################################################
def Tuple2Index(Tuple):
    t0=records.StartTime_seconds
    t1=Tuple2Seconds(Tuple)
    tdiff=t1-t0
    return int((tdiff-10)*1000/(records.Sampling_interval*records.Value_smoothing))+3





###########################################################################
## Function:    Index2Tuple
## Description: This function calculates the time tuple out of the
##                parameter Index relative to the record start time
## Parameters:  Index from record array
## Returns:     time tuple
###########################################################################
def Index2Tuple(Index):
    tdiff=int(Index*records.Sampling_interval*records.Value_smoothing/1000-3)+10
    t=records.StartTime_seconds+tdiff
    return Seconds2Tuple(t)








###########################################################################
## Function:    SwitchModes
## Description: This function switches to offline mode and silence profile
##                if requested and restores the previos state after the recording
## Parameters:  start: True (recording start), False (recording end)
## Returns:     none
###########################################################################
def SwitchModes(start):
    if(data.DeviceIsN900==True): #We are on a N900
        if(data.QuickMode==False):  #only do in normal recording mode
            if(start==True): #start of recording
                if(data.SwitchedModes==False): #protection so it only gets switched once
                    data.SwitchedModes=True
                    if(data.OfflineMode==True): #change to offline mode
                        set_profile(False)
                    if(data.SilentProfile==True): #change to silent profile
                        set_silent(True)
                    data.PreviousVolume=GetVolume()

                    if(data.DimmDisplay==True): #dimm display brightness
                        SetBrightness(data.RecordingBrightness)

                    if(data.cliStart!=""):
                        cmd=data.cliStart+" &" #Expert option to run a script at recording start
                        print "### Run command: ", cmd
                        b = os.popen(cmd)
                        b.close()

            else: #end of recording
                if(data.SwitchedModes==True): #protection so it only gets switched once
                    data.SwitchedModes=False
                    if(data.OfflineMode==True): #change to online mode
                       set_profile(True)
                    if(data.SilentProfile==True): #change to general profile
                        set_silent(False)
                    SetVolume(data.PreviousVolume)

                    if(data.cliStop!=""):
                        cmd=data.cliStop+" &" #Expert option to run a script at recording stop
                        print "### Run command: ", cmd
                        b = os.popen(cmd)
                        b.close()




###########################################################################
## Function:    set_profile
## Description: This function switches to the requested online/offline mode
## Parameters:  online: True (switch to online mode), False (switch to offline mode)
## Returns:     none
###########################################################################
def set_profile(online):
    if(online==True):
        try:
            if(data.PreviousMode=="normal"): #was online mode (before start measurement), so restore
                print "Change to online mode"
                cmd="dbus-send --system --dest=com.nokia.mce --type=method_call /com/nokia/mce/request com.nokia.mce.request.req_device_mode_change string:\"normal\""
                os.popen(cmd)
        except:
            pass
    else: #offline
        try:
            cmd="dbus-send --system --dest=com.nokia.mce --print-reply --type=method_call /com/nokia/mce/request com.nokia.mce.request.get_device_mode"
            ret=os.popen2(cmd) #get current mode
            p=ret[1].readline() #not used
            p=ret[1].readline()
            tmp=string.split(p, "\"")
            data.PreviousMode=tmp[1]
            if(data.PreviousMode=="normal"): #was normal, change to offline
                print "Change to offline mode"
                cmd="dbus-send --system --dest=com.nokia.mce --type=method_call /com/nokia/mce/request com.nokia.mce.request.req_device_mode_change string:\"offline\""
                os.popen(cmd)
        except:
            pass







###########################################################################
## Function:    set_silent
## Description: This function switches to the requested profile
## Parameters:  silent: True (switch to silent profile), False (switch to normal profile)
## Returns:     none
###########################################################################
def set_silent(silent):
    if(silent==True):
        try:
            cmd="dbus-send --type=method_call --print-reply --dest=com.nokia.profiled /com/nokia/profiled com.nokia.profiled.get_profile"
            ret=os.popen2(cmd) #get current profile
            p=ret[1].readline() #not used
            p=ret[1].readline()
            tmp=string.split(p, "\"")
            data.PreviousProfile=tmp[1]
            if(data.PreviousProfile=="general"): #was general profile, change to silent profile
                cmd="dbus-send --type=method_call --dest=com.nokia.profiled /com/nokia/profiled com.nokia.profiled.set_profile string:\"silent\" | echo \"\""
                os.popen(cmd)
                print "Silent Profile activated"
                Notify(_("Silent Profile activated"))
        except:
            pass
    else: #normal
        try:
            if(data.PreviousProfile=="general"): #was general (before start measurement), so restore to general
                cmd="dbus-send --type=method_call --dest=com.nokia.profiled /com/nokia/profiled com.nokia.profiled.set_profile string:\"general\" | echo \"\""
                os.popen(cmd)  #set profile
                print "General Profile activated"
                Notify(_("General Profile activated"))
                os.popen(cmd)  #notification
        except:
            pass




###########################################################################
## Function:    SetVolume
## Description: This function sets the requested volume
## Parameters:  volume percent: 0..100
## Returns:     none
###########################################################################
def SetVolume(percent):
    p=int(percent)
    cmd="dbus-send --type=method_call --dest=com.nokia.mafw.renderer.Mafw-Gst-Renderer-Plugin.gstrenderer /com/nokia/mafw/renderer/gstrenderer com.nokia.mafw.extension.set_extension_property string:volume variant:uint32:"+str(p)
    os.popen(cmd)
#    data.CurrentVolume=percent





###########################################################################
## Function:    GetVolume
## Description: This function returns the requested volume
## Parameters:  none
## Returns:     volume percent: 0..100
###########################################################################
def GetVolume():
    if(data.DeviceIsN900==True): #we are on a N900
        bus = dbus.SessionBus()
        obj = bus.get_object("com.nokia.mafw.renderer.Mafw-Gst-Renderer-Plugin.gstrenderer",
            "/com/nokia/mafw/renderer/gstrenderer")
        mafw = dbus.Interface(obj, "com.nokia.mafw.extension")
        volume = int(mafw.get_extension_property("volume")[1])
    #    print "volume,", volume
        return volume








###########################################################################
## Function:    GetBrightness
## Description: Get display brightness, store it in data.PreviousBrightness
## Parameters:  none
## Returns:     none
###########################################################################
def GetBrightness():
    if(data.DeviceIsN900==True): #we are on a N900
 #       output = os.popen("cat /sys/class/backlight/acx565akm/brightness").read() # run cmd and make the output look like a file I can read
        output = os.popen("gconftool -g /system/osso/dsm/display/display_brightness").read() # run cmd and make the output look like a file I can read
        data.PreviousBrightness=int(output)
        print "Get current brightness level:", data.PreviousBrightness




###########################################################################
## Function:    SetBrightness
## Description: Set display brightness
## Parameters:  brigntness level (1..5)
## Returns:     none
###########################################################################
def SetBrightness(b):
    if(data.DeviceIsN900==True): #we are on a N900
        print "Set brightness level :", b
 #       cmd="echo "+ str(b)+" > /sys/class/backlight/acx565akm/brightness"
        cmd ="gconftool -s /system/osso/dsm/display/display_brightness -t int "+str(b)
        b = os.popen(cmd)
        b.close()






###########################################################################
## Function:    Notify
## Description: Shows a notification message
## Parameters:  text to be shown
## Returns:     none
###########################################################################
def Notify(notify_txt):
    notify_cmd="dbus-send --type=method_call --dest=org.freedesktop.Notifications /org/freedesktop/Notifications org.freedesktop.Notifications.SystemNoteInfoprint string:\""+notify_txt+"\""
    os.popen(notify_cmd.encode( "utf-8" ))




###########################################################################
## Function:    getFileList
## Description: Returns an array with a file list in a given directory
## Parameters:  directory, file filter
## Returns:     array with files
###########################################################################
def getFileList(path,  filter):
    output = os.popen("cd \""+str(path)+"\"; ls -C1 "+str(filter)).read() # run ls and make the output look like a file I can read
    #Note: Above command could also be implemented with os.listdir(). This might give a minor speed improvement
    arr=output.split("\n")
    arr.pop()
    print len(arr), "files ("+filter+") in", path
    return arr





###########################################################################
## Function:    PlaySong
## Description: Sets the requested volume and opens the media player with the requested song
## Parameters:  volume percent (0..100), path to song file
## Returns:     none
###########################################################################
def PlaySong(volume, filename):
    data.SongIsPlaying=True
    print strftime("%x %X"), "Play", filename, "with volume", volume
    cmd="dbus-send --print-reply --dest=com.nokia.mediaplayer /com/nokia/mediaplayer com.nokia.mediaplayer.mime_open string:\"file:///"+str(filename)+"\""
#    cmd="mplayer \""+str(filename)+"\""
    SetVolume(volume)
    b = os.popen(cmd)
    b.close()
#    proc = subprocess.Popen(cmd, shell=True)

#    data.gstream_player = gst.element_factory_make("playbin2", "player")
#    fakesink = gst.element_factory_make("fakesink", "fakesink")
#    data.gstream_player.set_property("video-sink", fakesink)
#
#    data.gstream_player.set_property("uri", "file://" + filename)
#    data.gstream_player.set_state(gst.STATE_PLAYING)








###########################################################################
## Function:    PauseSong
## Description: This function switches the media player to pause
## Parameters:  none
## Returns:     volume percent: 0..100
###########################################################################
#def PauseSong():
#    print strftime("%x %X"), "Pause song (if active)"
#    cmd="dbus-send --dest=com.nokia.mafw.renderer.Mafw-Gst-Renderer-Plugin.gstrenderer /com/nokia/mafw/renderer/gstrenderer com.nokia.mafw.renderer.pause"
#    b = os.popen(cmd)
#    b.close()





###########################################################################
## Function:    StopMediaPlayer
## Description: This function closes the media player
## Parameters:  none
## Returns:     none
###########################################################################
def StopMediaPlayer():
    if(data.SongIsPlaying==True):
        data.SongIsPlaying=False
        print strftime("%x %X"), "Stop mediaplayer"
        cmd="killall mediaplayer"
#        cmd="killall mplayer"
        b = os.popen(cmd)
        b.close()
#        data.gstream_player.set_state(gst.STATE_NULL)




###########################################################################
## Function:    GetSongLength
## Description: This function returns the duration of a song
## Parameters:  path to song file
## Returns:     song duration in seconds
###########################################################################
def GetSongLength(filename):
    print "get song length for file:", filename
    output = os.popen("ffmpeg -i \""+str(filename)+"\" 2>&1 | grep Duration").read() # run ffmpeg and make the output look like a file I can read
    arr=output.split(".")
    arr=arr[0].split(":")

#TODO: Figure out why ffmeg not can return duration on some files
    try:
        duration=int(int(arr[1])*3600+int(arr[2])*60+int(arr[3]))
    except:
        duration=300 #set to 5 minutes
        print "ERROR: Could not get song length!"
        print "Set to default 5 minutes"
    return duration




###########################################################################
## Function:    StopMediaPlayer
## Description: This function can measure the time needed for a certain code block
##                It is only used for debugging
## Parameters:  text to be printer, reset time: True/False
## Returns:     none
############################################################################
#def Show_passed_time(text="", reset=False):
#    if(data.debug==False): return
#    now=time.time()
#    if(reset==True): data.passed_time=now
#
#    t=1000*(now-data.passed_time)
#    t2=1000*(now-data.passed_time2)
#    print "### ", str(int(t)), "ms, (", str(int(t2)), "ms delta): ", text
#
#    data.passed_time2 = time.time()
