# -*- coding: utf-8 -*-

from PyQt4 import QtCore, QtGui

import sys
import os
import random
import time
from time import strftime
import math
import array
import string

import ConfigParser
import os, os.path

import data
import records #record data

#own functions
from functions_general import *
from functions_record import *

try:
    import alarm #maemo specific
except:
    pass


#load language file
import i18n
_ = i18n.language.ugettext


###########################################################################
## Sets the MAEMO alarm
###########################################################################
def SetAlarm():
    if(data.DeviceIsN900==True): #We are on a N900
        event = alarm.Event()
        event.appid = 'SleepAnalyser'
        txt=_('Wake up (SleepAnalyser)')
        event.message =str(txt.encode( "utf-8" ))

        event.alarm_time = records.AlarmTime_seconds #in seconds

        action_snooze, action_stop = event.add_actions(2)
        txt=_('Snooze')
        action_snooze.label=str(txt.encode( "utf-8" ))
        action_snooze.flags |= alarm.ACTION_WHEN_RESPONDED | alarm.ACTION_TYPE_SNOOZE
        txt=_('Stop')
        action_stop.label =str(txt.encode( "utf-8" ))
        action_stop.flags |= alarm.ACTION_WHEN_RESPONDED | alarm.ACTION_TYPE_NOP

        data.AlarmID = alarm.add_event(event)

        event = alarm.get_event(data.AlarmID) #read out again to check if set correctly
        print "* Alarm will go off on:",  time.ctime(event.trigger)
    else:
        print "* Will not set alarm, Maemo interface not available"
        data.AlarmID=1

    data.AlarmIsActive=False



###########################################################################
## Delete all MAEMO alarms with appid "SleepAnalyser"
## When SleepAnalyser crashed, it is possible that there is still an (old) alarm  in the dbus alarm queue
## This function deletes them all
###########################################################################
def delete_all_preexisting_Alarms():
    print "* Search and delete all alarms from SleepAnalyser"
    if(data.DeviceIsN900==True): #We are on a N900
        event = alarm.query_event(0, 0, 0, 0, "") #get list of all set alarm in N900
        i=0
        for e in event:
            e2=alarm.get_event(e)
#            print time.ctime(e2.trigger), e2.appid, e2.message #print all alarms
            if(e2.appid=="SleepAnalyser"): #filter our alarms
#                print "Found one of our Alarms:", time.ctime(e2.trigger), e2.appid , e2.title, e2.message #print our alarms
                alarm.delete_event(e)
                i=i+1
#                print "Deleted it"
        if(i==0): print "* No old alarms found"
        else: print "* Found", i, "of our alarms and deleted them"
    else:
        print "* Will not delete alarm, Maemo interface not available"





###########################################################################
## Deletes the set MAEMO alarm
###########################################################################
def DeleteAlarm():
    if(data.AlarmID!=-1): #there is an old alarm to be deleted
        if(data.DeviceIsN900==True): #We are on a N900
            try:
                event = alarm.get_event(data.AlarmID) #get data of to be deleted alarm
                alarm.delete_event(data.AlarmID)

                print "* Delete old Alarm:",  time.ctime(event.trigger)
            except:
                pass
        else:
            print "* Will not delete alarm, Maemo interface not available"

        data.AlarmID=-1

        if(data.AlarmIsActive==False): #if alarm never came, remove from record
            records.AlarmTime_seconds=-1
            records.AlarmTime_tuple=-1
    else:
        if(data.debug==True): print "* No alarm to be deleted"

    data.AlarmIsActive=False







###########################################################################
## Gets called in the timer loop
## Checks if the alarm should be set off
###########################################################################
def ProcessAlarm():
    i=records.Index-data.Derivation
#    if(i>1): peak=records.arrData[4][i-1] #check if last movement is over trigger level
    if(i>1): peak=records.arrData[6][i-1] #New: use blue graph for triggering
    else: peak=0
    now=Tuple2Seconds(time.localtime())
#    if(peak>data.Trigger): #big Movement
    if(peak>(data.Trigger*data.Yscale_Sleep_Pattern*3/40)): #Trigger Alarm
       if(records.AlarmIsSet==True and data.AlarmIsActive==False): #alarm is set
            if(now>=records.AlarmTimeWindowStart_seconds and now<records.AlarmTimeWindowEnd_seconds): # we are in alarm time window
                if(data.WakeUp_SongIsActive==False):#wake up song (if enabled) is not playing
                    print "************ ALARM ALARM (Movement over trigger level)"
                    print "*", strftime("%x %X"), "ProcessAlarm => DeleteAlarm" #for log file
                    DeleteAlarm() #delete old alarm if existing
                    records.AlarmTime_tuple=time.localtime()#set to now
                    records.AlarmTime_seconds=Tuple2Seconds(records.AlarmTime_tuple)

                    if(records.Use_WakeUp_Song==True): #Delay alarm, so we can first play wake up song
                        print "* Alarm would be now:", records.AlarmTime_tuple
                        print "* But wake Up song is enabled, delay alarm for", records.WakeUp_Song_Duration/60, "minutes"
                        records.AlarmTime_seconds=min(records.AlarmTime_seconds+records.WakeUp_Song_Duration+10, records.AlarmTimeWindowEnd_seconds) #add delay time, but max until alarm time window
                        records.AlarmTime_tuple=Seconds2Tuple(records.AlarmTime_seconds)
                        data.WakeUp_SongIsActive=True
                        records.WakeUp_Song_Start_tuple=Seconds2Tuple(now)
                        print "* Delay alarm until:", records.AlarmTime_tuple

                        print "** Play wake up song"
#                        PlaySong(records.WakeUp_Song_Volume, records.WakeUp_Song)
                        PlaySong(0, records.WakeUp_Song) #startquiet, get louder over time

                    print "*", strftime("%x %X"), "ProcessAlarm => SetAlarm" #for log file
                    SetAlarm() #set alarm to go off now (or with wake up song delay)

                if(now >= records.AlarmTime_seconds): #alarm is due
                    records.Trigger=data.Trigger #update Trigger level on alarm occurence
                    data.AlarmIsActive=True
                    data.Lucid_Dream_SongIsActive=True #make sure lucid dream option will not run after wake up option got active
#                    PauseSong() #stop playing song, in case it was playing
                    CloseMediaPlayer() #close media player

    elif(now>=records.AlarmTimeWindowEnd_seconds): #End of alarm time window, set alarm off anyway
        if(records.AlarmIsSet==True and data.AlarmIsActive==False): #Alarm is set and not active yet
            print "************ ALARM ALARM (End of Alarm Time Window)"
            records.Trigger=data.Trigger #update Trigger level on alarm occurence
            data.AlarmIsActive=True
            data.Lucid_Dream_SongIsActive=True #make sure lucid dream option will not run after wake up option got active
#            PauseSong() #stop playing song, in case it was playing
            CloseMediaPlayer() #close media player


    if(data.WakeUp_SongIsActive==True): #when WakeUp music is active, increase volume over time
        if(records.WakeUp_Song_Volume>data.CurrentVolume):
            SetVolume(data.CurrentVolume+1)
            print "Increase volume to:", data.CurrentVolume


###########################################################################
## Checks if it is time to start the ucid dream song
###########################################################################
def ProcessLucid_Dream(): #Lucid dream option
    if(records.Use_Lucid_Dream_Song==True and data.Lucid_Dream_SongIsActive==False):
        GenerateStatisticData()
#        print records.arrStatData[1][2], records.arrStatData[2][2]
        if(records.arrStatData[1][2] >= records.Lucid_Dream_Song_Delay or records.arrStatData[2][2] >= records.Lucid_Dream_Song_Delay):
            data.Lucid_Dream_SongIsActive=True
            records.Lucid_Dream_Song_Start_tuple=time.localtime() #now
            print "Play Lucid dream song"
            PlaySong(records.Lucid_Dream_Song_Volume, data.Lucid_Dream_Song)
