import os, sys
import locale
import gettext

import data #own data

# Change this variable to your app name!
#  The translation files will be under
#  @LOCALE_DIR@/@LANGUAGE@/LC_MESSAGES/@APP_NAME@.mo
#
APP_NAME = "SleepAnalyser"

# This is ok for maemo. Not sure in a regular desktop:
#
#APP_DIR = os.path.join (sys.prefix,
                     #'share')
#LOCALE_DIR = os.path.join(APP_DIR, 'locale')

#LOCALE_DIR = data.app_path+"i18n/"
LOCALE_DIR = data.app_path+"i18n/"

#print "LOCALE_DIR:", LOCALE_DIR

# Now we need to choose the language. We will provide a list, and gettext
# will use the first translation available in the list
#
#  In maemo it is in the LANG environment variable
#  (on desktop is usually LANGUAGES)
#
DEFAULT_LANGUAGES = os.environ.get('LANG', '').split(':')
DEFAULT_LANGUAGES += ['en_US']

# Try to get the languages from the default locale
lc, encoding = locale.getdefaultlocale()
#print lc
if lc:
 languages = [lc]


# Concat all languages (env + default locale),
#  and here we have the languages and location of the translations
#
languages += DEFAULT_LANGUAGES
mo_location = LOCALE_DIR

#print "languages:", languages

# Lets tell those details to gettext
#  (nothing to change here for you)
gettext.install (True)


#gettext.bindtextdomain (APP_NAME,mo_location)
#gettext.bindtextdomain(domain[, localedir])
#gettext.find(domain[, localedir[, languages[, all]]])
gettext.find(APP_NAME, mo_location)

gettext.textdomain (APP_NAME)

#gettext.bind_textdomain_codeset(APP_NAME, "iso-8859-15")

#language = gettext.translation (APP_NAME, mo_location, languages = languages, fallback = True)
language = gettext.translation (APP_NAME, mo_location, languages = languages, fallback = True)


