import sys
import os
#import random
import time
from time import strftime
#import math
#import array
import string

import ConfigParser
import os, os.path

import data
import filter_data #filter
import records #record data























###########################################################################
## Load the configuration from the config file
###########################################################################
def LoadConfig():
    #get configuration
    global config
    if(data.debug==1): print "Configuration file:",  data.configfolder+data.ConfigFile
    config = ConfigParser.SafeConfigParser()
    try:
        config.read(data.configfolder+data.ConfigFile)
    except: #use default config
        print "Configuration file "+data.configfolder+data.ConfigFile + " not existing or not compatible"

    try:
        config.add_section('main')
    except:
        pass

    try:
        data.Sampling_interval = config.getint('main', 'sampling')
    except:
        config.set('main', 'sampling', str(data.Sampling_interval))

    try:
        data.Sample_smoothing = config.getint('main', 'sample_smoothing')
    except:
        config.set('main', 'sample_smoothing', str(data.Sample_smoothing))

    try:
        data.Value_smoothing = config.getint('main', 'value_smoothing')
    except:
        config.set('main', 'value_smoothing', str(data.Value_smoothing))

    try:
        data.Trigger = config.getint('main', 'Trigger')
    except:
        config.set('main', 'Trigger', str(data.Trigger))

    try:
        data.Derivation = config.getint('main', 'Derivation')
    except:
        config.set('main', 'Derivation', str(data.Derivation))

    try:
        data.Ysize = config.getint('main', 'Ysize')
    except:
        config.set('main', 'Ysize', str(data.Ysize))

    try:
        data.Xscale = config.getint('main', 'Xscale')
    except:
        config.set('main', 'Xscale', str(data.Xscale))

    try:
        data.Yscale = config.getint('main', 'Yscale')
    except:
        config.set('main', 'Yscale', str(data.Yscale))

    try:
        data.derivation_offset = config.getint('main', 'derivation_offset')
    except:
        config.set('main', 'derivation_offset', str(data.derivation_offset))

    try:
        data.FilterScale = config.getint('main', 'FilterScale')
    except:
        config.set('main', 'FilterScale', str(data.FilterScale))

    try:
        tmp=config.get('main', 'user')
        data.user = tmp.decode("utf-8")
    except:
        config.set('main', 'user', str(data.user.encode( "utf-8" )))

    try:
        data.LastRecord = config.get('main', 'LastRecord')
    except:
        config.set('main', 'LastRecord', str(data.LastRecord))

    try:
        tmp = config.get('main', 'OfflineMode')
        if(tmp=="True"): data.OfflineMode=True
        else: data.OfflineMode=False
    except:
        config.set('main', 'OfflineMode', str(data.OfflineMode))

    try:
        tmp = config.get('main', 'SilentProfile')
        if(tmp=="True"): data.SilentProfile=True
        else: data.SilentProfile=False
    except:
        config.set('main', 'SilentProfile', str(data.SilentProfile))

    try:
        data.DelayStartTime = config.getint('main', 'DelayStartTime')
    except:
        config.set('main', 'DelayStartTime', str(data.DelayStartTime))

    try:
        data.AlarmHour = config.getint('main', 'AlarmHour')
    except:
        config.set('main', 'AlarmHour', str(data.AlarmHour))

    try:
        data.AlarmMinute = config.getint('main', 'AlarmMinute')
    except:
        config.set('main', 'AlarmMinute', str(data.AlarmMinute))

    try:
        data.AlarmTimeWindow = config.getint('main', 'AlarmTimeWindow')
    except:
        config.set('main', 'AlarmTimeWindow', str(data.AlarmTimeWindow))

    try:
        tmp = config.get('main', 'StopAfterAlarm')
        if(tmp=="True"): data.StopAfterAlarm=True
        else: data.StopAfterAlarm=False
    except:
        config.set('main', 'StopAfterAlarm', str(data.StopAfterAlarm))

    print "Configuration successful loaded from "+data.ConfigFile

    return config









###########################################################################
## Write the configuration into the config file
###########################################################################
def WriteConfig():
        global config
        config.set('main', 'Trigger', str(data.Trigger))

        f=data.configfolder+data.ConfigFile
        if(data.debug==1): print "Save configuration ("+f+")"
        if (not os.path.exists(data.configfolder)):
            print "Create configuration folder: ",  data.configfolder
            os.mkdir(data.configfolder)
        try:
            data.configfile = open(f, 'w')
            config.write(data.configfile)
            print "Configuration saved"
        except:
            print "Failed to write configuration file!"







###########################################################################
##
###########################################################################
def Seconds2Tuple(secs):
    tuple=time.localtime(secs)
    return tuple



###########################################################################
##
###########################################################################
def Tuple2Seconds(Tuple):
    secs=int(time.mktime(Tuple))
    return secs



###########################################################################
##
###########################################################################
def Tuple2Index(Tuple):
    t0=records.StartTime_seconds
    t1=Tuple2Seconds(Tuple)
    tdiff=t1-t0
#    print records.StartTime_tuple,  Tuple
#    print "Tuple2Index:",  t0,  t1,  tdiff,  float(1000)/(records.Sampling_interval*records.Value_smoothing)
#    return Seconds2Index(tdiff)
    return int((tdiff-10)*1000/(records.Sampling_interval*records.Value_smoothing))+3



###########################################################################
##
###########################################################################
def Index2Tuple(Index):
    tdiff=int(Index*records.Sampling_interval*records.Value_smoothing/1000-3)+10
#    tdiff=Index2Seconds(Index)
    t=records.StartTime_seconds+tdiff
    return Seconds2Tuple(t)





############################################################################
## Function to measure used time in a function
############################################################################
#def Show_passed_time(text="",  reset=0):
#    if(data.debug==0): return
#    now=time.time()
#    if(reset==1): data.passed_time=now
#
#    t=1000*(now-data.passed_time)
#    t2=1000*(now-data.passed_time2)
#    print "### ",  str(int(t)), "ms, (",  str(int(t2)), "ms delta): ", text
#
#    data.passed_time2 = time.time()
