import sys
import os
import random
import time
from time import strftime
import math
import array
import string

import ConfigParser
import os, os.path

import data
import records #record data

#own functions
from functions_general import *

#own c cfunctions (for speed improvements)
try:
    from lib import mylib
except:
    pass #already handled in main.py


###########################################################################
## Read the sensor data x times and smoothen it
###########################################################################
def ReadAccSensor():    
    coords=[0, 0]    
    if(data.demo==False):        
        for i in range(data.Sample_smoothing):
            f = open("/sys/class/i2c-adapter/i2c-3/3-001d/coord", 'r' )
            coords_tmp = [int(w) for w in f.readline().split()]
            f.close()
            coords[0]=coords[0] + coords_tmp[0] #X
            coords[1]=coords[1] + coords_tmp[1] #Y
        coords[0]=coords[0] / data.Sample_smoothing
        coords[1]=coords[1] / data.Sample_smoothing
    else:
        coords[0]=int(random.uniform(-50,50))
        coords[1]=int(random.uniform(-50,50))
    return coords



###########################################################################
## Get the smoothened sensor data, smoothen it again and fill the data into the main data array
###########################################################################
def GetSensorData():    
    d=ReadAccSensor()
    data.arrDataTemp[0]=data.arrDataTemp[0]+d[0]
    data.arrDataTemp[1]=data.arrDataTemp[1]+d[1]

    data.sample_index=data.sample_index+1
    
    if(data.sample_index==data.Value_smoothing): #if is 10 runs over        
        data.sample_index=0
        data.Values_total=data.Values_total+1
        
        if(records.Index==records.MaxArrayDataLen-1): return 0 #Array full
        
        records.arrData[0][records.Index]=strftime("%H:%M:%S", time.localtime())
        records.arrData[1][records.Index]=data.arrDataTemp[0]/data.Value_smoothing
        records.arrData[2][records.Index]=data.arrDataTemp[1]/data.Value_smoothing
        
        records.Index=records.Index+1
        records.LastIndex=max(records.Index,  records.LastIndex)
        
        records.EndTime_seconds=Tuple2Seconds(records.StartTime_tuple)+records.Index*records.Sampling_interval*records.Value_smoothing/1000
        records.EndTime_tuple=Seconds2Tuple(records.EndTime_seconds)

        data.arrDataTemp[0]=0
        data.arrDataTemp[1]=0

        return 1 #added new values to arrData        
    else: return 0 #no new data added




###########################################################################
## 
###########################################################################
def GetFirstEntry():
    records.arrData[0][0]=strftime("%H:%M:%S", time.localtime())
    records.arrData[1][0]=0
    records.arrData[2][0]=0
    
    records.Index=1
    records.LastIndex=max(records.Index,  records.LastIndex)
        
        


###########################################################################
##  Process the data, generate movement indication
###########################################################################
def ProcessData(ProcessAll=False, ShowFiltered=False):  #DERIVATION (ABLEITUNG)
#    global ViewWindow
    if(data.debug==1): print "Process Data (Process whole array:", ProcessAll,  ")"
    data.Progress="Process data..."
    lastmovebeforegraph=0 
    if(ProcessAll==True): start=0 #process whole array
    else: start=records.Index-data.Derivation-1 #process only last (changed) records
    if(data.debug==1): print "Process entry", start+data.Derivation, "to", records.Index
    lastindexovertrigger=records.arrData[4][start]
    for i in range(start, records.Index-data.Derivation):     
        t=i*(records.Sampling_interval*records.Value_smoothing)/1000
        if(data.QuickMode==True or t>data.DelayStartTime):
            Xder=records.arrData[1][i+data.Derivation] - records.arrData[1][i] #X  in 50 sec - X now
            Yder=records.arrData[2][i+data.Derivation] - records.arrData[2][i]  #Y  in 50 sec - Y now
            XYder=abs(Xder)+abs(Yder) #summ of both absolute Derivations
        else: #During delayed phase, do not use data
            Xder=0
            Yder=0
            XYder=0
#        records.arrData[3][i]=min(XYder*data.Yscale,  data.Ysize-17) #cut off if higher than graph border
        records.arrData[3][i]=XYder
        records.arrData[4][i]=lastindexovertrigger
        if(records.arrData[3][i]>data.Trigger): #over trigger
            lastindexovertrigger=i





def FilterData():

###        mylib.sleep_filter()
##        if(data.debug==1): print "Filter array:"
##        if(data.debug==1): print data.arrFilter
##        l=len(data.arrFilter)
##        if(data.debug==1): print "Lenght:",  l
##        
        Xscale=data.arrXscale[data.Xscale]
##        
##        for i in range(0,  records.Index-data.Derivation,  Xscale): #loop arrData
##            value=records.arrData[3][i]
##            if((i%500)==0): 
##                Progress="Filter data ("+ str(i*100/(records.Index-data.Derivation)) +"%)..."
#        self.ui.lblStatus.setText("Apply filter")     
#        app.processEvents() #force ui update
##            for p in range(0,  l-1): #loop arrFilter
##                records.arrData[6][i+p-data.FilterShift] = records.arrData[6][i+p-data.FilterShift] + value*data.arrFilter[p]
##
##        for i in range(0,  records.Index,  Xscale): #scalling
##            records.arrData[6][i]  = records.arrData[6][i] / data.FilterScale*Xscale
##            if(records.arrData[6][i] >data.Ysize):
##                records.arrData[6][i]  = int(random.uniform(data.Ysize-9,data.Ysize-15))
        
#        a=mylib.sleep_filter()
#        print a

#        print "##### mylib is compiled:", mylib.IsCompiled()

        arrSend=[0]*(records.Index+len(data.arrFilter))
        for i in range(0,  records.Index-data.Derivation): #copy array
            arrSend[i]=records.arrData[3][i]
        
#        for i in range(0,  50): print arrSend[i],  records.arrData[3][i]
        
        arrRet=mylib.sleep_filter(arrSend, records.Index-data.Derivation, data.arrFilter, data.FilterShift)
#        print arrRet
        
        for i in range(0,  records.Index-data.Derivation): #copy array and scale
            records.arrData[6][i]  = arrRet[i] / data.FilterScale
            if(records.arrData[6][i] > data.Ysize-7):
                records.arrData[6][i]  = data.Ysize-7 #-int(random.uniform(1, 2))
            elif(records.arrData[6][i] < 13): records.arrData[6][i] =13







###########################################################################
## Show (refreshs) the graph.
## the first parameter indcates on which window it will be drawn
###########################################################################
def DrawGraph(self,  QtGui, ShowFiltered=False):
    try:
        if(data.debug==1): print "Draw Graph into bitmap"
        
        Xscale=data.arrXscale[data.Xscale]
        decade=360/Xscale
        
    #    data.GraphStart=0
        
    #    GraphSize=max(data.GraphBitMapLen+2, 785)

    #        print "-----------------------------------"
    #        print "Xscale:",  Xscale
    #        print "Current index:",  records.Index
    #        print "LastIndex:",  records.LastIndex
    #        print "data.GraphBitMapLen (WindowSize):",  data.data.GraphBitMapLen
    #        print "GraphStart:",  data.GraphStart
    #        print "GraphEnd:",  data.GraphEnd
    #        print "The area between index",data.GraphStart , "and",data.GraphEnd , "will be shown"
    #        print "Scrollbar:",  ScrollbarStartPercent, "...", ScrollbarEndPercent, "%"
        
    #        print "Shown graph is from index",  data.GraphStart,  "to",  data.GraphStart+data.GraphBitMapLen
            
    #    PrintRecordData()

    #    print "data.QuickMode:",  data.QuickMode
            
    #    data.ChangesInGraph=False
        paint = QtGui.QPainter()     
        paint.begin(self)

        paint.setFont(QtGui.QFont('Decorative', 12))
        
        #clear whole pitmap (remove old data)
        paint.setPen(QtGui.QColor(data.GraphBackground))
        paint.setBrush(QtGui.QColor(data.GraphBackground))    
        paint.drawRect(0,0,records.MaxArrayDataLen+10,data.GraphBitMapHeight)   
        
        
    #    #show Graph border 
    ##    paint.setPen(QtGui.QColor("white"))
    ##    paint.setBrush(QtGui.QColor("#101010"))    
    ###    paint.drawRect(0,0,781,data.Ysize)    
    ##    paint.drawRect(0,0,data.GraphBitMapLen,data.Ysize)   

        #Stop if data is not ok
        if(records.statusID!="OK"):#Show useful infos                 
            paint.setFont(QtGui.QFont('Decorative', 20))
            paint.setPen(QtGui.QColor("White"))  
            paint.drawText(100, data.Ysize/2+5, records.status) #show status information
            return
        
        
    #    GraphStart_tuple=Index2Tuple(data.GraphStart)
        GraphStart_tuple=Index2Tuple(0) #time of first record entry
    #    if(data.debug==1): print "data.GraphStart",  data.GraphStart,  GraphStart_tuple
        h=int(strftime("%H", GraphStart_tuple))
        m=int(strftime("%M", GraphStart_tuple))
        s=int(strftime("%S", GraphStart_tuple))
    #    print h,  m,  s
        
        secondsincefullhour=m*60+s
        GraphStart_seconds=Tuple2Seconds(GraphStart_tuple)
        LastFullHour_sec=GraphStart_seconds-secondsincefullhour
        LastFullHour_tuple=Seconds2Tuple(LastFullHour_sec)
        
        h0=int(strftime("%H", LastFullHour_tuple))
        m0=0 #int(strftime("%M", LastFullHour_tuple))
        s0=0# int(strftime("%S", LastFullHour_tuple))
        
            
#        print GraphStart_seconds,  LastFullHour_sec,  secondsincefullhour
#        print GraphStart_tuple,  LastFullHour_tuple
#        print h0,  m0,  s0
        
        LastFullHour_index=Tuple2Index(LastFullHour_tuple)

        GraphStart_index=Tuple2Index(GraphStart_tuple) 
    #    print "Indexes:",  GraphStart_index,  "(",  data.GraphStart, ")",  LastFullHour_index

        OffsetToLastFullHour=-1*(GraphStart_index - LastFullHour_index)/Xscale 
        OffsetToLastFullHour=OffsetToLastFullHour- data.Derivation/Xscale  #Derivation takes 5 indices, so visualisation is delayed!
        
    #    print "OffsetToLastFullHour:",  OffsetToLastFullHour,  "GraphStart_index:",  GraphStart_index,  "LastFullHour_index:",  LastFullHour_index
        
    #    print "Last data is on:",  Index2Tuple(records.Index)
        
        
        
        
        
        
        
        #DRAW main scaling lines + text        
        paint.setPen(QtGui.QColor("white"))
        h=h0-2
        if(data.QuickMode==False): #normal mode
    #        print "OffsetToLastFullHour:",  OffsetToLastFullHour
            if(data.Xscale==0): #max zoom
    #            for i in range(OffsetToLastFullHour-decade, 781+decade,  decade): #full hours
    #            for i in range(0, data.GraphBitMapLen,  decade): #full hours
                for i in range(OffsetToLastFullHour-decade, max(data.GraphBitMapLen, records.Index)+decade,  decade): #full hours
#                    h=(h0+int(i/decade)+1) % 24
                    h=(h+1) % 24
    #                print i
                    paint.drawLine(i, data.Ysize, i, data.Ysize+10) 
                    paint.setFont(QtGui.QFont('Decorative', 18))
                    paint.drawText(i-25, data.Ysize+32, str(h)+":00")
    #                #show dashed line
    #                paint.drawLine(i, 0, i, data.Ysize) 
                    
                    paint.setFont(QtGui.QFont('Decorative', 12))
                    for k in range(1, 6): #hour + k * 10 minutes
                        x=i+k*decade/6
    #                    print " ", x,  str(h)+":"+str(10*k)
                        paint.drawLine(x, data.Ysize, x, data.Ysize+10)  
                        paint.drawText(x-20, data.Ysize+26, str(h)+":"+str(10*k))
                    for m in range(1, 30): #hour + m * 2 minutes
                        x2=i+m*decade/30
    #                    print "  ",  x2
                        paint.drawLine(x2, data.Ysize, x2, data.Ysize+4) 

            elif(data.Xscale==1 or data.Xscale==2): #mid + min zoom
    #            for i in range(OffsetToLastFullHour-decade, 781+decade,  decade): #full hours
                for i in range(OffsetToLastFullHour-decade, max(data.GraphBitMapLen, records.Index)+decade,  decade): #full hours
#                    h=(h0+int(i/decade)+1) % 24
                    h=(h+1) % 24
    #                print i
                    paint.drawLine(i, data.Ysize, i, data.Ysize+10) 
                    paint.drawText(i-15, data.Ysize+30, str(h)+":00")
                    
    #                #show dashed line
    #                paint.setPen(QtGui.QColor("grey"))
    #                paint.drawLine(i, 0, i, data.Ysize) 
                    
                    for k in range(1, 6): #hour + k * 10 minutes
                        x=i+k*decade/6
    #                    print " ", x,  str(h)+":"+str(10*k)
                        paint.drawLine(x, data.Ysize, x, data.Ysize+4)  

        else: #quick mode, do not show X scale as it is not calibrated
    #        paint.drawText(200, data.Ysize+20, "Test Mode, no time scale available")
    #        paint.drawText((max(data.GraphBitMapLen, records.Index)-500)/Xscale, data.Ysize+20, "Test Mode, no time scale available")
            pass



        #DRAW time bars
        State1Color=QtGui.QColor(0, 200, 0)
        State1ColorDark=QtGui.QColor(0, 50, 0)
        State2Color=QtGui.QColor(0, 100, 0)
        State2ColorDark=QtGui.QColor(0, 20, 0)
        State3Color=QtGui.QColor(174, 57, 16)
        State3ColorDark=QtGui.QColor(88, 29, 8)
        State4Color=QtGui.QColor(134, 0, 0)
        State4ColorDark=QtGui.QColor(76, 0, 0)
        
        gradient = QtGui.QLinearGradient(0, data.Ysize-11, 0, data.Ysize-1)
        
        start=GraphStart_index % 6
        lastmoveovertrigger=start
    #    for p in range(start,  records.Index-data.Derivation):
        for p in range(0,  records.Index-data.Derivation):
            if(records.arrData[3][p]>data.Trigger or p>records.Index-data.Derivation-2):
                x0=(lastmoveovertrigger-GraphStart_index)/Xscale
                x1=(p-GraphStart_index)/Xscale
    #            print lastmoveovertrigger,  p,  "(", x0,  x1 , ")"
    #            if(x1-Xscale<=x0):
    #                print "-"
    #                continue
                lastmoveovertrigger=p

                if(x0<x1): 
                    t=(x1-x0)*Xscale/6        
    #                print x0,  x1
#                    if(t>30): color=State1Color #green for 30 minutes and longer
#                    elif(t>15): color=State2Color #dark green for 15 .. 29 minutes
#                    elif(t>7): color=State3Color #orange for 7 .. 14 minutes
#                    else: color=State4Color #dark red for under 7 minutes
                    if(t>30): #green for 30 minutes and longer
                        gradient.setColorAt(0, State1Color)
                        gradient.setColorAt(0.5, State1ColorDark)
                        gradient.setColorAt(1, State1Color)
                        paint.setPen(QtGui.QColor(State1Color))
                    elif(t>15): #dark green for 15 .. 29 minutes
                        gradient.setColorAt(0, State2Color)
                        gradient.setColorAt(0.5, State2ColorDark)
                        gradient.setColorAt(1, State2Color)
                        paint.setPen(QtGui.QColor(State2Color))
                    elif(t>7): #orange for 7 .. 14 minutes
                        gradient.setColorAt(0, State3Color)
                        gradient.setColorAt(0.5, State3ColorDark)
                        gradient.setColorAt(1, State3Color)
                        paint.setPen(QtGui.QColor(State3Color))
                    else:  #dark red for under 7 minutes
                        gradient.setColorAt(0, State4Color)
                        gradient.setColorAt(0.5, State4ColorDark)
                        gradient.setColorAt(1, State4Color)
                        paint.setPen(QtGui.QColor(State4Color))
                    paint.setBrush(QtGui.QBrush(gradient))
#                    paint.setBrush(QtGui.QColor(color))
#                    paint.setPen(QtGui.QColor(data.GraphBackground))
                    paint.drawRect(x0+1, data.Ysize-11, x1-x0-1, 9)                     
                    paint.setPen(QtGui.QColor(data.MovementBarColor))




        #DRAW graph
        paint.setPen(QtGui.QColor(data.MovementBarColor))           
        peak=0
    #    for p in range(GraphStart_index,  records.Index-data.Derivation,  Xscale):
        for p in range(0,  records.Index-data.Derivation,  Xscale):
            i=p-GraphStart_index
    #        if(i>779*Xscale): break
            #when Xscale is small, we have to merge several records into 1 pixel.
            #Too not miss any movement, we use the biggest movement of the merged records:
            peak=0            
            for j in range(0, Xscale): 
                if(records.arrData[3][p+j]>peak): peak=records.arrData[3][p+j]
            x=i/Xscale
    #        x=i/Xscale+1
    #        paint.drawLine(x, data.Ysize-peak-1-15, x, data.Ysize-1-15)  #draw yellow movement bar
            h=min(peak*data.Yscale/2,  data.Ysize-17) #cut off if higher than graph border
            paint.drawLine(x, data.Ysize-h-1-15, x, data.Ysize-1-15)  #draw yellow movement bar
            
            if(peak>data.Trigger):
                paint.setPen(QtGui.QColor(data.GraphBackground))
                paint.drawLine(x, data.Ysize-11, x, data.Ysize-1)  #draw yellow movement bar
                paint.setPen(QtGui.QColor(data.MovementBarColor))
    #            print "Peak:", i,  x






        #DRAW Filtered graph  
        if(ShowFiltered==True):  #only show in view window, not during recording
            pen=QtGui.QPen()    
            
            #filling
            pen.setColor(QtGui.QColor(19, 54, 255, 150))
            pen.setWidth(1)
            paint.setPen(pen)            
            for p in range(0,  records.Index-data.Derivation-Xscale,  Xscale):
                i=p-GraphStart_index
                x=i/Xscale+1
                paint.drawLine(x, data.Ysize-16, x, data.Ysize-records.arrData[6][p+Xscale]-5)  

            #outline
            pen.setColor(QtGui.QColor(19, 54, 255))
            pen.setWidth(3)
            paint.setPen(pen)            
            for p in range(0,  records.Index-data.Derivation-Xscale,  Xscale):
                i=p-GraphStart_index
                x=i/Xscale+1
                paint.drawLine(x, data.Ysize-records.arrData[6][p]-5, x+1, data.Ysize-records.arrData[6][p+Xscale]-5)  








        
        
       #ALARM VISUALISATION
        if(records.AlarmIsSet==True): #alarm time window is set, show it            
            paint.setBrush(QtGui.QColor(255, 128, 0, 200))
            paint.setPen(QtGui.QColor(255, 128, 0, 200))  
            x0=Tuple2Index(records.AlarmTimeWindowStart_tuple)-data.Derivation*Xscale
            x1=Tuple2Index(records.AlarmTimeWindowEnd_tuple)-data.Derivation*Xscale
    #        x0=Tuple2Index(records.AlarmTimeWindowStart_tuple)-data.Derivation
    #        x1=Tuple2Index(records.AlarmTimeWindowEnd_tuple)-data.Derivation
            x00=(x0-GraphStart_index)/Xscale
            x10=(x1-GraphStart_index)/Xscale
    #        if(x00>0 or x10<780): #visible in screen
    #            x00=max(x00,  1) #limit drawn line to border
    #            x10=min(x10,  780) #limit drawn line to border
    #            if(x00<x10): 
    #        print  x1,   x10
    #        print Tuple2Index((2010, 8, 15, 20, 0, 0, 6, 227, 0)),  (Tuple2Index((2010, 8, 15, 20, 0, 0, 6, 227, 0)) -GraphStart_index)/Xscale
    #        print ""
            paint.drawRect(x00,  8,  x10-x00,  2) #Time Window 
    #            x11=(x1+3-GraphStart_index)/Xscale
    #            if(x11>1 and x11<779):        
            paint.drawRect(x10,  4,  1,  10)  #Last Alarm opportunity
                    
                    
                    
            if(data.AlarmIsActive==True or data.run==False): #only show alarm if alarm occured or in view mode
    #            if(records.Index>=Tuple2Index(records.AlarmTimeWindowEnd_tuple)): #only show alarm dot when alarm really came
                if(records.AlarmTime_seconds!=-1):
#                    print "AlarmTimeWindowEnd:",  records.AlarmTimeWindowEnd_seconds,  "AlarmTime:",  records.AlarmTime_seconds,  "records.EndTime_seconds:",records.EndTime_seconds  
    #                EndTime_seconds=Tuple2Seconds(records.StartTime_tuple)+records.Index*records.Sampling_interval*records.Value_smoothing/1000
                    if(records.EndTime_seconds>=records.AlarmTime_seconds-60): #alarm got set off during recording (-60 is workaround)
#                        paint.setBrush(QtGui.QColor(data.AlarmColor))
                        paint.setPen(QtGui.QColor(178, 0, 0))  
                        if(records.AlarmTimeWindowEnd_seconds<=records.AlarmTime_seconds):
#                            print "Alarm due end of alarm time window"
                            a0=Tuple2Index(records.AlarmTime_tuple)-data.Derivation*Xscale
                        else:
#                            print "alarm due movement"
                            a0=Tuple2Index(records.AlarmTime_tuple)-data.Derivation
                        a00=(a0-GraphStart_index)/Xscale
                        



#                        gradient = QtGui.QRadialGradient(200,  100,  5)
                        gradient = QtGui.QRadialGradient(a00,  20,  3)
                        gradient.setColorAt(0, QtGui.QColor(255, 152, 152))
                        gradient.setColorAt(1, QtGui.QColor(255, 0, 0))
                        paint.setBrush(QtGui.QBrush(gradient))
                        
                        
                        
                        
                        
#                        paint.drawEllipse(100, 0, 200, 200) 
                        paint.drawEllipse(a00-5, 15, 10, 10)     
                        
            #            print "AlarmTimeWindow:",  x1,  x10,  "Alarm:",  a0,  a00
#                    else:
#                        print "Alarm set, but never occured"




        #DRAW Trigger line
        if(records.statusID=="OK"):       
            if(data.run==False):  #show trigger level stored in record
                paint.setPen(QtGui.QColor("gray"))
                y=(data.Ysize-(records.Trigger*data.Yscale/2))-2
                paint.drawLine(1, y-15, data.GraphBitMapLen-2, y-15)  #Trigger line
                paint.drawText(data.GraphBitMapLen-25, y-17, str(records.Trigger)) #Trigger level
    #            paint.drawText(5, 15, str(data.Yscale)) #Y scale
            paint.setPen(QtGui.QColor(255,  255,  255, 200))
            y=(data.Ysize-(data.Trigger*data.Yscale/2))-2
            paint.drawLine(1, y-15, data.GraphBitMapLen-2, y-15)  #Trigger line
            paint.drawText(data.GraphBitMapLen-25, y-17, str(data.Trigger)) #Trigger level
    #        paint.drawText(5, 15, str(data.Yscale)) #Y scale
           
           
           
        #Draw border around graph
        paint.setPen(QtGui.QColor("white"))
#        paint.drawLine(0, 0, 0, data.Ysize)  #left side    
#        paint.drawLine(data.GraphBitMapLen-1, 0, data.GraphBitMapLen-1, data.Ysize)  #right side
#        paint.drawLine(0, 0, data.GraphBitMapLen-1, 0)  #top
#        paint.drawLine(0, data.Ysize, data.GraphBitMapLen-1, data.Ysize)  #bottom

    #    #show Graph border 
        paint.setPen(QtGui.QColor("white"))
        paint.setBrush(QtGui.QColor(10, 10, 10, 200))   
        
        gradient = QtGui.QLinearGradient(0, 0, 0, data.Ysize)
        gradient.setColorAt(0, QtGui.QColor(255, 255, 255, 50)) #top
        gradient.setColorAt(0.5, QtGui.QColor(255, 255, 255, 0)) #bottom
        paint.setBrush(QtGui.QBrush(gradient)) 
        
        
        paint.drawRect(0,0,data.GraphBitMapLen-1,data.Ysize)   


           
        #beep in test mode
        if(peak>data.Trigger): #if last value is over peak
            if(data.QuickMode==True and (records.Index-data.Derivation)>data.last_beep): #quick mode for testing but only once per move
                if(data.debug==1): print "Beep"
                data.last_beep=records.Index
                if(data.demo==False): #make beep for testing movement                    
                    b = os.popen("pacat --channels=2 /usr/share/sounds/ui-default_beep.wav")
                    b.close()

    except:
        print "Error while drawing the graph"
        print sys.exc_info() 

    paint.end()







###########################################################################
## 
###########################################################################  
def DrawStatistic(self,  QtGui, QtCore):
#    try:
#        if(daDta.debug==1): print "Draw Graph into bitmap"

    paint = QtGui.QPainter()
    paint.begin(self)
    
    #clear whole pitmap (remove old data)
    paint.setPen(QtGui.QColor(data.GraphBackground))
#    paint.setBrush(QtGui.QColor("red"))   
#    paint.drawRect(0, 0, data.StatisticsBitMapLen/2,  data.StatisticsBitMapHeight/2)  
    
    paint.setBrush(QtGui.QColor(data.GraphBackground))   
#    paint.setBrush(QtGui.QColor(255, 255, 255, 50))   
#    paint.setBrush(QtCore.Qt.NoBrush)    
    paint.drawRect(0, 0, data.StatisticsBitMapLen,  data.StatisticsBitMapHeight)   
    
#    paint.

#    linearGrad = QtGui.QLinearGradient(10, 10, 20, 20)
#    linearGrad.setColorAt(0, QtGui.QColor("red"))
#    linearGrad.setColorAt(1, QtGui.QColor("green"))




    








#    paint.setBrush(QtGui.QGradient())

    paint.setPen(QtGui.QColor(data.GraphBackground))
    State1Color=QtGui.QColor(0, 200, 0)
    State1ColorDark=QtGui.QColor(0, 50, 0)
    State2Color=QtGui.QColor(0, 100, 0)
    State2ColorDark=QtGui.QColor(0, 20, 0)
    State3Color=QtGui.QColor(174, 57, 16)
    State3ColorDark=QtGui.QColor(88, 29, 8)
    State4Color=QtGui.QColor(134, 0, 0)
    State4ColorDark=QtGui.QColor(76, 0, 0)


    if(records.arrStatData[3][3]>0):
        a=QtGui.QColor(134, 0, 0)
        gradient = QtGui.QLinearGradient(0, 5, 0, 15)
        gradient.setColorAt(0, State4Color)
        gradient.setColorAt(0.5, State4ColorDark)
        gradient.setColorAt(1, State4Color)
        paint.setBrush(QtGui.QBrush(gradient))
#        paint.setPen(QtGui.QColor(State4Color))
        paint.drawRect(0, 5, records.arrStatData[3][3], 10)   
    if(records.arrStatData[2][3]>0):
        gradient = QtGui.QLinearGradient(0, 20, 0, 30)
        gradient.setColorAt(0, State3Color)
        gradient.setColorAt(0.5, State3ColorDark)
        gradient.setColorAt(1, State3Color)
        paint.setBrush(QtGui.QBrush(gradient)) 
#        paint.setPen(QtGui.QColor(State3Color))
        paint.drawRect(0, 20, records.arrStatData[2][3], 10)   
    if(records.arrStatData[1][3]>0):  
        gradient = QtGui.QLinearGradient(0, 35, 0, 45)
        gradient.setColorAt(0, State2Color)
        gradient.setColorAt(0.5, State2ColorDark)
        gradient.setColorAt(1, State2Color)
        paint.setBrush(QtGui.QBrush(gradient)) 
#        paint.setPen(QtGui.QColor(State2Color))
        paint.drawRect(0, 35, records.arrStatData[1][3], 10)   
    if(records.arrStatData[0][3]>0):
        gradient = QtGui.QLinearGradient(0, 50, 0, 60)
        gradient.setColorAt(0, State1Color)
        gradient.setColorAt(0.5, State1ColorDark)
        gradient.setColorAt(1, State1Color)
        paint.setBrush(QtGui.QBrush(gradient)) 
#        paint.setPen(QtGui.QColor(State1Color))
        paint.drawRect(0, 50, records.arrStatData[0][3], 10)   
    
    paint.end()


###########################################################################
## 
###########################################################################  
def GenerateStatisticData():  
    #Sleep phase 1 = 30 minutes and longer
    #Sleep phase 2 = 15 .. 29 minutes
    #Sleep phase 3 = 7 .. 14 minutes
    #Sleep phase 4 = under 7 minutes
    
    for i in range(0, 4): #clear array
        for j in range(0,  4): records.arrStatData[j][i]=0        
    
#    if(data.debug==1): print "Statistic data:",  records.arrStatData
    
    Xscale=data.arrXscale[data.Xscale]
#    EndTime_seconds=Tuple2Seconds(records.StartTime_tuple)+records.Index*records.Sampling_interval*records.Value_smoothing/1000

    lastindexovertrigger=0
#    lastdrawpointx=0
#    lastdrawpointy=0
    for i in range(0, records.Index-data.Derivation):     
        if(records.arrData[3][i]>data.Trigger or i==records.Index-data.Derivation-1): #over trigger
            diff= i - lastindexovertrigger
            t=diff*records.Sampling_interval*records.Value_smoothing/1000
#            print i,  t
#            print i,  records.arrData[0][i], t/60, "min"
#            tm=t/60 #in minutes
            if(t>1800): #30 minutes and longer
#                l="=========="
#                y=60
                records.arrStatData[0][0]=records.arrStatData[0][0]+t #Accumulated time for phase 1
                records.arrStatData[0][1]=records.arrStatData[0][1]+1 #Amount of times/phase 1
                if(records.arrStatData[0][2]<t): records.arrStatData[0][2]=t #Max time in phase 1
            elif(t>900): #15 .. 29 minutes
#                l="====="
#                y=40
                records.arrStatData[1][0]=records.arrStatData[1][0]+t #Accumulated time for phase 2
                records.arrStatData[1][1]=records.arrStatData[1][1]+1#Amount of times/phase 2
                if(records.arrStatData[1][2]<t): records.arrStatData[1][2]=t #Max time in phase 2
            elif(t>420): #7 .. 14 minutes
#                l="=="
#                y=20
                records.arrStatData[2][0]=records.arrStatData[2][0]+t #Accumulated time for phase 3
                records.arrStatData[2][1]=records.arrStatData[2][1]+1#Amount of times/phase 3
                if(records.arrStatData[2][2]<t): records.arrStatData[2][2]=t #Max time in phase 3
#            else: #under 7 minutes
#                l=""
#                y=10
#                records.arrStatData[3][0]=records.arrStatData[3][0]+t #Accumulated time for phase 4
#                records.arrStatData[3][1]=records.arrStatData[3][1]+1#Amount of times/phase 4
#                if(records.arrStatData[3][2]<t): records.arrStatData[3][2]=t #Max time in phase 4

            
            lastindexovertrigger=i
            
            
#    print i,  lastindexovertrigger
    
    
#    if(lastindexovertrigger==0): #no movement over triger level found => only one bar
#        t=records.Index*records.Sampling_interval*records.Value_smoothing/1000
##        print "t:",  t
#        if(t>1800): #30 minutes and longer
#            records.arrStatData[0][0]=t #Accumulated time for phase 1
#            records.arrStatData[0][1]=1 #Amount of times/phase 1
#            records.arrStatData[0][2]=t #Max time in phase 1
#        elif(t>900): #15 .. 29 minutes
#            records.arrStatData[1][0]=t #Accumulated time for phase 2
#            records.arrStatData[1][1]=1 #Amount of times/phase 2
#            records.arrStatData[1][2]=t #Max time in phase 2    
#        elif(t>420): #7 .. 14 minutes
#            records.arrStatData[2][0]=t #Accumulated time for phase 3
#            records.arrStatData[2][1]=1 #Amount of times/phase 3
#            records.arrStatData[2][2]=t #Max time in phase 3            

    t_total=(records.EndTime_seconds-records.StartTime_seconds)
#    print records.EndTime_seconds,  records.StartTime_seconds,  t_total
    if(t_total==0):  t_total=1 #division by zerro prevention
    records.arrStatData[0][3]=records.arrStatData[0][0]*100/t_total
    records.arrStatData[1][3]=records.arrStatData[1][0]*100/t_total
    records.arrStatData[2][3]=records.arrStatData[2][0]*100/t_total
    records.arrStatData[3][3]=100-records.arrStatData[0][3]-records.arrStatData[1][3]-records.arrStatData[2][3]
    
    records.arrStatData[3][0]=t_total-records.arrStatData[0][0]-records.arrStatData[1][0]-records.arrStatData[2][0]
            
            
    
    if(data.debug==1): print "Statistic data:",  records.arrStatData
    
#    t_total=(records.EndTime_seconds-records.StartTime_seconds)/60
#    if(t_total==0):  t_total=1
#    pa=records.arrStatData[0][0]*100/t_total
#    pb=records.arrStatData[1][0]*100/t_total
#    pc=records.arrStatData[2][0]*100/t_total
#    pl=100-pa-pb-pc
##    txt="You spent "+str(records.arrStatData[0][1])+" times in a sleep phase with more than 30 minutes without sleeping, the longest of it for "+str(records.arrStatData[0][2])+" minutes"
#    txt="State a (>30 minutes without movement): "+str(records.arrStatData[0][1])+"x, longest: "+str(records.arrStatData[0][2])+" minutes, total: "+str(records.arrStatData[0][0])+" minutes ("+str(pa)+"%)"
#    txt=txt+"\n"+"State b (>15 minutes without movement): "+str(records.arrStatData[1][1])+"x, longest: "+str(records.arrStatData[1][2])+" minutes, total: "+str(records.arrStatData[1][0])+" minutes ("+str(pb)+"%)"
#    txt=txt+"\n"+"State c (>7 minutes without movement): "+str(records.arrStatData[2][1])+"x, longest: "+str(records.arrStatData[2][2])+" minutes, total: "+str(records.arrStatData[2][0])+" minutes ("+str(pc)+"%)"
#    txt=txt+"\n"+"Time with a lot of moving: "+str(t_total*pl/100)+" minutes ("+str(pl)+"%)"
#    print txt




###########################################################################
## 
###########################################################################
def InitRecord():
    records.Index=0    
    records.LastIndex=0
    records.StartTime_tuple=time.localtime()
    records.StartTime_seconds=Tuple2Seconds(records.StartTime_tuple)    
    records.EndTime_tuple=records.StartTime_tuple
    records.EndTime_seconds=records.StartTime_seconds
    records.AlarmTime_tuple=-1
    records.AlarmTime_seconds=-1
    records.AlarmTimeWindowStart_tuple=-1
    records.AlarmTimeWindowStart_seconds=-1
    records.AlarmTimeWindowEnd_tuple=-1
    records.AlarmTimeWindowEnd_seconds=-1
    records.AlarmTimeWindow_minutes=-1
    records.AlarmIsSet=False
    records.Note=""
    records.Sampling_interval=-1
    records.Sample_smoothing=-1
    records.Value_smoothing=-1
    records.Trigger=-1
    records.status=""
    records.statusID=""
    
    for i in range(0, records.MaxArrayDataLen-1): #clear data of old records
        for j in range(0,  4): 
            records.arrData[j][i]=0
        records.arrData[6][i]=0
        records.arrData[5][i]=""
    
    print "Reset/cleared all record data"
    
    
    
    
    
    
    
    



###########################################################################
## 
## Only used for debugging
###########################################################################
def PrintRecordData(ShowArray=True):
    print "###################### RECORD DATA #######################"
    print "Index:",  records.Index    
    print "LastIndex:",  records.LastIndex
    print "StartTime_tuple:",  records.StartTime_tuple
    print "StartTime_seconds:",  records.StartTime_seconds
    print "EndTime_tuple:",  records.EndTime_tuple
    print "EndTime_seconds:",  records.EndTime_seconds
    print "AlarmTime_tuple:",  records.AlarmTime_tuple
    print "AlarmTime_seconds:",  records.AlarmTime_seconds
    print "AlarmTimeWindowStart_tuple:",  records.AlarmTimeWindowStart_tuple
    print "AlarmTimeWindowStart_seconds:",  records.AlarmTimeWindowStart_seconds
    print "AlarmTimeWindowEnd_tuple:",  records.AlarmTimeWindowEnd_tuple
    print "AlarmTimeWindowEnd_seconds",  records.AlarmTimeWindowEnd_seconds
    print "AlarmTimeWindow_minutes:",  records.AlarmTimeWindow_minutes
    print "AlarmIsSet:",  records.AlarmIsSet
    print "Note:",  records.Note
    print "Sampling_interval:",  records.Sampling_interval
    print "Sample_smoothing:",  records.Sample_smoothing
    print "Value_smoothing:",  records.Value_smoothing
    print "Trigger:",  records.Trigger
    print "Status:",  records.statusID,  records.status
    
    if(ShowArray==True):
        for i in range(0, records.Index): #print data of  records
            print records.arrData[0][i],  records.arrData[1][i],  records.arrData[2][i],  records.arrData[3][i],  records.arrData[4][i],  records.arrData[5][i]

    print "##########################################################"
    


    
