#!/usr/bin/env python
###########################################################################
# Name: 	         SleepAnalyser
# Description:	 Analyses your movement during your sleep
# Copyright:     George Ruinelli, george@ruinelli.ch
# Last change:  (See file "version")
# Licence:         GPL
###########################################################################


import sys
import random
import time
from time import strftime
import math
import array
import string

from PyQt4.QtCore import * 
from PyQt4.QtGui import * 

import ConfigParser
import os, os.path



import data #own data
from myFunctions import * #Own functions
from myFunctions2 import * #Own functions

#GUIs
from Ui_StartWindow import *
from Ui_RecordWindow import *
from Ui_ViewWindow import *
from Ui_ConfigWindow import *
from Ui_DateWindow import *
from Ui_AlarmTimeWindow import *




  
###########################################################################
# Main function
###########################################################################
def main():
    global app,  StartWindow,  RecordWindow,  ViewWindow ,  ConfigWindow,  DateWindow,  AlarmTimeWindow
    global config
    global RecordWindowGraph
   
   
   
###############Usefull Time operations ###################################
##    t_tuple=time.localtime()
##    print t_touple
##    t_tuple_formated=strftime("%H:%M:%S", t_tuple)
##    print t_tuple_formated
##    t_sec=time.mktime(t_tuple)
##    print t_sec
##    t_sec=t_sec+3600+600 #add 1 hour + 5 minute
##    t_back_to_tuple=time.localtime(t_sec)
##    print t_back_to_tuple
###############T ime operations ###################################
   
   
   
   
    try:
        if(sys.argv[1]=="debug"): 
            print "Enable Debug mode"
            data.debug=1
    except:
        data.debug=0

    #if not on the N900, a acceleration sensor has to be simulated
    if(os.path.exists("/sys/class/i2c-adapter/i2c-3/3-001d/coord")): data.demo=0	#runs on real N900 hardware
    else: data.demo=1	#runs on other hardware/OS


    if(data.demo==1):
        print "Runs not on a N900 => Use randomizer for acceleration sensor data"
        data.configfolder=data.devconfigfolder
        data.logfolder=data.devlogfolder
    else: data.logfolder=data.defaultlogfolder

    app = QApplication(sys.argv)
    
    config=LoadConfig()
    
    if(data.Ysize==120): #workaround for wrong defaults
        data.Ysize=121
        data.Yscale=1
        data.trigger=30  
        config.set('main', 'Ysize', str(data.Ysize))      
        config.set('main', 'Yscale', str(data.Yscale))      
#        config.set('main', 'trigger', str(data.trigger))   
        print "changed default parameters for Yscale and Ysize"
    
    
    data.app_path=os.path.dirname(__file__)
    if(data.app_path==""): data.app_path="./"
    else: data.app_path=data.app_path+"/"
    
    StartWindow = frmStartWindow()    
    StartWindow.show()    
    StartWindow.UpdateScreenStart()
    
    # Create subwindows
    RecordWindow = frmRecordWindow(StartWindow)
    ConfigWindow = frmConfigWindow(StartWindow)
    ViewWindow = frmViewWindow(StartWindow)
    DateWindow = frmDateWindow(ViewWindow)
    AlarmTimeWindow = frmAlarmTimeWindow(StartWindow)
    
    # Hide SubWindows at first
    RecordWindow.hide()
    ViewWindow.hide()
    ConfigWindow.hide()
    AlarmTimeWindow.hide()
    DateWindow.hide()
    
    
    #get user name for in log files
    if(data.user==""):
        EditUserName()

    Show_passed_time("Application fully loaded", 1)
    sys.exit(app.exec_())




def EditUserName():
    text = QInputDialog.getText(None, "SleepAnalyser", "Please enter your name.\n"+ \
                                                                                             "It will be used in the records file, this makes it easier\n" + \
                                                                                             "when you want to share your sleep pattern with others.", 0,  data.user)
    if(text != ""):
        data.user=text[0]
        config.set('main', 'user', str(data.user))    
    else:
        pass
    print "User name:",  data.user


###########################################################################
#  Gets called every second,
###########################################################################
def TimerLoop(): #(interval: sampling*sample_smoothing*value_smoothing)
    global RecordWindowGraph    
#    Show_passed_time("TimerLoop start")
    r=GetSensorData()     
    if(r==1): #new data got added to array
#        print "Got SensorData"
        
        ProcessData()      
     
        r=ProcessAlarm()
#        if(r==1): #activated Alarm
#            WriteIntoLogFile()
#            StopMeasurement()
#            return
            
        WriteIntoLogFile()
        
        Pixels=data.arrDataIndex/data.arrXscale[data.Xscale]
        data.GraphStart=max(Pixels-779, 0)
#        print data.GraphStart      
        
        data.ChangesInGraph=1 #Make sure it only gets refreshed once
        RecordWindowGraph.update() #show RecordWindowGraph          
    
#        print data.arrDataIndex
        if(data.arrDataIndex==data.arrDataLen-1): 
            print "Stopped, array is full"
            QtGui.QMessageBox.warning(RecordWindow, 'Memory is full!', "You reached the end of the recording capacity (24h)!\nThe recording stops now.", QtGui.QMessageBox.Ok)
            RecordWindow.ToggleMeasurement()
    RecordWindow.UpdateScreen()        
#    Show_passed_time("TimerLoop end")

  





###########################################################################
# Start the measurement
###########################################################################
def InitStartMeasurement():
    global app,  RecordWindowGraph
    print "initialize all variables..."
    data.sample_index=0
    data.values_total=0
    data.arrDataIndex=0
    data.Note=""
    
    for i in range(0, data.arrDataLen): #clear data of old records
        for j in range(0,  6): data.arrData[j][i]=0
    
    if(data.QuickMode==0):
        data.interval=data.sampling #normal
        if(data.OfflineMode=="True"): #change to offline mode
            cmd="dbus-send --system --dest=com.nokia.mce --type=method_call /com/nokia/mce/request com.nokia.mce.request.req_device_mode_change string:\"offline\""
            os.popen(cmd)
        data.Xscale=1 #set to default zoom level
    else:  
        data.interval=10 #Fast mode for testing
        data.Xscale=0 #set to max zoom level
    
#    data.run=1 #change to delayed start


#    app.timer_Delay = QtCore.QTimer()
#    QtCore.QObject.connect(app.timer_Delay, QtCore.SIGNAL("timeout()"), StartDelayTimerLoop)     
#    print "QuickMode:",  data.QuickMode
#    if(data.QuickMode==1 or data.DelayStartTime==0): #quick mode
#        data.DelayStart=0
#        app.timer_Delay.start(1) #milliseconds  (make it very quick)
#    else:
#        data.DelayStart=data.DelayStartTime
#        app.timer_Delay.start(1000) #milliseconds         
        
    #Set Start times
#    print "Set StartTime:",  data.StartTime,  data.StartTimeSec

    data.run=2 #change to recording
    app.timer_GetData = QtCore.QTimer()
    QtCore.QObject.connect(app.timer_GetData, QtCore.SIGNAL("timeout()"), TimerLoop)     

    data.StartTime=time.localtime()
    data.StartTimeSec=int(time.mktime(data.StartTime))
   
#        if(data.demo==0): #we are on a N900
    app.timer_GetData.start(data.interval)     
#        else: #faster in demo mode
#            app.timer_GetData.start(data.interval/10) 
    
    
    
    
    if(data.AlarmIsSet==True): 
        Now=int(strftime("%H", time.localtime()))*3600+int(strftime("%M", time.localtime()))*60 #nows h+m in secs
        alarm=int(data.AlarmHour)*3600+int(data.AlarmMinute)*60 #alarm h+m in secs
        alarmdiff=alarm-Now #difference
        if(alarmdiff<0):  #set to tomorrow if time already is elapsed today
            alarmdiff=alarmdiff+86400
            data.AlarmDate=strftime("%d-%m-%Y", time.localtime(time.mktime(time.localtime())+86400))
        else: #today
            data.AlarmDate=strftime("%d-%m-%Y", time.localtime())
        data.AlarmTimeSec=data.StartTimeSec+alarmdiff
        print "Alarm will be at the "+data.AlarmDate+" "+str(data.AlarmHour)+":"+str(data.AlarmMinute)+", in:", str(alarmdiff),  "seconds (timestamp "+str(data.AlarmTimeSec)+"). We have now timestamp "+str(data.StartTimeSec)
   
        InitAlarm()
    
    
    StartLogfile(data.interval)
#    if(data.AlarmIsSet==True): 
    
#    TimerLoop() #first run
   
    data.ChangesInGraph=1 #Make sure it only gets refreshed once    
    RecordWindowGraph.update() #show RecordWindowGraph        
    RecordWindow.UpdateScreen()
    
    
        
    
    print "Start timers (Interval:", data.interval ,"ms)..."
    print "Sampling interval:", data.interval, "ms"
    print "sample_smoothing:", data.sample_smoothing, "x"
    print "value_smoothing:", data.value_smoothing, "x"
    print "=> log interval:", data.interval*data.value_smoothing, "ms"
    print "Derivation:", data.derivation, "(substracts value", data.derivation, "- value 0)"  
    



    
    
#def StartDelayTimerLoop():
##    print "StartDelayTimerLoop"
#    data.DelayStart=data.DelayStart-1
#    if(data.DelayStart<=0):  #delay over
#        app.timer_Delay.stop()
#        
#        data.run=2 #change to recording
#        
#        app.timer_GetData = QtCore.QTimer()
#        QtCore.QObject.connect(app.timer_GetData, QtCore.SIGNAL("timeout()"), TimerLoop)     
#        
##        if(data.demo==0): #we are on a N900
#        app.timer_GetData.start(data.interval) 
##        else: #faster in demo mode
##            app.timer_GetData.start(data.interval/10) 
#        
#        StartLogfile(data.interval)
#        RecordWindow.UpdateScreenStart() 
#        
#    else:
#        RecordWindow.DelayStart()
    




def StopMeasurement():
    global app
#    if(data.run==1): #in delayed start
#        app.timer_Delay.stop()
    if(data.run==2): #in recording
        app.timer_GetData.stop()
        StopLogfile() 
   
    data.run=0
#    DeleteAlarm() #delete Alarm if existing
    data.AlarmIsActive=False
    
    if(data.QuickMode==0): #normal mode
        if(data.OfflineMode=="True" and data.demo!=1): #change to offline mode
            cmd="dbus-send --system --dest=com.nokia.mce --type=method_call /com/nokia/mce/request com.nokia.mce.request.req_device_mode_change string:\"normal\""
            os.popen(cmd)
    else: #test mode
        data.test=0 # reset test mode if was active






############################################################################
## Stretch graph to show more details
############################################################################
def Zoom(direction):
    if(direction==+1): #zoom in
        if(data.Xscale==0): return
        ViewWindow.ui.bZoomOut.setEnabled(True)
        data.Xscale=(data.Xscale-1) % data.arrXscaleLen
        ProcessData()
        data.ChangesInGraph=1 #Make sure it only gets refreshed once
    else: # -1, zoom out
        if(data.Xscale==data.arrXscaleLen-1): return
        ViewWindow.ui.bZoomIn.setEnabled(True)
        data.Xscale=(data.Xscale+1) % data.arrXscaleLen
        ProcessData()
        data.ChangesInGraph=1 #Make sure it only gets refreshed once




    
    
###########################################################################
# Raise or lower the trigger in the graph + sleep phases
###########################################################################
def MoveTrigger(direction):
    if(direction==+1): #up
        data.trigger=data.trigger+1
        if(data.trigger>data.maxtrigger): data.trigger=data.maxtrigger      
        ProcessData()
        data.ChangesInGraph=1 #Make sure it only gets refreshed once
    else: #-1, down
        data.trigger=data.trigger-1
        if(data.trigger<0): data.trigger=0
        ProcessData()
        data.ChangesInGraph=1 #Make sure it only gets refreshed once

















###########################################################################
#  Class for Main Window
###########################################################################
class frmStartWindow(QMainWindow):
    def __init__(self):
        QMainWindow.__init__(self)
        # This attribute makes the whole Stacked Window thing work
        if(data.demo==0): self.setAttribute(Qt.WA_Maemo5StackedWindow)
        self.ui = Ui_StartWindow()
        self.ui.setupUi(self)

        QtCore.QObject.connect(self.ui.bCollecting, QtCore.SIGNAL("clicked()"), self.StartMeasurementNormal)
        QtCore.QObject.connect(self.ui.bQuick, QtCore.SIGNAL("clicked()"), self.StartMeasurementQuick)
        QtCore.QObject.connect(self.ui.bLog, QtCore.SIGNAL("clicked()"), self.ShowViewWindow)
        QtCore.QObject.connect(self.ui.bConfig, QtCore.SIGNAL("clicked()"), self.ShowConfigWindow)
        QtCore.QObject.connect(self.ui.bSetAlarm, QtCore.SIGNAL("clicked()"), self.SetAlarm)
        
        file = open(data.app_path+"Info.htm", 'r')
        txt=""
        for line in file: txt=txt+line+"\n"
        file.close()
        self.ui.textBrowser.setHtml(txt)
        
        if(data.app_path!="./"): #only needed if not started in app path
            self.ui.bSetAlarm.setIcon(QIcon(data.app_path+"img/"+"SleepAnalyser.png"))
            self.ui.bQuick.setIcon(QIcon(data.app_path+"img/"+"krec.png"))
            self.ui.bCollecting.setIcon(QIcon(data.app_path+"img/"+"krec.png"))
            self.ui.bLog.setIcon(QIcon(data.app_path+"img/"+"zoom.png"))
            self.ui.bConfig.setIcon(QIcon(data.app_path+"img/"+"configure.png"))



    ###########################################################################
    # Show the collectring window (hera the data gets visualised during the logging)
    ###########################################################################
    def StartMeasurementNormal(self):
        print "Measure in normal Mode"
        data.QuickMode=0 #run in normal mode
        data.test=0 #show axis lables        
        self.StartMeasurement()
        
        
    ###########################################################################
    # Show the collectring window (hera the data gets visualised during the logging)
    ###########################################################################
    def StartMeasurementQuick(self):
        print "Measure in QuickMode"
        data.QuickMode=1 #run in quick mode (for testing only)
        data.Xscale=0 #default zoom level
        data.test=1 #hide axis lables
        self.StartMeasurement()
        
        
    def StartMeasurement(self):
#        data.QuickMode=0 #run in normal mode
        global RecordWindowGraph
        RecordWindow.show()
        RecordWindowGraph = RecordWindowCanvas(RecordWindow)
        InitStartMeasurement()
#        RecordWindow.UpdateScreenDelayStart()
        RecordWindow.UpdateScreenStart()
        RecordWindowGraph.show()
        
        
    ###########################################################################
    # Show the log window (where the data from a file gets visualised)
    ###########################################################################
    def ShowViewWindow(self):
        global ViewWindowGraph
        
        #reset to default log folder
        if(data.demo==1): data.logfolder=data.devlogfolder #folder on devel PC
        else: data.logfolder=data.defaultlogfolder
        LoadFileList()
        if os.path.exists(data.logfolder+data.lastlogfile):
            data.logfilename=data.lastlogfile
        else:
#            LoadFileList()
            l=len(data.arrLogFiles)
            if(l>0):
                data.logfilename=data.arrLogFiles[l-1] #open last (youngest) log file
            else: #no logfiles in logfolder, show "open file" dialog
                tmp=ViewWindow.ShowFileDialog()
                if(not os.path.exists(tmp)): #only continue if valid log file selected
                    StartWindow.show()
                    ViewWindow.hide()
                    return #only continue if valid log file selected
                tmp2=tmp.split("/")
                l=len(tmp2)    
#                if(tmp2[l-1]==""): #no file selected
#                    print "filename=empty"
#                    return
                data.logfilename=tmp2[l-1]
                data.logfolder=string.replace(tmp,  data.logfilename,  "") #get folder of selected file
                print "Set folder=",  data.logfolder,  ", file=",  data.logfilename
#                data.logfilename=x
        
#        print data.logfilename
        
        ViewWindowGraph = ViewWindowCanvas(self)
        ViewWindow.ShowLogFile()
        
        if(data.logfilename!=""):
            ViewWindow.show()
        else:
            "No valid file selected"
#        StartWindow.hide()
        
        
        
    def ShowConfigWindow(self):
        ConfigWindow.UpdateScreen()
        ConfigWindow.show()
#        StartWindow.hide()



        
    def SetAlarm(self):
        AlarmTimeWindow.UpdateScreen()
        AlarmTimeWindow.show()




    def UpdateScreenStart(self):
        try:   
            print "Application path:",  data.app_path
            file = open(data.app_path+"version", 'r')
            data.version = file.readline()
            data.version=data.version[:-1]
            data.build = file.readline()
            print "Application version:",  data.version,  "Build:",  data.build
        except:
            print "Version file not found"
        self.ui.lblVersion.setText("Version: "+data.version+"-"+data.build)
#        self.ui.lblIcon.setPixmap(QtGui.QPixmap(data.app_path+"img/"+"SleepAnalyser.png"))

    def closeEvent(self, event):
        global config
        WriteConfig()

















###########################################################################
#  Class for Collecting Window
###########################################################################
class frmRecordWindow(QMainWindow):
    def __init__(self, parent=None):
#        QMainWindow.__init__(self, parent)
        # Notice that you must give a parent window as parameter to the constuctor
        QMainWindow.__init__(self, parent)
        # Also set the Stacked Window parameter for every subwindow in the stack
        if(data.demo==0): self.setAttribute(Qt.WA_Maemo5StackedWindow)
        
        self.ui = Ui_RecordWindow()
        self.ui.setupUi(self)
        
        QtCore.QObject.connect(self.ui.bStop, QtCore.SIGNAL("clicked()"), self.ToggleMeasurement)
        QtCore.QObject.connect(self.ui.bRaiseTrigger, QtCore.SIGNAL("clicked()"), self.RaiseTrigger)
        QtCore.QObject.connect(self.ui.bLowerTrigger, QtCore.SIGNAL("clicked()"), self.LowerTrigger)
        QtCore.QObject.connect(self.ui.bZoomIn, QtCore.SIGNAL("clicked()"), self.ZoomIn)
        QtCore.QObject.connect(self.ui.bZoomOut, QtCore.SIGNAL("clicked()"), self.ZoomOut)
        QtCore.QObject.connect(self.ui.bEditNote, QtCore.SIGNAL("clicked()"), self.EditNote)
        
        if(data.app_path!="./"): #only needed if not started in app path
            self.ui.bZoomIn.setIcon(QIcon(data.app_path+"img/"+"zoom-in.png"))
            self.ui.bZoomOut.setIcon(QIcon(data.app_path+"img/"+"zoom-out.png"))
            self.ui.bRaiseTrigger.setIcon(QIcon(data.app_path+"img/"+"go-up.png"))
            self.ui.bLowerTrigger.setIcon(QIcon(data.app_path+"img/"+"go-down.png"))
            self.ui.bEditNote.setIcon(QIcon(data.app_path+"img/"+"kwrite.png"))
            
            
            
            

#    def UpdateScreenDelayStart(self):
#        self.ui.lblStarttime.setText("(Delayed "+str(data.DelayStart)+" sec)")
##        t= t=strftime("%d. %b %Y %H:%M:%S", data.StartTime)
##        self.ui.lblStarttime.setText("")
#        self.ui.lblSamples_Taken.setText("")
#        self.ui.lblElapsedTime.setText("")
#        self.ui.lblNote.setText("")
##        self.ui.lblLogfile.setText("")
##        self.ui.lblYscale.setText(str(data.Yscale))
##        self.ui.lblTrigger.setText(str(data.trigger))
#        self.ui.lblIcon.setPixmap(QtGui.QPixmap(data.app_path+"img/"+"SleepAnalyser.png"))
#        self.ui.bStop.setIcon(QIcon(data.app_path+"img/"+"krec2.png"))
#        self.ui.bStop.setText("Stop")
#
#        if(data.AlarmIsSet==True): #alarm active
#            m=str(data.AlarmMinute)
#            if(len(m)==1): m="0"+m
#            self.ui.lblAlarmTime.setText(str(data.AlarmHour)+":"+m+" or up to "+str(data.AlarmTimeWindow)+" minutes before that")
#        else: #only recording, no alarm
#            self.ui.lblAlarmTime.setText("(Not set)")
#            
#        self.UpdateScreen()
        
        
        
#    def DelayStart(self):
#        self.ui.lblStarttime.setText("(Delayed "+str(data.DelayStart)+" sec)")
        


    def UpdateScreenStart(self):
#        print "UpdateScreenStart"
#        self.ui.lblLogfile.setText(str(data.logfilename))
        t=strftime("%d. %b. %Y %H:%M:%S", data.StartTime)
        self.ui.lblStarttime.setText(t)
#        self.ui.lblSamples_Taken.setText("0")
        self.ui.lblElapsedTime.setText("")
#        self.ui.lblNote.setText("")
#        self.ui.lblYscale.setText(str(data.Yscale))
#        self.ui.lblTrigger.setText(str(data.trigger))
        self.ui.lblIcon.setPixmap(QtGui.QPixmap(data.app_path+"img/"+"SleepAnalyser.png"))
        self.ui.bStop.setIcon(QIcon(data.app_path+"img/"+"krec2.png"))
#        self.ui.bStop.setText("Stop recording")

        if(data.AlarmIsSet==True): #alarm active
            m=str(data.AlarmMinute)
            if(len(m)==1): m="0"+m
            self.ui.lblAlarmTime.setText(str(data.AlarmHour)+":"+m+" or up to "+str(data.AlarmTimeWindow)+" minutes before that")
        else: #Do only recording, no alarm
            self.ui.lblAlarmTime.setText("(No Alarm set)")
                        
        self.UpdateScreen()
        
        
        
    def UpdateScreen(self):
#        if(data.demo==0):
#            self.ui.lblSamples_Taken.setText(str(data.values_total))
#        else:
#            self.ui.lblSamples_Taken.setText(str(data.values_total)+" (Demo Mode)")

#        print "UpdateScreen",  data.run
        if(data.run==2): #recording
            t=time.mktime(time.localtime())
            time_difference=t-data.StartTimeSec
            d=time.strftime("%H:%M:%S", time.gmtime(time_difference))
            self.ui.lblElapsedTime.setText(d + " ("+str(data.values_total)+" records)")
        
        if(data.Xscale==0): self.ui.bZoomIn.setEnabled(False)
        else: self.ui.bZoomIn.setEnabled(True)
        if(data.Xscale==data.arrXscaleLen-1): self.ui.bZoomOut.setEnabled(False)
        else: self.ui.bZoomOut.setEnabled(True)

        if(data.trigger==data.maxtrigger): self.ui.bRaiseTrigger.setEnabled(False)
        else: self.ui.bRaiseTrigger.setEnabled(True)
        if(data.trigger==0): self.ui.bLowerTrigger.setEnabled(False)
        else: self.ui.bLowerTrigger.setEnabled(True)


        
        
    def UpdateScreenStop(self):
#        self.ui.lblStarttime.setText("(Stopped)")
#        self.ui.lblSamples_Taken.setText(str(data.values_total)+" (Stopped)")
        self.ui.bStop.setIcon(QIcon(data.app_path+"img/"+"krec.png"))
        self.ui.bStop.setText("Start")
        
        
        
        
    def ToggleMeasurement(self):
        global app
        if(data.run==0): #not running
            InitStartMeasurement()
#            self.UpdateScreenDelayStart()
            self.UpdateScreenStart()
#        elif(data.run==1): # in delayed start
#            StopMeasurement()
#            self.UpdateScreenStop()
#            data.test=0 # reset test mode if was active
        else: #running
            StopMeasurement()
            self.AskKeepRecord()  
            self.UpdateScreenStop()
            data.test=0 # reset test mode if was active
        
                
    def ZoomIn(self):
        Zoom(+1)
#        self.ui.bZoomOut.setEnabled(True)
#        if(data.Xscale==0): self.ui.bZoomIn.setEnabled(False)
#        else: self.ui.bZoomIn.setEnabled(True)
        data.ChangesInGraph=1 #Make sure it only gets refreshed once
        self.update()
        self.UpdateScreen()
        

    def ZoomOut(self):
        Zoom(-1)
#        self.ui.bZoomIn.setEnabled(True)
#        if(data.Xscale==data.arrXscaleLen-1): self.ui.bZoomOut.setEnabled(False)
#        else: self.ui.bZoomOut.setEnabled(True)
        data.ChangesInGraph=1 #Make sure it only gets refreshed once
        self.update()
        self.UpdateScreen()


    def RaiseTrigger(self):   
        MoveTrigger(+1)
        self.ui.bLowerTrigger.setEnabled(True)
        if(data.trigger==data.maxtrigger): self.ui.bRaiseTrigger.setEnabled(False)
        else: self.ui.bRaiseTrigger.setEnabled(True)
        self.update() 
        self.UpdateScreen()
        
    def LowerTrigger(self):     
        MoveTrigger(-1)
        self.ui.bRaiseTrigger.setEnabled(True)
        if(data.trigger==0): self.ui.bLowerTrigger.setEnabled(False)
        else: self.ui.bLowerTrigger.setEnabled(True)
        self.update()
        self.UpdateScreen()


    def closeEvent(self, event):
        #in case measurement is still running (user did not click on "stop")
        if(data.run==1): #delayed start
            StopMeasurement()     
        if(data.run==2): #running
            StopMeasurement()
            self.AskKeepRecord()     
#        ChangeNoteInFile() #rewrite log file (only do when recording is stopped!)
        data.AlarmIsSet=False
        DeleteAlarm() #delete Alarm if existing
        StartWindow.show()
        self.close() 


    def AskKeepRecord(self):
        if(data.QuickMode==0): #check if user wants to keep this record        
            reply = QtGui.QMessageBox.question(self, 'Keep this Record?', "Do you want to keep this Record?", QtGui.QMessageBox.Yes, QtGui.QMessageBox.No)
            if reply == QtGui.QMessageBox.No:
                print "Delete logfile: "+data.logfilename
                os.remove(data.logfolder+data.logfilename)
            else:
                data.lastlogfile=data.logfilename
    #            print "lastlogfile:",  data.lastlogfile
                config.set('main', 'lastlogfile', str(data.lastlogfile))                   
    #            self.EditNote() #request adding a note
                ChangeNoteInFile() #rewrite log file (only do when recording is stopped!)
        else: #quick mode, delete file anyway
            print "Delete logfile: "+data.logfilename
            os.remove(data.logfolder+data.logfilename)


    def EditNote(self):
        r=QInputDialog.getText(None,  "Add Note",  "Add a note to this record:\n(leave empty for no note)",  QLineEdit.Normal,  data.Note)
        if(r[1]==True): #OK pressed
#            n=unicode(r[0], 'utf-8')
            data.Note=str(r[0])
            self.ui.lblNote.setText(str(data.Note))
            if(data.run==0): ChangeNoteInFile() #rewrite log file (only do when recording is stopped!)














###########################################################################
# Class for Log Window
###########################################################################
class frmViewWindow(QMainWindow):
    def __init__(self, parent=None):
#        QMainWindow.__init__(self, parent)
        # Notice that you must give a parent window as parameter to the constuctor
        QMainWindow.__init__(self, parent)
        # Also set the Stacked Window parameter for every subwindow in the stack
        if(data.demo==0): self.setAttribute(Qt.WA_Maemo5StackedWindow)
        
        
        self.ui = Ui_ViewWindow()
        self.ui.setupUi(self)
        
        QtCore.QObject.connect(self.ui.bRaiseTrigger, QtCore.SIGNAL("clicked()"), self.RaiseTrigger)
        QtCore.QObject.connect(self.ui.bLowerTrigger, QtCore.SIGNAL("clicked()"), self.LowerTrigger)
        QtCore.QObject.connect(self.ui.bZoomIn, QtCore.SIGNAL("clicked()"), self.ZoomIn)
        QtCore.QObject.connect(self.ui.bZoomOut, QtCore.SIGNAL("clicked()"), self.ZoomOut)
        QtCore.QObject.connect(self.ui.bNext, QtCore.SIGNAL("clicked()"), self.NextLogFile)
        QtCore.QObject.connect(self.ui.bLast, QtCore.SIGNAL("clicked()"), self.LastLogFile)
        QtCore.QObject.connect(self.ui.bDelete, QtCore.SIGNAL("clicked()"), self.DeleteLogFile)
        QtCore.QObject.connect(self.ui.bOpen, QtCore.SIGNAL("clicked()"), self.OpenRecord)
        QtCore.QObject.connect(self.ui.bOpenDate, QtCore.SIGNAL("clicked()"), self.OpenDate)
        QtCore.QObject.connect(self.ui.bEditNote, QtCore.SIGNAL("clicked()"), self.EditNote)
        QtCore.QObject.connect(self.ui.bLeft, QtCore.SIGNAL("clicked()"), self.goLeft)
        QtCore.QObject.connect(self.ui.bRight, QtCore.SIGNAL("clicked()"), self.goRight)
#        QtCore.QObject.connect(self.ui.SlrScroll,SIGNAL("valueChanged(int)"),self.SliderMoved)
        
#        self.ui.bLeft.hide() #not yet used
#        self.ui.bRight.hide() #not yet used
        
        if(data.app_path!="./"): #only needed if not started in app path
            self.ui.bLast.setIcon(QIcon(data.app_path+"img/"+"arrow-left-double.png"))
            self.ui.bNext.setIcon(QIcon(data.app_path+"img/"+"arrow-right-double.png"))
            self.ui.bDelete.setIcon(QIcon(data.app_path+"img/"+"edittrash.png"))
            self.ui.bOpen.setIcon(QIcon(data.app_path+"img/"+"document-open-folder.png"))
            self.ui.bOpenDate.setIcon(QIcon(data.app_path+"img/"+"date.png"))
            self.ui.bZoomIn.setIcon(QIcon(data.app_path+"img/"+"zoom-in.png"))
            self.ui.bZoomOut.setIcon(QIcon(data.app_path+"img/"+"zoom-out.png"))
            self.ui.bRaiseTrigger.setIcon(QIcon(data.app_path+"img/"+"go-up.png"))
            self.ui.bLowerTrigger.setIcon(QIcon(data.app_path+"img/"+"go-down.png"))
            self.ui.bLeft.setIcon(QIcon(data.app_path+"img/"+"go-previous.png"))
            self.ui.bRight.setIcon(QIcon(data.app_path+"img/"+"go-next.png"))
            self.ui.bEditNote.setIcon(QIcon(data.app_path+"img/"+"kwrite.png"))
            
#        self.ui.lblYscale.setText(str(data.Yscale))


    def UpdateScreen(self):
        shortfolder=string.replace(data.logfolder, data.homedir, "~/")
        shortfolder=string.replace(shortfolder, "//", "/") #workaround
        self.ui.lblLogfile.setText(data.logfilename+" (in "+shortfolder+")")
#        self.ui.lblStarttime.setText("Start: "+str(data.arrData[0][0]))
#        self.ui.lblStoptime.setText("End: "+str(data.arrData[0][data.arrDataIndex-1]))
#        self.ui.lblTrigger.setText(str(data.trigger))
#        self.ui.lblYscale.setText(str(data.Yscale))
        
#        print "MidnightTransitions:",  data.MidnightTransitions
        try:
            start=str(data.StartDate)+" "+str(data.arrData[0][0])
            stop=str(data.StartDate)+" "+str(data.arrData[0][data.arrDataIndex-1]) #note: stop date will be wrong if recording went beond midnight
            t0=time.strptime(start, "%d-%m-%Y %H:%M:%S")
            t1=time.strptime(stop, "%d-%m-%Y %H:%M:%S")
    #        t1[2]=t1[2]+data.MidnightTransitions
    #        print t0,  t1
            tt0=time.mktime(t0)
            tt1=time.mktime(t1)+86400*data.MidnightTransitions #correction for Midnight Transitions
    #        print tt0,  tt1,  tt1-tt0
            d0=strftime("%a. %d.%m.%Y  %H:%M:%S", time.localtime(tt0))
            d1=strftime("%a. %d.%m.%Y  %H:%M:%S", time.localtime(tt1))
            dt=strftime("%H:%M:%S", time.localtime(tt1-tt0))
    #        print dt
            day0=strftime("%a.", time.localtime(tt0))
            day1=strftime("%a.", time.localtime(tt1))
    #        except:
    #            dt=""
    #            day=""         
    #        self.ui.lblTimes.setText("Start: "+str(day0)+" "+str(data.arrData[0][0])+"   End: "+str(day1)+" "+str(data.arrData[0][data.arrDataIndex-1])+"   Duration: "+str(dt))
            self.ui.lblTimes.setText(str(d0)+"  -  "+str(d1)+"  (Duration: "+str(dt)+")")
        except:
            self.ui.lblTimes.setText("")
            
        self.ui.lblNote.setText(str(data.Note))

        if(data.Xscale==0): self.ui.bZoomIn.setEnabled(False)
        else: self.ui.bZoomIn.setEnabled(True)
        if(data.Xscale==data.arrXscaleLen-1): self.ui.bZoomOut.setEnabled(False)
        else: self.ui.bZoomOut.setEnabled(True)

        if(data.trigger==data.maxtrigger): self.ui.bRaiseTrigger.setEnabled(False)
        else: self.ui.bRaiseTrigger.setEnabled(True)
        if(data.trigger==0): self.ui.bLowerTrigger.setEnabled(False)
        else: self.ui.bLowerTrigger.setEnabled(True)
        
#        print len(data.arrLogFiles),  (data.arrLogFiles)
        if(len(data.arrLogFiles)<2): #disable last/next buttons if only one file in folder
            self.ui.bNext.setEnabled(False)
            self.ui.bLast.setEnabled(False)
        else:
            self.ui.bNext.setEnabled(True)
            self.ui.bLast.setEnabled(True)
            
            
                        
        Pixels=data.arrDataIndex/data.arrXscale[data.Xscale]
#        data.GraphStart=min(data.GraphStart+360, max(Pixels-775, 0))
#        print data.GraphStart
        if(data.GraphStart<max(Pixels-779, 0)): self.ui.bRight.setEnabled(True)
        else: self.ui.bRight.setEnabled(False)
        if(data.GraphStart>0): self.ui.bLeft.setEnabled(True)
        else: self.ui.bLeft.setEnabled(False)
            
            
            

    def ShowLogFile(self):
        WriteConfig() #save all parameters as they will get changed
        r=OpenLogFile()    
        if(r==1): #file too long            
            QtGui.QMessageBox.warning(self, 'Record too long!', "The record is too long. The end will be cut off!", QtGui.QMessageBox.Ok)
        elif(r==2): #file does not exist
#            closeEvent(0)
            self.OpenRecord()
            return
        elif(r==3): #file is corrupted => draw empty graph
            QtGui.QMessageBox.warning(self, 'File corrupded!', "The data in the record file\n"+data.logfilename+"\nis invalid!\nNo data loaded.", QtGui.QMessageBox.Ok)
        elif(r==4): #file is empty
            QtGui.QMessageBox.warning(self, 'File empty!', "The data in the record file\n"+data.logfilename+"\ncontains no data!\nNo data loaded.", QtGui.QMessageBox.Ok)
        LoadFileList()
        ProcessData()
        data.Xscale=1 #default zoom level
#        data.GraphStart=0        
        Pixels=data.arrDataIndex/data.arrXscale[data.Xscale]
        data.GraphStart=max(Pixels-779, 0)
        data.ChangesInGraph=1 #Make sure it only gets refreshed once
        ViewWindowGraph = ViewWindowCanvas(self)
        ViewWindowGraph.show()
        self.UpdateScreen()
        
        
    def NextLogFile(self):
        Show_passed_time("Next LogFile",  1)
        
        data.arrLogFileIndex=(data.arrLogFileIndex+1)  % len(data.arrLogFiles)
        data.logfilename=data.arrLogFiles[data.arrLogFileIndex]
        self.ShowLogFile()


    def LastLogFile(self):
        Show_passed_time("Last LogFile",   1)
        data.arrLogFileIndex=(data.arrLogFileIndex-1)  % len(data.arrLogFiles)
        data.logfilename=data.arrLogFiles[data.arrLogFileIndex]
        self.ShowLogFile()


        
    def ZoomIn(self):
        Show_passed_time("Zoom in",   1)
        Zoom(+1)
        self.ui.bZoomOut.setEnabled(True)
        if(data.Xscale==0): self.ui.bZoomIn.setEnabled(False)
        else: self.ui.bZoomIn.setEnabled(True)
#        data.GraphStart=0
        Pixels=data.arrDataIndex/data.arrXscale[data.Xscale]
        data.GraphStart=max(Pixels-779, 0)
        self.update()
        self.UpdateScreen()

    def ZoomOut(self):
        Show_passed_time("Zoom out",   1)
        Zoom(-1)
        self.ui.bZoomIn.setEnabled(True)
        if(data.Xscale==data.arrXscaleLen-1): self.ui.bZoomOut.setEnabled(False)
        else: self.ui.bZoomOut.setEnabled(True)
#        data.GraphStart=0
        Pixels=data.arrDataIndex/data.arrXscale[data.Xscale]
        data.GraphStart=max(Pixels-779, 0)
        self.update()
        self.UpdateScreen()
        
        

    def RaiseTrigger(self):   
        MoveTrigger(+1)
        self.update() 
        self.UpdateScreen()
        
    def LowerTrigger(self):     
        MoveTrigger(-1)
        self.update()
        self.UpdateScreen()
    
        
        
        
    def goLeft(self):
        Show_passed_time("Scroll left",   1)
        Pixels=data.arrDataIndex/data.arrXscale[data.Xscale]
        data.GraphStart=max(data.GraphStart-600, 0)
#        print data.GraphStart                
        data.ChangesInGraph=1 #Make sure it only gets refreshed once
        self.update()
        self.UpdateScreen()
        
        
    def goRight(self):
        Show_passed_time("Scroll right",   1)
        Pixels=data.arrDataIndex/data.arrXscale[data.Xscale]
        data.GraphStart=min(data.GraphStart+600, max(Pixels-779, 0))
#        print data.GraphStart        
        data.ChangesInGraph=1 #Make sure it only gets refreshed once
        self.update()
        self.UpdateScreen()
        
        

    def DeleteLogFile(self):
        reply = QtGui.QMessageBox.question(self, 'Delete Record?', "Are you sure you want to delete this record?", QtGui.QMessageBox.Yes, QtGui.QMessageBox.No)
        if reply == QtGui.QMessageBox.Yes:
            print "Delete logfile: "+data.logfilename
            os.remove(data.logfolder+data.logfilename)    
            
            LoadFileList()
            l=len(data.arrLogFiles)
            if(l>0):
                data.logfilename=data.arrLogFiles[l-1] #open last (youngest) log file
            else: #no logfiles in logfolder, show "open file" dialog
                tmp=self.ShowFileDialog()
                if(tmp==""): #only continue if valid log file selected
                    self.closeEvent("") #no file selected, close
                    return
                tmp2=tmp.split("/")
                l=len(tmp2)    
                data.logfilename=tmp2[l-1]
                data.logfolder=string.replace(tmp,  data.logfilename,  "") #get folder of selected file
                print "Set folder=",  data.logfolder,  ", file=",  data.logfilename
            self.ShowLogFile()
            self.UpdateScreen()



    def OpenRecord(self):
        tmp=self.ShowFileDialog()
        if(not os.path.exists(tmp)): #only continue if valid log file selected
#            print "OpenRecord: File does not exist"
#            ViewWindow.hide()
#            StartWindow.show()
            return 
#        print "OpenRecord: File ok"
        tmp2=tmp.split("/")
        l=len(tmp2)    
        data.logfilename=tmp2[l-1]
        data.logfolder=string.replace(tmp,  data.logfilename,  "") #get folder of selected file
        print "Set folder=",  data.logfolder,  ", file=",  data.logfilename
        self.ShowLogFile()
    
    
    
    
    def ShowFileDialog(self):        
        data.logfolder=string.replace(data.logfolder, "~",  data.homedir) #workaround
        print "Open file dialog in:",  data.logfolder
        tmp= QFileDialog.getOpenFileName(None,"Open SleepAnalyser Log File", data.logfolder, "Log Files (*.csv)");
        print "Selected file:",  tmp
#        tmp2=tmp.split("/")
#        l=len(tmp2)    
#        x=tmp2[l-1]
#        return x
        return tmp
        
    def OpenDate(self):
        DateWindow.show()
        DateWindow.DateChanged()


    def closeEvent(self, event):
        LoadConfig() #restore all parameters as they got changed while loading the record file
        ViewWindow.close()
        StartWindow.show()
        

    def EditNote(self):
        r=QInputDialog.getText(None,  "Edit Note",  "Add a note to this record:\n(leave empty for no note)",  QLineEdit.Normal,  data.Note)
        if(r[1]==True): #OK pressed
            data.Note=str(r[0])
            self.ui.lblNote.setText(str(data.Note))
            ChangeNoteInFile() #rewrite log file (only do when recording is stopped!)















###########################################################################
# Class for Configuration Window
###########################################################################
class frmConfigWindow(QMainWindow):
    def __init__(self, parent):
        # Notice that you must give a parent window as parameter to the constuctor
        QMainWindow.__init__(self, parent)
        # Also set the Stacked Window parameter for every subwindow in the stack
        if(data.demo==0): self.setAttribute(Qt.WA_Maemo5StackedWindow)
        
        self.ui = Ui_ConfigWindow()
        self.ui.setupUi(self)
        self.ui.lblIcon.setPixmap(QtGui.QPixmap(data.app_path+"img/"+"SleepAnalyser.png"))
              
        QtCore.QObject.connect(self.ui.bEditUserName, QtCore.SIGNAL("clicked()"), self.EditUserName)
        QtCore.QObject.connect(self.ui.SlrDelayStart,SIGNAL("valueChanged(int)"),self.SliderMoved)
        
        

    def UpdateScreen(self):
        if(data.OfflineMode=="True"): self.ui.cOfflineMode.setChecked(True)
        else: self.ui.cOfflineMode.setChecked(False)        
        self.ui.lblUserName.setText(str(data.user))
        self.ui.lblDelayStart.setText(str(data.DelayStartTime)+" sec")
        self.ui.SlrDelayStart.setValue(int(data.DelayStartTime))


    def closeEvent(self, event):        
        if(self.ui.cOfflineMode.isChecked()==True):          
                data.OfflineMode="True"
        else: 
            data.OfflineMode="False"
        config.set('main', 'OfflineMode', str(data.OfflineMode))   
        config.set('main', 'user', str(data.user))      
        config.set('main', 'DelayStartTime', str(data.DelayStartTime))      
        
        ConfigWindow.close()
        StartWindow.show()


    def EditUserName(self):
        EditUserName()
        self.ui.lblUserName.setText(str(data.user))
        
        
    def SliderMoved(self):
        x=self.ui.SlrDelayStart.value()
        data.DelayStartTime=x
        self.ui.lblDelayStart.setText(str(data.DelayStartTime)+" sec")
#        data.DropIndexes=(data.sampling*data.value_smoothing)/1000
#        print data.DropIndexes








###########################################################################
# Class for Date Window
###########################################################################
class frmDateWindow(QMainWindow):
    def __init__(self, parent=None):
#        QMainWindow.__init__(self, parent)
        # Notice that you must give a parent window as parameter to the constuctor
        QMainWindow.__init__(self, parent)
        # Also set the Stacked Window parameter for every subwindow in the stack
        if(data.demo==0): self.setAttribute(Qt.WA_Maemo5StackedWindow)
        
        self.ui = Ui_DateWindow()
        self.ui.setupUi(self)
#        self.ui.lblIcon.setPixmap(QtGui.QPixmap(data.app_path+"img/"+"SleepAnalyser.png"))
#        
        if(data.app_path!="./"): #only needed if not started in app path
            self.ui.bOpen.setIcon(QIcon(data.app_path+"img/"+"zoom.png"))

        QtCore.QObject.connect(self.ui.cal, QtCore.SIGNAL('selectionChanged()'), self.DateChanged)
        QtCore.QObject.connect(self.ui.bOpen, QtCore.SIGNAL("clicked()"), self.OpenRecord)
        
        self.ui.cal.showToday()


    def DateChanged(self):
        date = self.ui.cal.selectedDate()
        date=str(date.toPyDate())

        print "Load list of all csv files in folder:",  data.logfolder + " with date " + date
        output = os.popen("cd "+str(data.logfolder)+"; ls -C1 *"+date+"*.csv").read() # run ls and make the output look like a file I can read
        arrLogFiles=output.split("\n")
        arrLogFiles.pop()

        amount=len(arrLogFiles)
#        for i in range(amount): print arrLogFiles[i]
        
        self.ui.lblResult.setText("Found "+str(amount)+" Records for this date.")
        if(amount>0): 
            self.ui.bOpen.setEnabled(True)
            data.LogFileSelectedDate=arrLogFiles[0] #select first file of that date for opening
        else: self.ui.bOpen.setEnabled(False)


    def OpenRecord(self):
        data.logfilename=data.LogFileSelectedDate
        print "Set folder=",  data.logfolder,  ", file=",  data.logfilename
        DateWindow.hide()
        ViewWindow.ShowLogFile()


    def closeEvent(self, event):        
        pass








###########################################################################
# Class for Setting the alarm time Window
###########################################################################
class frmAlarmTimeWindow(QMainWindow):
    def __init__(self, parent=None):
#        QMainWindow.__init__(self, parent)
        # Notice that you must give a parent window as parameter to the constuctor
        QMainWindow.__init__(self, parent)
        # Also set the Stacked Window parameter for every subwindow in the stack
        if(data.demo==0): self.setAttribute(Qt.WA_Maemo5StackedWindow)
        
        self.ui = Ui_AlarmTimeWindow()
        self.ui.setupUi(self)
        self.ui.lblIcon.setPixmap(QtGui.QPixmap(data.app_path+"img/"+"SleepAnalyser.png"))

        QtCore.QObject.connect(self.ui.bSetAlarm, QtCore.SIGNAL("clicked()"), self.SetAlarm)
                
        if(data.app_path!="./"): #only needed if not started in app path
            self.ui.bSetAlarm.setIcon(QIcon(data.app_path+"img/"+"SleepAnalyser.png"))

    
        

    def UpdateScreen(self):
        if(data.AlarmHour==-1 or data.AlarmMinute==-1):
            data.AlarmHour=7
            data.AlarmMinute=0
        print "Alarm time:",  data.AlarmHour, ":",  data.AlarmMinute
        self.ui.lstAlarmHour.setCurrentRow(int(data.AlarmHour))
        self.ui.lstAlarmMinute.setCurrentRow(int(data.AlarmMinute)/5)
        self.ui.lstAlarmTimeWindow.setCurrentRow(int(data.AlarmTimeWindow)/5-1)
#        s="The Alarm will go off on the set time or maximum "+str(data.AlarmTimeWindow)+" minutes earlier, depending on your movements."
        s="The Alarm will then go off sometimes during the time window (as soon as you move more), but latest at the set alarm time."
        self.ui.lblNote.setText(s)




    def SetAlarm(self):
        global RecordWindowGraph
        print "Set Alarm"
        data.QuickMode=0 #run in normal mode
        
        data.AlarmIsSet=True
        
        RecordWindowGraph = RecordWindowCanvas(RecordWindow)
                
        try:
            data.AlarmHour=int(self.ui.lstAlarmHour.currentItem().text())
            data.AlarmMinute=int(self.ui.lstAlarmMinute.currentItem().text())
            data.AlarmTimeWindow=int(self.ui.lstAlarmTimeWindow.currentItem().text())
            config.set('main', 'AlarmHour', str(data.AlarmHour))  
            config.set('main', 'AlarmMinute', str(data.AlarmMinute))  
            config.set('main', 'AlarmTimeWindow', str(data.AlarmTimeWindow))  
        except: #If nothing selected (workaround)
            data.AlarmHour=7
            data.AlarmMinute=0
            print "Selected time not valid, use default:",  data.AlarmHour, ":", data.AlarmMinute

        
        InitStartMeasurement()
        
#        Now=int(strftime("%H", time.localtime()))*3600+int(strftime("%M", time.localtime()))*60 #nows h+m in secs
#        alarm=int(data.AlarmHour)*3600+int(data.AlarmMinute)*60 #alarm h+m in secs
#        alarmdiff=alarm-Now #difference
#        if(alarmdiff<0):  #set to tomorrow if time already is elapsed today
#            alarmdiff=alarmdiff+86400
#            data.AlarmDate=strftime("%d-%m-%Y", time.localtime(time.mktime(time.localtime())+86400))
#        else: #today
#            data.AlarmDate=strftime("%d-%m-%Y", time.localtime())
#        data.AlarmTimeSec=data.StartTimeSec+alarmdiff
#        print "Alarm will be at the "+data.AlarmDate+" "+str(data.AlarmHour)+":"+str(data.AlarmMinute)+", in:", str(alarmdiff),  "seconds (timestamp "+str(data.AlarmTimeSec)+"). We have now timestamp "+str(data.StartTimeSec)

        
        
#        if(data.demo==0): #We are on a N900
        DeleteAlarm() #delete old alarm if existing
        SetAlarm(data.AlarmHour,  data.AlarmMinute) #set alarm for the last possible time
                                #(when movements occure shortly before it, we can set it off earlier.)
#        else:
#            print "Can not set alarm, Maemo interface not available"
        
#        data.AlarmIsSet=True
        
        
        RecordWindow.show()
        AlarmTimeWindow.hide()
#        InitStartMeasurement()
#        RecordWindow.UpdateScreenDelayStart()
        RecordWindow.UpdateScreenStart()
        RecordWindowGraph.show()



    def closeEvent(self, event):        
        pass








###########################################################################
# Class for drawing the RecordWindowGraph
###########################################################################
class RecordWindowCanvas(QtGui.QWidget):
    def __init__(self, parent):
        QMainWindow.__init__(self, parent)    
        self.setGeometry(9, 180, 782, data.Ysize+55)
    
    def paintEvent(self, event):
        showGraph(self,  QtGui)



    
###########################################################################
# Class for drawing the ViewWindowGraph
###########################################################################
class ViewWindowCanvas(QtGui.QWidget):
    def __init__(self, parent):
        QMainWindow.__init__(self, parent)    
        self.setGeometry(9, 100, 782, data.Ysize+55)
    
    def paintEvent(self, event):
        showGraph(self,  QtGui)
    
    
    
###########################################################################
# Now we can start it.
main()

