#!/usr/bin/env python
###########################################################################
# Name: 	         SleepAnalyser
# Description:	 Analyses your movement during your sleep
# Copyright:     George Ruinelli, george@ruinelli.ch
# Last change:  (See file "version")
# Licence:         GPL
###########################################################################

import sys
import random
import time
from time import strftime
import math
import array
import string

from PyQt4.QtCore import * 
from PyQt4.QtGui import * 

import ConfigParser
import os, os.path



import data #own data
from myFunctions import * #Own functions
from myFunctions2 import * #Own functions

#GUIs
from Ui_StartWindow import *
from Ui_CollectingWindow import *
from Ui_LogWindow import *
from Ui_NoteWindow import *



  
###########################################################################
# Main function
###########################################################################
def main():
    global app,  StartWindow,  CollectingWindow,  LogWindow ,  NoteWindow
    global config
    global CollectingWindowGraph
   
    try:
        if(sys.argv[1]=="debug"): 
            print "Enable Debug mode"
            data.debug=1
    except:
        data.debug=0

    #if not on the N900, a acceleration sensor has to be simulated
    if os.path.exists("/sys/class/i2c-adapter/i2c-3/3-001d/coord"): data.demo=0	#runs on real N900 hardware
    else: data.demo=1	#runs on other hardware/OS


    if(data.demo==1):
        print "Runs not on a N900 => Use randomizer for acceleration sensor data"
        data.configfolder=data.devconfigfolder
        data.logfolder=data.devlogfolder

    app = QtGui.QApplication(sys.argv)
    
    config=LoadConfig()
    
    data.app_path=os.path.dirname(__file__)
    if(data.app_path==""): data.app_path="./"
    else: data.app_path=data.app_path+"/"
    
    StartWindow = frmStartWindow()    
    CollectingWindow = frmCollectingWindow()
    LogWindow = frmLogWindow()
    NoteWindow = frmNoteWindow()
    
    StartWindow.show()      

    StartWindow.UpdateScreenStart()
    StartWindow.show()
    
    #get user name for in log files
    if(data.user==""):
#            tmp= QFileDialog.getOpenFileName(None,"Open SleepCycle Log File", data.logfolder, "Log Files (*.csv)");
        text = QInputDialog.getText(None, "SleepAnalyser", "Please enter your name.\n"+ \
                                                                                             "It will be used in the records file, this makes it easier\n" + \
                                                                                             "when you want to share your sleep pattern with others.")
        if(text != ""):
            data.user=text[0]
            config.set('main', 'user', str(data.user))    
        else:
            pass
    print "User name:",  data.user

    sys.exit(app.exec_())





###########################################################################
#  Gets called every second,
###########################################################################
def TimerLoop():
    global CollectingWindowGraph
    
#    Show_passed_time("TimerLoop start")

    r=GetSensorData() #(interval: sampling*sample_smoothing*value_smoothing)
    if(r==1):
        WriteIntoLogFile()
        ProcessData() 
        data.ChangesInGraph=1 #Make sure it only gets refreshed once
        CollectingWindowGraph.update() #show CollectingWindowGraph    
    
    CollectingWindow.UpdateScreen()    
    
#    Show_passed_time("TimerLoop end")

  



###########################################################################
# Starte the measurement
###########################################################################
def StartMeasurement():
    global app
    #init value
    data.sample_index=0
    data.values_total=0
    data.arrDataIndex=0
    data.arrData[0][0]=""
    
    if(data.Mode==0):
        interval=data.sampling #normal
    else:  
        interval=10 #Fast mode for testing
    
    data.run=1
    app.timer_GetData = QtCore.QTimer()
    QtCore.QObject.connect(app.timer_GetData, QtCore.SIGNAL("timeout()"), TimerLoop)        
    app.timer_GetData.start(interval) 
   
    data.ChangesInGraph=1 #Make sure it only gets refreshed once    
    
    StartLogfile(interval)
        
    data.Xscale=1 #default zoom level
    
    print "Start timers (Interval:", interval ,"ms)..."
    print "Sampling interval:", interval, "ms"
    print "sample_smoothing:", data.sample_smoothing, "x"
    print "value_smoothing:", data.value_smoothing, "x"
    print "=> log interval:", interval*data.value_smoothing, "ms"
    print "Derivation:", data.derivation, "(substracts value", data.derivation, "- value 0)"  
    

    
    


def StopMeasurement():
    global app
    data.run=0
    print "Stop timers..."
    app.timer_GetData.stop()
    data.run=0
    StopLogfile()       
    data.test=0 # reset test mode if was active






############################################################################
## Stretch graph to show more details
############################################################################
def Zoom(direction):
    if(direction==+1): #zoom in
        if(data.Xscale==0): return
        LogWindow.ui.bZoomOut.setEnabled(True)
        data.Xscale=(data.Xscale-1) % data.arrXscaleLen
        ProcessData()
        data.ChangesInGraph=1 #Make sure it only gets refreshed once
    else: # -1, zoom out
        if(data.Xscale==data.arrXscaleLen-1): return
        LogWindow.ui.bZoomIn.setEnabled(True)
        data.Xscale=(data.Xscale+1) % data.arrXscaleLen
        ProcessData()
        data.ChangesInGraph=1 #Make sure it only gets refreshed once




    
    
###########################################################################
# Raise or lower the trigger in the graph + sleep phases
###########################################################################
def MoveTrigger(direction):
    if(direction==+1): #up
        data.trigger=data.trigger+1
        if(data.trigger>data.maxtrigger): data.trigger=data.maxtrigger      
        ProcessData()
        data.ChangesInGraph=1 #Make sure it only gets refreshed once
    else: #-1, down
        data.trigger=data.trigger-1
        if(data.trigger<0): data.trigger=0
        ProcessData()
        data.ChangesInGraph=1 #Make sure it only gets refreshed once









###########################################################################
#  Class for Main Window
###########################################################################
class frmStartWindow(QtGui.QWidget):
    def __init__(self, parent=None):
        QtGui.QWidget.__init__(self, parent)
        self.ui = Ui_StartWindow()
        self.ui.setupUi(self)

        QtCore.QObject.connect(self.ui.bCollecting, QtCore.SIGNAL("clicked()"), self.StartMeasurementNormal)
        QtCore.QObject.connect(self.ui.bQuick, QtCore.SIGNAL("clicked()"), self.StartMeasurementQuick)
        QtCore.QObject.connect(self.ui.bLog, QtCore.SIGNAL("clicked()"), self.ShowLogWindow)
        
        if(data.app_path!="./"): #only needed if not started in app path
            self.ui.bSetAlarm.setIcon(QIcon(data.app_path+"SleepAnalyser.png"))
            self.ui.bQuick.setIcon(QIcon(data.app_path+"krec.png"))
            self.ui.bCollecting.setIcon(QIcon(data.app_path+"krec.png"))
            self.ui.bLog.setIcon(QIcon(data.app_path+"zoom.png"))


    ###########################################################################
    # Show the collectring window (hera the data gets visualised during the logging)
    ###########################################################################
    def StartMeasurementNormal(self):
        data.Mode=0 #run in normal mode
        data.test=0 #show axis lables
        self.StartMeasurement()
        
        
    ###########################################################################
    # Show the collectring window (hera the data gets visualised during the logging)
    ###########################################################################
    def StartMeasurementQuick(self):
        data.Mode=1 #run in quick mode (for testing only)
        data.Xscale=0 #default zoom level
        data.test=1 #hide axis lables
        self.StartMeasurement()
        
        
    def StartMeasurement(self):
        global CollectingWindowGraph
        CollectingWindow.show()
        StartWindow.hide()
        CollectingWindowGraph = CollectingWindowCanvas()
        StartMeasurement()
        CollectingWindow.UpdateScreenStart()
        CollectingWindowGraph.show()
        
        
    ###########################################################################
    # Show the log window (her ethe data from a file gets visualised)
    ###########################################################################
    def ShowLogWindow(self):
        global LogWindowGraph
        
        tmp= QFileDialog.getOpenFileName(None,"Open SleepCycle Log File", data.logfolder, "Log Files (*.csv)");
        tmp2=tmp.split("/")
        l=len(tmp2)    
        x=tmp2[l-1]
        if(x==""): return #only continue if valid log file selected
        data.logfilename=x
        
        LogWindowGraph = LogWindowCanvas()
        LogWindow.ShowLogFile()
        
        LogWindow.show()
        StartWindow.hide()
        
        

    def UpdateScreenStart(self):
        try:   
            print "Application path:",  data.app_path
            file = open(data.app_path+"version", 'r')
            data.version = file.readline()
            data.version=data.version[:-1]
            data.build = file.readline()
        except:
            print "Version file not found"
        self.ui.lblVersion.setText(data.version+"."+data.build)
        self.ui.lblIcon.setPixmap(QtGui.QPixmap(data.app_path+"SleepAnalyser.png"))

    def closeEvent(self, event):
        global config
        WriteConfig(config)
















###########################################################################
#  Class for Collecting Window
###########################################################################
class frmCollectingWindow(QtGui.QWidget):
    def __init__(self, parent=None):
        QtGui.QWidget.__init__(self, parent)
        self.ui = Ui_CollectingWindow()
        self.ui.setupUi(self)
        
        QtCore.QObject.connect(self.ui.bStop, QtCore.SIGNAL("clicked()"), self.ToggleMeasurement)
        QtCore.QObject.connect(self.ui.bRaiseTrigger, QtCore.SIGNAL("clicked()"), self.RaiseTrigger)
        QtCore.QObject.connect(self.ui.bLowerTrigger, QtCore.SIGNAL("clicked()"), self.LowerTrigger)
        QtCore.QObject.connect(self.ui.bZoomIn, QtCore.SIGNAL("clicked()"), self.ZoomIn)
        QtCore.QObject.connect(self.ui.bZoomOut, QtCore.SIGNAL("clicked()"), self.ZoomOut)
        
        if(data.app_path!="./"): #only needed if not started in app path
            self.ui.bZoomIn.setIcon(QIcon(data.app_path+"zoom-in.png"))
            self.ui.bZoomOut.setIcon(QIcon(data.app_path+"zoom-out.png"))
            self.ui.bRaiseTrigger.setIcon(QIcon(data.app_path+"go-up.png"))
            self.ui.bLowerTrigger.setIcon(QIcon(data.app_path+"go-down.png"))
            

    def UpdateScreen(self):
        if(data.demo==0):
            self.ui.lblSamples_Taken.setText(str(data.values_total))
        else:
            self.ui.lblSamples_Taken.setText(str(data.values_total)+" (Demo Mode)")

        t=time.mktime(time.localtime())
        time_difference=t-data.StartTimeSec
        t=strftime("%H:%M:%S", time.gmtime(time_difference))
        self.ui.lblElapsedTime.setText(t)
        self.ui.lblTrigger.setText(str(data.trigger))
        
        if(data.Xscale==0): self.ui.bZoomIn.setEnabled(False)
        else: self.ui.bZoomIn.setEnabled(True)
        if(data.Xscale==data.arrXscaleLen-1): self.ui.bZoomOut.setEnabled(False)
        else: self.ui.bZoomOut.setEnabled(True)

        if(data.trigger==data.maxtrigger): self.ui.bRaiseTrigger.setEnabled(False)
        else: self.ui.bRaiseTrigger.setEnabled(True)
        if(data.trigger==0): self.ui.bLowerTrigger.setEnabled(False)
        else: self.ui.bLowerTrigger.setEnabled(True)
            

    def UpdateScreenStart(self):
        self.ui.lblLogfile.setText(str(data.logfilename))
        t= t=strftime("%d. %b %Y %H:%M:%S", data.StartTime)
        self.ui.lblStarttime.setText(t)
        self.ui.lblSamples_Taken.setText("0")
        self.ui.lblElapsedTime.setText("00:00:00")
        self.ui.lblYscale.setText(str(data.Yscale))
        self.ui.lblTrigger.setText(str(data.trigger))
        self.ui.lblIcon.setPixmap(QtGui.QPixmap(data.app_path+"SleepAnalyser.png"))
        self.ui.bStop.setIcon(QIcon(data.app_path+"krec2.png"))
        self.ui.bStop.setText("Stop recording")

        self.UpdateScreen()
        
        
    def UpdateScreenStop(self):
        self.ui.lblSamples_Taken.setText(str(data.values_total)+" (Stopped)")
        self.ui.bStop.setIcon(QIcon(data.app_path+"krec.png"))
        self.ui.bStop.setText("Start recording")
        
        
    def ToggleMeasurement(self):
        global app
        if(data.run==0): #not running
            StartMeasurement()
            self.UpdateScreenStart()
        else: #running
            StopMeasurement()
            self.UpdateScreenStop()
            data.test=0 # reset test mode if was active
        
        
        
    def ZoomIn(self):
        Zoom(+1)
#        self.ui.bZoomOut.setEnabled(True)
#        if(data.Xscale==0): self.ui.bZoomIn.setEnabled(False)
#        else: self.ui.bZoomIn.setEnabled(True)
        self.update()
        self.UpdateScreen()

    def ZoomOut(self):
        r=Zoom(-1)
#        self.ui.bZoomIn.setEnabled(True)
#        if(data.Xscale==data.arrXscaleLen-1): self.ui.bZoomOut.setEnabled(False)
#        else: self.ui.bZoomOut.setEnabled(True)
        self.update()
        self.UpdateScreen()


    def RaiseTrigger(self):   
        MoveTrigger(+1)
        self.ui.bLowerTrigger.setEnabled(True)
        if(data.trigger==data.maxtrigger): self.ui.bRaiseTrigger.setEnabled(False)
        else: self.ui.bRaiseTrigger.setEnabled(True)
        self.update() 
        self.UpdateScreen()
        
    def LowerTrigger(self):     
        MoveTrigger(-1)
        self.ui.bRaiseTrigger.setEnabled(True)
        if(data.trigger==0): self.ui.bLowerTrigger.setEnabled(False)
        else: self.ui.bLowerTrigger.setEnabled(True)
        self.update()
        self.UpdateScreen()


    def closeEvent(self, event):
        #check if user wants to keep this record
        reply = QtGui.QMessageBox.question(self, 'Keep Logfile?', "Do you want to keep this Record?", QtGui.QMessageBox.Yes, QtGui.QMessageBox.No)
        if reply == QtGui.QMessageBox.No:
            print "Delete logfile: "+data.logfilename
            os.remove(data.logfolder+data.logfilename)
            
        if(data.run==1): StopMeasurement()
        StartWindow.show()
#        NoteWindow.show()
        self.close() 


   
   






###########################################################################
# Class for Log Window
###########################################################################
class frmLogWindow(QtGui.QWidget):
    def __init__(self, parent=None):
        QtGui.QWidget.__init__(self, parent)
        self.ui = Ui_LogWindow()
        self.ui.setupUi(self)
        
        QtCore.QObject.connect(self.ui.bRaiseTrigger, QtCore.SIGNAL("clicked()"), self.RaiseTrigger)
        QtCore.QObject.connect(self.ui.bLowerTrigger, QtCore.SIGNAL("clicked()"), self.LowerTrigger)
        QtCore.QObject.connect(self.ui.bZoomIn, QtCore.SIGNAL("clicked()"), self.ZoomIn)
        QtCore.QObject.connect(self.ui.bZoomOut, QtCore.SIGNAL("clicked()"), self.ZoomOut)
        QtCore.QObject.connect(self.ui.bNext, QtCore.SIGNAL("clicked()"), self.NextLogFile)
        QtCore.QObject.connect(self.ui.bLast, QtCore.SIGNAL("clicked()"), self.LastLogFile)
        QtCore.QObject.connect(self.ui.bDelete, QtCore.SIGNAL("clicked()"), self.DeleteLogFile)
        
        if(data.app_path!="./"): #only needed if not started in app path
            self.ui.bLast.setIcon(QIcon(data.app_path+"go-previous.png"))
            self.ui.bNext.setIcon(QIcon(data.app_path+"go-next.png"))
            self.ui.bDelete.setIcon(QIcon(data.app_path+"edittrash.png"))
            self.ui.bZoomIn.setIcon(QIcon(data.app_path+"zoom-in.png"))
            self.ui.bZoomOut.setIcon(QIcon(data.app_path+"zoom-out.png"))
            self.ui.bRaiseTrigger.setIcon(QIcon(data.app_path+"go-up.png"))
            self.ui.bLowerTrigger.setIcon(QIcon(data.app_path+"go-down.png"))
            
        self.ui.lblYscale.setText(str(data.Yscale))


    def UpdateScreen(self):
        self.ui.lblLogfile.setText(data.logfilename)
        self.ui.lblStarttime.setText(str(data.arrData[0][0]))
        self.ui.lblStoptime.setText(str(data.arrData[0][data.arrDataIndex-1]))
        self.ui.lblTrigger.setText(str(data.trigger))
        self.ui.lblYscale.setText(str(data.Yscale))

        if(data.Xscale==0): self.ui.bZoomIn.setEnabled(False)
        else: self.ui.bZoomIn.setEnabled(True)
        if(data.Xscale==data.arrXscaleLen-1): self.ui.bZoomOut.setEnabled(False)
        else: self.ui.bZoomOut.setEnabled(True)

        if(data.trigger==data.maxtrigger): self.ui.bRaiseTrigger.setEnabled(False)
        else: self.ui.bRaiseTrigger.setEnabled(True)
        if(data.trigger==0): self.ui.bLowerTrigger.setEnabled(False)
        else: self.ui.bLowerTrigger.setEnabled(True)



    def ShowLogFile(self):
        OpenLogFile()    
        LoadFileList()
        ProcessData()
        data.Xscale=1 #default zoom level
        data.ChangesInGraph=1 #Make sure it only gets refreshed once
        LogWindowGraph = LogWindowCanvas()
        LogWindowGraph.show()
        self.UpdateScreen()
        
        
    ###########################################################################
    # Load next  logfile
    ###########################################################################
    def NextLogFile(self):
        data.arrLogFileIndex=(data.arrLogFileIndex+1)  % len(data.arrLogFiles)
        data.logfilename=data.arrLogFiles[data.arrLogFileIndex]
        self.ShowLogFile()


    ###########################################################################
    # Load last logfile
    ###########################################################################
    def LastLogFile(self):
        data.arrLogFileIndex=(data.arrLogFileIndex-1)  % len(data.arrLogFiles)
        data.logfilename=data.arrLogFiles[data.arrLogFileIndex]
        self.ShowLogFile()


        
    def ZoomIn(self):
        Zoom(+1)
        self.ui.bZoomOut.setEnabled(True)
        if(data.Xscale==0): self.ui.bZoomIn.setEnabled(False)
        else: self.ui.bZoomIn.setEnabled(True)
        self.update()

    def ZoomOut(self):
        r=Zoom(-1)
        self.ui.bZoomIn.setEnabled(True)
        if(data.Xscale==data.arrXscaleLen-1): self.ui.bZoomOut.setEnabled(False)
        else: self.ui.bZoomOut.setEnabled(True)
        self.update()
        
        

    def RaiseTrigger(self):   
        MoveTrigger(+1)
#        self.ui.bLowerTrigger.setEnabled(True)
#        if(data.trigger==data.maxtrigger): self.ui.bRaiseTrigger.setEnabled(False)
#        else: self.ui.bRaiseTrigger.setEnabled(True)
        self.update() 
        self.UpdateScreen()
        
    def LowerTrigger(self):     
        MoveTrigger(-1)
#        self.ui.bRaiseTrigger.setEnabled(True)
#        if(data.trigger==0): self.ui.bLowerTrigger.setEnabled(False)
#        else: self.ui.bLowerTrigger.setEnabled(True)
        self.update()
        self.UpdateScreen()
   

    def DeleteLogFile(self):
        reply = QtGui.QMessageBox.question(self, 'Delete Logfile?', "Are you sure you want to delete this record?", QtGui.QMessageBox.Yes, QtGui.QMessageBox.No)
        if reply == QtGui.QMessageBox.Yes:
            print "Delete logfile: "+data.logfilename
            os.remove(data.logfolder+data.logfilename)    
            data.arrLogFileIndex=(data.arrLogFileIndex+1)  % len(data.arrLogFiles)
            data.logfilename=data.arrLogFiles[data.arrLogFileIndex]
            self.ShowLogFile()



    def closeEvent(self, event):
        config.set('main', 'trigger', str(data.trigger))      
        LogWindow.close()
        StartWindow.show()











###########################################################################
# Class for Log Window
###########################################################################
class frmNoteWindow(QtGui.QWidget):
    def __init__(self, parent=None):
        QtGui.QWidget.__init__(self, parent)
        self.ui = Ui_NoteWindow()
        self.ui.setupUi(self)
        
        QtCore.QObject.connect(self.ui.bClose, QtCore.SIGNAL("clicked()"), self.NotesClose)
        QtCore.QObject.connect(self.ui.bSave, QtCore.SIGNAL("clicked()"), self.NotesSave)
        
        
    def SaveNotes(self):
        txt=""
        if(self.ui.cFeedback1.isChecked()==true):
            pass
            
    def NotesClose(self):
        StartWindow.show()
        NoteWindow.close()
        
    def NotesSave(self):
        NoteWindow.SaveNotes()
        NotesClose()

    def closeEvent(self, event):
        NoteWindow.close()
        StartWindow.show()











###########################################################################
# Class for drawing the CollectingWindowGraph
###########################################################################
class CollectingWindowCanvas(QtGui.QWidget):
    def __init__(self, parent=None):
        QtGui.QWidget.__init__(self, CollectingWindow)    
        self.setGeometry(9, 180, 782, data.Ysize+30)
    
    def paintEvent(self, event):
        showGraph(self,  QtGui)





    
    
###########################################################################
# Class for drawing the LogWindowGraph
###########################################################################
class LogWindowCanvas(QtGui.QWidget):
    def __init__(self, parent=None):
        QtGui.QWidget.__init__(self, LogWindow)    
        self.setGeometry(9, 100, 782, data.Ysize+30)
    
    def paintEvent(self, event):
        showGraph(self,  QtGui)
    
    
    

    
    
    

###########################################################################
# Now we can start it.
main()

