#include "xbmc.h"
#include "constants.h"
#include "genericnotify.h"

#include <QSettings>
#include <QTextStream>
#include <QNetworkReply>

// XBMC constants -- from https://github.com/xbmc/xbmc/blob/master/xbmc/guilib/Key.h
#define ACTION_MOVE_LEFT                1
#define ACTION_MOVE_RIGHT               2
#define ACTION_MOVE_UP                  3
#define ACTION_MOVE_DOWN                4
#define ACTION_SELECT_ITEM              7
#define ACTION_HIGHLIGHT_ITEM           8
#define ACTION_PARENT_DIR               9
#define ACTION_PAUSE                    12
#define ACTION_STOP                     13
#define ACTION_NEXT_ITEM                14
#define ACTION_PREV_ITEM                15
#define ACTION_FORWARD                  16 // Can be used to specify specific action in a window, Playback control is handled in ACTION_PLAYER_*
#define ACTION_REWIND                   17 // Can be used to specify specific action in a window, Playback control is handled in ACTION_PLAYER_*
#define ACTION_SHOW_GUI                 18 // toggle between GUI and movie or GUI and visualisation.
#define ACTION_STEP_FORWARD             20 // seek +1% in the movie. Can b used in videoFullScreen.xml window id=2005
#define ACTION_STEP_BACK                21 // seek -1% in the movie. Can b used in videoFullScreen.xml window id=2005
#define ACTION_BIG_STEP_FORWARD         22 // seek +10% in the movie. Can b used in videoFullScreen.xml window id=2005
#define ACTION_BIG_STEP_BACK            23 // seek -10% in the movie. Can b used in videoFullScreen.xml window id=2005
#define ACTION_NEXT_SUBTITLE            26 // switch to next subtitle of movie. Can b used in videoFullScreen.xml window id=2005
#define ACTION_SUBTITLE_DELAY_MIN       52 // Decrease subtitle/movie Delay. Can b used in videoFullScreen.xml window id=2005
#define ACTION_SUBTITLE_DELAY_PLUS      53 // Increase subtitle/movie Delay. Can b used in videoFullScreen.xml window id=2005
#define ACTION_AUDIO_DELAY_MIN          54 // Increase avsync delay. Can b used in videoFullScreen.xml window id=2005
#define ACTION_AUDIO_DELAY_PLUS         55 // Decrease avsync delay. Can b used in videoFullScreen.xml window id=2005
#define ACTION_AUDIO_NEXT_LANGUAGE      56 // Select next language in movie. Can b used in videoFullScreen.xml window id=2005
#define ACTION_PLAYER_PLAY              79 // Play current song. Unpauses song and sets playspeed to 1x. global action, can be used anywhere
#define ACTION_VOLUME_UP                88
#define ACTION_VOLUME_DOWN              89
#define ACTION_MUTE                     91
#define ACTION_CONTEXT_MENU             117 // pops up the context menu
#define ACTION_ENTER                    135

// 0xF000 -> 0xF200 is reserved for the keyboard; a keyboard press is either
#define KEY_VKEY 0xF000 // a virtual key/functional key e.g. cursor left
#define KEY_ASCII 0xF100 // a printable character in the range of TRUE ASCII (from 0 to 127) // FIXME make it clean and pure unicode! remove the need for KEY_ASCII
#define KEY_UNICODE 0xF200 // another printable character whose range is not included in this KEY code

Xbmc::Xbmc(QObject *parent) : QObject(parent)
{
    m_manager = new QNetworkAccessManager(this);
}

Xbmc::~Xbmc()
{
    delete m_manager;
}

void Xbmc::commandFinished()
{
    QNetworkReply* reply = qobject_cast<QNetworkReply *>(sender());
    if (reply) {
        if (reply->error() == QNetworkReply::NoError) {
            QTextStream stream(reply);
            QString msg = stream.readAll();
            qDebug("Xbmc::commandActionFinished: %s", qPrintable(msg));
        } else {
            notify::notify(reply->errorString());
        }
        reply->deleteLater();
    }
}

void Xbmc::actionRight()
{
    do_command_action(ACTION_MOVE_RIGHT);
    do_command_action(ACTION_STEP_FORWARD);
}

void Xbmc::actionLeft()
{
    do_command_action(ACTION_MOVE_LEFT);
    do_command_action(ACTION_STEP_BACK);
}

void Xbmc::actionUp()
{
    do_command_action(ACTION_MOVE_UP);
    do_command_action(ACTION_BIG_STEP_FORWARD);
}

void Xbmc::actionDown()
{
    do_command_action(ACTION_MOVE_DOWN);
    do_command_action(ACTION_BIG_STEP_BACK);
}

void Xbmc::actionMute()
{
    do_command_action(ACTION_MUTE);
}

void Xbmc::actionVolumeUp()
{
    do_command_action(ACTION_VOLUME_UP);
}

void Xbmc::actionVolumeDown()
{
    do_command_action(ACTION_VOLUME_DOWN);
}

void Xbmc::actionNextSubtitle()
{
    do_command_action(ACTION_NEXT_SUBTITLE);
}

void Xbmc::actionNextLanguage()
{
    do_command_action(ACTION_AUDIO_NEXT_LANGUAGE);
}

void Xbmc::actionPlay()
{
    do_command_action(ACTION_PLAYER_PLAY);
}

void Xbmc::actionSelect()
{
    do_command_action(ACTION_SELECT_ITEM);
}

void Xbmc::actionStop()
{
    do_command_action(ACTION_STOP);
}

void Xbmc::actionShowGui()
{
    do_command_action(ACTION_SHOW_GUI);
}

void Xbmc::actionSendKeyEsc()
{
    do_command_send_key(KEY_ASCII + 0x1B); // ESC
}

void Xbmc::actionContextMenu()
{
    do_command_action(ACTION_CONTEXT_MENU);
}

void Xbmc::do_command_send_key(int key)
{
    do_command1("SendKey", key);
}

void Xbmc::do_command_action(int action)
{
    do_command1("Action", action);
}

void Xbmc::do_command1(const QString &command, int id)
{
    QSettings settings;
    QString host = settings.value(SETUP_XBMC_SERVER, SETUP_XBMC_SERVER_DEFAULT).toString();
    int port = settings.value(SETUP_XBMC_PORT, SETUP_XBMC_PORT_DEFAULT).toInt();
    bool requires_authentication = settings.value(SETUP_XBMC_REQUIRES_AUTHENTICATION, SETUP_XBMC_REQUIRES_AUTHENTICATION_DEFAULT).toBool();

    QUrl url;
    url.setScheme("http");
    url.setHost(host);
    url.setPort(port);
    url.setPath("/xbmcCmds/xbmcHttp");

    if (requires_authentication) {
        QString username = settings.value(SETUP_XBMC_USERNAME, SETUP_XBMC_USERNAME_DEFAULT).toString();
        QString password = settings.value(SETUP_XBMC_PASSWORD, SETUP_XBMC_PASSWORD_DEFAULT).toString();
        qDebug("authentication required: %s : %s", qPrintable(username), qPrintable(password));
        url.setUserName(username);
        url.setPassword(password);
    }

    QList<QPair<QString, QString> > querry;
    querry.append(QPair<QString, QString>(QString("command"), QString("%1(%2)").arg(command).arg(id)));
    url.setQueryItems(querry);

//    qDebug("executing command: %s", qPrintable(url.toString()));

    QNetworkRequest request;
    request.setUrl(url);

    QNetworkReply *reply = m_manager->get(request);
    connect(reply, SIGNAL(finished()), this, SLOT(commandFinished()));
}
