// checksum 0xfd0b version 0x20001
/*
  This file was generated by the Mobile Qt Application wizard of Qt Creator.
  MainWindow is a convenience class containing mobile device specific code
  such as screen orientation handling.
  It is recommended not to modify this file, since newer versions of Qt Creator
  may offer an updated version of it.
*/

#include "mainwindow.h"
#include "ui_mainwindow.h"

#include "setupdialog.h"
#include "xbmc.h"
#include "constants.h"

#include <QSettings>
#include <QCoreApplication>

#if defined(Q_OS_SYMBIAN) && defined(ORIENTATIONLOCK)
#include <eikenv.h>
#include <eikappui.h>
#include <aknenv.h>
#include <aknappui.h>
#endif // Q_OS_SYMBIAN && ORIENTATIONLOCK

MainWindow::MainWindow(QWidget *parent)
    : QMainWindow(parent), m_ui(new Ui::MainWindow)
{
    m_ui->setupUi(this);
    m_xbmc = new Xbmc(this);

#ifdef Q_WS_MAEMO_5
    m_screenSaver = 0;
#endif

    setupScreen();
}

MainWindow::~MainWindow()
{
#ifdef Q_WS_MAEMO_5
    delete m_screenSaver;
#endif

    delete m_xbmc;
    delete m_ui;
}

void MainWindow::setupScreen()
{
#ifdef Q_WS_MAEMO_5
    QSettings settings;

    bool disable_screensaver = settings.value(SETUP_SCREEN_DISABLE_SCREENSAVER, SETUP_SCREEN_DISABLE_SCREENSAVER_DEFAULT).toBool();

    if (disable_screensaver) {
        if (m_screenSaver == 0) {
            m_screenSaver = new QSystemScreenSaver(this);
            bool result = m_screenSaver->setScreenSaverInhibit();
            qDebug("disabling the screensaver: %s", (result?"ok":"failed"));
        }
    } else {
        if (m_screenSaver) {
            delete m_screenSaver;
            m_screenSaver = 0;
            qDebug("screensaver enabled");
        }
    }
#endif
}

void MainWindow::setOrientation(ScreenOrientation orientation)
{
#ifdef Q_OS_SYMBIAN
    if (orientation != ScreenOrientationAuto) {
#if defined(ORIENTATIONLOCK)
        const CAknAppUiBase::TAppUiOrientation uiOrientation =
                (orientation == ScreenOrientationLockPortrait) ? CAknAppUi::EAppUiOrientationPortrait
                    : CAknAppUi::EAppUiOrientationLandscape;
        CAknAppUi* appUi = dynamic_cast<CAknAppUi*> (CEikonEnv::Static()->AppUi());
        TRAPD(error,
            if (appUi)
                appUi->SetOrientationL(uiOrientation);
        );
        Q_UNUSED(error)
#else // ORIENTATIONLOCK
        qWarning("'ORIENTATIONLOCK' needs to be defined on Symbian when locking the orientation.");
#endif // ORIENTATIONLOCK
    }
#elif defined(Q_WS_MAEMO_5)
    Qt::WidgetAttribute attribute;
    switch (orientation) {
    case ScreenOrientationLockPortrait:
        attribute = Qt::WA_Maemo5PortraitOrientation;
        break;
    case ScreenOrientationLockLandscape:
        attribute = Qt::WA_Maemo5LandscapeOrientation;
        break;
    case ScreenOrientationAuto:
    default:
        attribute = Qt::WA_Maemo5AutoOrientation;
        break;
    }
    setAttribute(attribute, true);
#else // Q_OS_SYMBIAN
    Q_UNUSED(orientation);
#endif // Q_OS_SYMBIAN
}

void MainWindow::showExpanded()
{
#ifdef Q_OS_SYMBIAN
    showFullScreen();
#elif defined(Q_WS_MAEMO_5) || defined(Q_WS_MAEMO_6)
    showMaximized();
#else
    show();
#endif
}

void MainWindow::on_actionSetup_triggered()
{
    SetupDialog dialog;
    dialog.load();
    if(dialog.exec() == QDialog::Accepted) {
        dialog.save();
    }

    setupScreen();
}

void MainWindow::on_rightBtn_clicked()
{
    m_xbmc->actionRight();
}

void MainWindow::on_leftBtn_clicked()
{
    m_xbmc->actionLeft();
}

void MainWindow::on_upBtn_clicked()
{
    m_xbmc->actionUp();
}

void MainWindow::on_downBtn_clicked()
{
    m_xbmc->actionDown();
}

void MainWindow::on_playBtn_clicked()
{
    m_xbmc->actionPlay();
}

void MainWindow::on_muteBtn_clicked()
{
    m_xbmc->actionMute();
}

void MainWindow::on_volumeUpBtn_clicked()
{
    m_xbmc->actionVolumeUp();
}

void MainWindow::on_volumeDownBtn_clicked()
{
    m_xbmc->actionVolumeDown();
}

void MainWindow::on_nextSubtitleBtn_clicked()
{
    m_xbmc->actionNextSubtitle();
}

void MainWindow::on_nextLanguageBtn_clicked()
{
    m_xbmc->actionNextLanguage();
}

void MainWindow::on_selectButton_clicked()
{
    m_xbmc->actionSelect();
}

void MainWindow::on_stopBtn_clicked()
{
    m_xbmc->actionStop();
}

void MainWindow::on_showGuiBtn_clicked()
{
    m_xbmc->actionShowGui();
}

void MainWindow::on_contextMenuBtn_clicked()
{
    m_xbmc->actionContextMenu();
}

void MainWindow::on_sendEscKeyBtn_clicked()
{
    m_xbmc->actionSendKeyEsc();
}
