#ifndef TIMEDSTATE_H
#define TIMEDSTATE_H

#include <QBasicTimer>
#include <QElapsedTimer>

#include "namedstate.h"

class TimedState : public NamedState
{
    Q_OBJECT

public:
    TimedState(const QString& name, int timeout, QState* parent = 0);
    void setTimeout(int timeout);

signals:
    void timeout();

private:
    void onEntry(QEvent *event);
    void onExit(QEvent *event);
    void timerEvent(QTimerEvent *);

    QBasicTimer m_timer;
    QElapsedTimer m_elapsedTimer;
    int m_timeout;
};

#endif // TIMEDSTATE_H
