#include "settingswidget.h"
#include "ui_settingswidget.h"
#include "qtcolorcombobox.h"
#include <QSettings>
#include <QScrollArea>
#include <QVariant>



SettingsWidget::SettingsWidget(QWidget *parent) :
    QWidget(parent),
    ui(new Ui::SettingsWidget)
{
    ui->setupUi(this);



    this->setBaseSize(580,350);

    QSettings *oSettings;
    oSettings = new QSettings("janbergmann", "simplenotewidget");
    QColor cldefault = oSettings->value("bgcolor", QColor(255,255,0)).value<QColor>();
    QColor cltextedit = oSettings->value("txtcolor", QColor(0,0,0)).value<QColor>();
    int iTransparency = oSettings->value("bgcoloralpha", int(180)).toInt();

    int fontSizeIndex = oSettings->value("fontsize", int(3)).toInt();
    QString fontFamilyName = oSettings->value("fontfamily", "Nokia Sans SemiBold").toString();

    bool bSysColors = oSettings->value("syscolors", false).toBool();





    int iIndex = 0;
    int iCount = 0;
    for(int i=10; i < 260; i = i + 10)
    {
         QVariant v = i;
         ui->cbtransparency->addItem(v.toString());
         if (i==iTransparency)
         {
             iIndex = iCount;
         }
         iCount++;

    }

    ui->cbtransparency->setCurrentIndex(iIndex);

    ui->cbFontSize->addItem("6");
    ui->cbFontSize->addItem("8");
    ui->cbFontSize->addItem("10");
    ui->cbFontSize->addItem("12");
    ui->cbFontSize->addItem("16");
    ui->cbFontSize->addItem("24");
    ui->cbFontSize->addItem("32");
    ui->cbFontSize->setCurrentIndex(fontSizeIndex);

    ui->fcbFont->setCurrentFont(QFont(fontFamilyName));





    cbBG = new QtColorComboBox(this);
    cbBG->setGeometry(250,150,211,61);
    cbBG->setStandardColors();
    cbBG->setCurrentColor(cldefault);
    cbBG->setColorDialogEnabled(false);
    cbBG->setEditText("");


    cbtxt = new QtColorComboBox(this);
    cbtxt->setGeometry(250,220,211,61);
    cbtxt->setStandardColors();
    cbtxt->setCurrentColor(cltextedit);
    cbtxt->setColorDialogEnabled(false);



    ui->chSysColors->setChecked(bSysColors);
}

SettingsWidget::~SettingsWidget()
{
    delete ui;
}

void SettingsWidget::changeEvent(QEvent *e)
{
    QWidget::changeEvent(e);
    switch (e->type()) {
    case QEvent::LanguageChange:
        ui->retranslateUi(this);
        break;
    default:
        break;
    }
}


void SettingsWidget::DoSave()
{
    // if (color.isValid())

      QSettings *oSettings;
      oSettings = new QSettings("janbergmann", "simplenotewidget");

      QColor cldefault = cbBG->currentColor();
      QColor cltextedit = cbtxt->currentColor();


      oSettings->setValue("bgcoloralpha",ui->cbtransparency->currentText());
      oSettings->setValue("bgcolor",cldefault);
      oSettings->setValue("txtcolor",cltextedit);



      oSettings->setValue("fontfamily",ui->fcbFont->currentText());
      oSettings->setValue("fontsize",ui->cbFontSize->currentIndex());


      oSettings->setValue("syscolors",ui->chSysColors->checkState());


      //delete oSettings;


      this->close();
}

void SettingsWidget::on_chSysColors_toggled(bool checked)
{
    cbBG->setEnabled(!checked);
    cbtxt->setEnabled(!checked);
}
