#include "mainwindow.h"
#include "ui_mainwindow.h"
#include "dialog.h"
#include "settingsdlg.h"
#include <QDateTime>
#include <QMessageBox>
#include <QStyleOption>
#include <QCoreApplication>
#include <QMovie>
#include <QDialog>
#include <QSettings>
#include <QVBoxLayout>
#include <QScrollArea>
#include <QWidget>


#ifdef Q_WS_HILDON
    #include <X11/Xlib.h>
    #include <X11/Xatom.h>
    #include <QtGui/QX11Info>
#endif






MainWindow::MainWindow(QWidget *parent) :
    QMainWindow(0, Qt::FramelessWindowHint),
    ui(new Ui::MainWindow)
{

    ui->setupUi(this);
    SetupThisUi();
}



void MainWindow::showEvent(QShowEvent* event)
{


}


void MainWindow::showSettingsDialog()
{
    settingsdlg *w;
    w = new settingsdlg(0);
    w->exec();
    SetupThisUi();
}



bool MainWindow::eventFilter(QObject *o, QEvent *e )
{
  if (e->type()==3)
  {
        Dialog *w;
        w = new Dialog(0);
        w->exec();
        SetupThisUi();
        //delete w;
  }
  return false;
}


void MainWindow::SetupThisUi()
{

    QSettings *oSettings;
    oSettings = new QSettings("janbergmann", "simplenotewidget");
    QColor cldefault = oSettings->value("bgcolor", QColor(255,255,0)).value<QColor>();
    QColor cltextedit = oSettings->value("txtcolor", QColor(0,0,0)).value<QColor>();
    int bgcoloralpha = oSettings->value("bgcoloralpha", int(180)).toInt();   
    int fontSizeIndex = oSettings->value("fontsize", int(3)).toInt();
    QString fontFamilyName = oSettings->value("fontfamily", "Nokia Sans SemiBold").toString();



    bool bSysColors = oSettings->value("syscolors", false).toBool();
    if (bSysColors == true)
    {
        //QApplication::palette().color(QPalette::);
        //QStyle CurrentStyle = QApplication::style();

        cldefault  = QApplication::palette().color(QPalette::Background);
        cltextedit = QApplication::palette().color(QPalette::Foreground);
        QString SysFont =  QApplication::font().toString();



    }

    cldefault.setAlpha(bgcoloralpha);



    switch(fontSizeIndex)
    {
     case 0: fontSizeIndex = 6;
             break;
     case 1: fontSizeIndex = 8;
             break;
     case 2: fontSizeIndex = 10;
             break;
     case 3: fontSizeIndex = 12;
             break;
     case 4: fontSizeIndex = 16;
             break;
     case 5: fontSizeIndex = 24;
             break;
     case 6: fontSizeIndex = 32;
    }

    QPalette pal = this->palette();
    this->setAttribute(Qt::WA_TranslucentBackground);
    this->setAttribute(Qt::WA_NoSystemBackground, false);

    pal.setColor(QPalette::Window, cldefault);
    this->setPalette(pal);
    this->ensurePolished();
    this->setAttribute(Qt::WA_StyledBackground, false);


    QSize oMovSize;
    oMovSize.setHeight(21);
    oMovSize.setWidth(21);
    ui->lbicon->setText("");
    QMovie *movie = new QMovie(":/img/res/pin.png");
    movie->setScaledSize(oMovSize);
    movie->setBackgroundColor(Qt::transparent);
    ui->lbicon->setMovie(movie);
    ui->lbicon->show();
    movie->start();



    ui->teMain->setFrameShadow(QFrame::Plain);
    ui->teMain->setFrameShape(QFrame::NoFrame);
    ui->teMain->setPalette(QPalette(cltextedit,cldefault,cldefault,cltextedit,cltextedit,cltextedit,cldefault,cldefault,cldefault));
    ui->teMain->setFontFamily(fontFamilyName);
    ui->teMain->setFontPointSize(fontSizeIndex);
    ui->teMain->setWordWrapMode(QTextOption::WrapAtWordBoundaryOrAnywhere);
    ui->teMain->setHorizontalScrollBarPolicy(Qt::ScrollBarAlwaysOff);
    ui->teMain->setReadOnly(true);
	
    ui->teMain->installEventFilter( this );


    QVariant vRed (cltextedit.red());
    QVariant vGreen (cltextedit.green());
    QVariant vBlue (cltextedit.blue());

    ui->teMain->setStyleSheet( "background-color: rgba( " + vRed.toString() + ", " + vGreen.toString() +  ", " + vBlue.toString() + ", 0% );" );
    ui->teMain->setPalette(QPalette(cltextedit,cldefault,cldefault,cltextedit,cltextedit,cltextedit,cldefault,cldefault,cldefault));
    //ui->teMain->repaint();



    ui->lblDate->setLayoutDirection(Qt::RightToLeft);
    ui->lblDate->setPalette(QPalette(cltextedit,cltextedit,cltextedit,cltextedit,cltextedit,cltextedit,cldefault,cldefault,cldefault));
    ui->lblDate->setFont(QFont(fontFamilyName,10,10));



#ifdef Q_WS_HILDON
       this->setProperty("FingerScrollable", true);
       ui->teMain->setFocusPolicy(Qt::StrongFocus);
       this->setFocusPolicy(Qt::StrongFocus);
       ui->teMain->setProperty("FingerScrollable", true);
#endif

   QString sFirstRun = oSettings->value("notedate","").toString();
   if (sFirstRun == "")
   {
       ui->teMain->setText("please press twice for the edit mode");
       ui->lblDate->setText(QDateTime::currentDateTime().toString("dd.MM.yyyy   HH:mm"));

   } else
   {
       ui->teMain->setText(oSettings->value("note","").toString());
       ui->lblDate->setText(oSettings->value("notedate",QDateTime::currentDateTime().toString("dd.MM.yyyy   HH:mm")).toString());
   }

   //delete oSettings;


   ui->centralWidget->repaint();
   this->repaint();

}

void MainWindow::paletteChange(const QPalette & oldPalette)
{
  Q_UNUSED( oldPalette );
  this->setPalette( palette() );
  SetupThisUi();
}


MainWindow::~MainWindow()
{
    delete ui;
}

void MainWindow::changeEvent(QEvent *e)
{
    QMainWindow::changeEvent(e);
    switch (e->type()) {
    case QEvent::LanguageChange:
        ui->retranslateUi(this);
        break;
    default:
        break;
    }
}


