'''
Created on 23/07/2012


    Permission is hereby granted, free of charge, to any person obtaining a copy
    of this software and associated documentation files (the "Software"), to deal
    in the Software without restriction, including without limitation the rights
    to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
    copies of the Software, and to permit persons to whom the Software is
    furnished to do so, subject to the following conditions:

    The above copyright notice and this permission notice shall be included in
    all copies or substantial portions of the Software.

    THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
    IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
    FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
    AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
    LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
    OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
    THE SOFTWARE.

Clase con la logica del juego

@author: Andros Fenollosa
@contact: correoandros@gmail.com
'''
import random, pygame, time
from threading import Thread

class Dominio_class(Thread):
    
    def __init__(self):
        Thread.__init__(self)
        pygame.init()
        pygame.mixer.init()
        self.numRecord = 0
        self.bJugando = False
        self.limite = 999
        self.listaOrd = list(range(self.limite))
        self.listaJug =  list(range(self.limite))
        self.soundRojo = '/opt/simonKnowsMaemo/sounds/simonSound1.wav'
        self.soundVerde = '/opt/simonKnowsMaemo/sounds/simonSound2.wav'
        self.soundAzul = '/opt/simonKnowsMaemo/sounds/simonSound3.wav'
        self.soundAmarillo = '/opt/simonKnowsMaemo/sounds/simonSound4.wav'
        self.soundStart = '/opt/simonKnowsMaemo/sounds/start.wav'
        self.soundError = '/opt/simonKnowsMaemo/sounds/error.wav'
        self.JugadorPulsa = False
        self.botonEntrante = 0
        self.JugadorNumPulsado = 0
        self.tiempCpuBoton = 0.5
        
        self.bAmarillo = False
        self.bAzul = False
        self.bRojo = False
        self.bVerde = False
        self.bStart = False
        
    # Reinicia el juego
    def __PararJuego(self):
        self.numRecord = 0
        self.bJugando = False
        
    # Gestiona la logica del juego
    def __logica(self):
        while True:
            #Prepara el juego
            if self.bJugando == False and self.botonEntrante == 5:
                self.bJugando = True
                #Genera el ordenador la secuencia de colores: 1 - Amarillo, 2 - Azul, 3 - Rojo, 4 - Verde
                for i in range(self.limite):
                    numNueSecu = random.randint(1, 4)
                    self.listaOrd[i] = numNueSecu
                self.JugadorPulsa = False
                #Empieza juego
                while self.bJugando == True and self.verificarBotonesPulsados() == True :
                    time.sleep(self.tiempCpuBoton)
                    self.numRecord += 1
                    self.pulsarBotones(self.listaOrd, self.numRecord)
                    #Recoge convinacion del jugador
                    while self.numRecord > self.JugadorNumPulsado and self.verificarBotonesPulsados() == True :
                        if self.JugadorPulsa == True:
                            self.listaJug[self.JugadorNumPulsado] = self.botonEntrante
                            self.JugadorPulsa = False
                            self.JugadorNumPulsado += 1
                    if self.verificarBotonesPulsados() == True:
                        self.JugadorNumPulsado = 0
                    else:
                        self.reproducirSonido(self.soundError)
                #Juego terminado
                self.__PararJuego()
                    
    # Metodo que comprueba si el numero de botones pulsados por el usuario se corresponde con los del ordenador    
    def verificarBotonesPulsados(self):
        bFinal = True
        if self.bJugando == True and self.numRecord > 1:
            for i in range(self.numRecord - 1):
                if self.listaJug[i] != self.listaOrd[i] :
                    bFinal = False
        return bFinal
                    
    # Recoge el boton pulsado        
    def recogerBoton(self, inBoton):
        self.botonEntrante = self.averiguarNumBoton(inBoton)
        self.JugadorPulsa = True
        self.reproducirSonidoBoton(self.averiguarNumBoton(inBoton))
    
    #Reproduce un sonido
    def reproducirSonido(self, inFile):
        pygame.mixer.Sound(inFile).play()
        #pygame.mixer.music.play()
    
    # Asigna un numero al boton: 1 - Amarillo, 2 - Azul, 3 - Rojo, 4 - Verde, 5 - Start
    def averiguarNumBoton(self, inBoton):
        if inBoton == "pushAmarillo":
            return 1
        elif inBoton == "pushAzul":
            return 2
        elif inBoton == "pushRojo":
            return 3
        elif inBoton == "pushVerde":
            return 4
        elif inBoton == "pushButton":
            return 5
        
    # Metodo que pulsa los botones por orden de un array entrante, ignorando tamanyo y usando iniLimit 
    def pulsarBotones(self, inaListB, iniLimit):
        if self.verificarBotonesPulsados() == True :
            for i in range(iniLimit):
                time.sleep(self.tiempCpuBoton)
                self.reproducirSonidoBoton(inaListB[i])
                if inaListB[i] == 1:
                    self.bAmarillo = True
                elif inaListB[i] == 2:
                    self.bAzul = True
                elif inaListB[i] == 3:
                    self.bRojo = True
                elif inaListB[i] == 4:
                    self.bVerde = True
    
    def reproducirSonidoBoton(self, inBoton): 
        if 1 == inBoton :
            self.reproducirSonido(self.soundAmarillo)
        elif 2 == inBoton :
            self.reproducirSonido(self.soundAzul)
        elif 3 == inBoton :
            self.reproducirSonido(self.soundRojo)
        elif 4 == inBoton :
            self.reproducirSonido(self.soundVerde)
        elif 5 == inBoton :
            self.reproducirSonido(self.soundStart)   
    
    def run(self):
        self.__logica()
