#include "monthdata.h"
#include <QListIterator>

MonthData::MonthData(QDate date,
                     Account *account,
                     QObject *parent)
        : ExpensesGraphModel(parent)
{
        _date = date;
        _account = account;
        _budget = account->budget();
        _dailyExpense = _budget / _date.daysInMonth();
        _maxExpense = 0;
        _totalExpense = 0;
        _summary.resize(_date.daysInMonth());
        _summary.fill(0);
        _expenses = new QStandardItemModel(0,5);

#ifndef Q_WS_MAEMO_5
        /* add headers to the model */
        QStandardItem *header;
        header = new QStandardItem (tr("Day"));
        header->setTextAlignment(Qt::AlignCenter);
        _expenses->setHorizontalHeaderItem(1, header);
        header = new QStandardItem (tr("Amount"));
        header->setTextAlignment(Qt::AlignCenter);
        _expenses->setHorizontalHeaderItem(2, header);
        header = new QStandardItem (tr("Item"));
        header->setTextAlignment(Qt::AlignCenter);
        _expenses->setHorizontalHeaderItem(3, header);
        header = new QStandardItem (tr("Description"));
        header->setTextAlignment(Qt::AlignCenter);
        _expenses->setHorizontalHeaderItem(4, header);
#endif
}

MonthData::~MonthData()
{
        delete _expenses;
}
int MonthData::year()
{
        return _date.year();
}

Account* MonthData::account()
{
        return _account;
}

int MonthData::month()
{
        return _date.month();
}

int MonthData::days()
{
        return _date.daysInMonth();
}

double MonthData::budget()
{
        return _budget;
}

void MonthData::setBudget(double budget)
{
        _budget = budget;
        _dailyExpense = _budget / _date.daysInMonth();

        emit budgetChanged();
}

void MonthData::addExpense(Expense *e)
{
        _summary[e->day() - 1] += e->amount();
        _totalExpense += e->amount();
        if (_summary[e->day() - 1] > _maxExpense) {
                _maxExpense = _summary[e->day() - 1];
        }

        QStandardItem *item;
        QList<QStandardItem*> row;
        item = new QStandardItem (QString("%1").arg(e->id()));
        item->setTextAlignment(Qt::AlignCenter);
        item->setEditable(false);
        row.append(item);
        item = new QStandardItem (QString("%1").arg(e->day()));
        item->setTextAlignment(Qt::AlignCenter);
        item->setEditable(false);
        row.append(item);
        item = new QStandardItem (QString("%1").arg(e->amount()));
        item->setTextAlignment(Qt::AlignCenter);
        item->setEditable(false);
        row.append(item);
        item = new QStandardItem (e->concept());
        item->setTextAlignment(Qt::AlignLeft | Qt::AlignVCenter);
        item->setEditable(false);
        row.append(item);
        item = new QStandardItem (e->description());
        item->setTextAlignment(Qt::AlignLeft | Qt::AlignVCenter);
        item->setEditable(false);
        row.append(item);
        _expenses->appendRow(row);

        delete e;

        if (notifyExpenses) {
                emit expensesChanged();
        } else {
                pendingNotifications = true;
        }
}

QStandardItemModel* MonthData::expenses()
{
        return _expenses;
}

double MonthData::maxExpense()
{
        return _maxExpense;
}

double MonthData::totalExpense()
{
        return _totalExpense;
}

QDate MonthData::next()
{
        return(_date.addMonths(1));
}

QDate MonthData::previous()
{
        return(_date.addMonths(-1));
}

bool MonthData::isCurrent()
{
        return (_date.year() == QDate::currentDate().year()
                && _date.month() == QDate::currentDate().month());
}

QDate MonthData::date()
{
        return _date;
}

double MonthData::value(int index)
{
        return _summary[index];
}

void MonthData::clear()
{
        _summary.fill(0);
        _expenses->removeRows(0, _expenses->rowCount());
        _maxExpense = 0;
        _totalExpense = 0;

        if (notifyExpenses) {
                emit expensesChanged();
        } else {
                pendingNotifications = true;
        }
}

int MonthData::xDivisions()
{
        return _date.daysInMonth();
}

int MonthData::label(int index)
{
        return index + 1;
}

double MonthData::reference(int i)
{
        return _dailyExpense;
}

double MonthData::maxBudget()
{
        return _dailyExpense;
}
