#include <QHBoxLayout>
#include <QVBoxLayout>
#include <QDate>
#include <QAction>
#include <QMenuBar>
#include <QMaemo5InformationBox>
#include "mainwindowmaemo.h"

#define GESTURE_MIN_DISTANCE 50

MainWindowMaemo::MainWindowMaemo(QWidget *parent)
        : MainWindow(parent)
{
        pressXPosition = 0;
        month = NULL;

        setAttribute(Qt::WA_Maemo5StackedWindow);

        QVBoxLayout *vBox = new QVBoxLayout(this);

        setWindowTitle(tr("Account: none selected"));

        dateLabel = new QLabel("");
        vBox->addWidget(dateLabel, 0, Qt::AlignCenter);

        QHBoxLayout *hBox = new QHBoxLayout();
        vBox->addLayout(hBox, 1);

        graph = new ExpensesGraph();
        hBox->addWidget(graph, 1);

        QVBoxLayout *form = new QVBoxLayout();
        hBox->addLayout(form, 0);

        form->addStretch(2);

        form->addWidget(new QLabel(tr("Budget")), 0);
        budgetLabel = new QLabel("");
        form->addWidget(budgetLabel, 0, Qt::AlignRight | Qt::AlignVCenter);

        form->addWidget(new QLabel(tr("Expenses")), 0);
        totalLabel = new QLabel("");
        form->addWidget(totalLabel, 0, Qt::AlignRight | Qt::AlignVCenter);

        form->addWidget(new QLabel(tr("Difference")), 0);
        savedLabel = new QLabel("");
        form->addWidget(savedLabel, 0, Qt::AlignRight | Qt::AlignVCenter);

        form->addStretch(2);

        QPushButton *button2 = new QPushButton(tr("Add expense"));
        form->addWidget(button2, 1);
        connect (button2, SIGNAL(clicked()), this, SIGNAL(addExpenseSelected()));

        QMenuBar *menubar = new QMenuBar(this);
        menubar->addAction(tr("Accounts"), this, SIGNAL(accountsSelected()));
        menubar->addAction(tr("Items"), this, SIGNAL(conceptsSelected()));
        budgetAction = menubar->addAction(tr("Budget"), this, SIGNAL(budgetSelected()));
        expensesAction = menubar->addAction(tr("Expenses"), this, SIGNAL(expensesSelected()));
        scheduledAction = menubar->addAction(tr("Scheduled"), this, SIGNAL(scheduledSelected()));
        summaryAction = menubar->addAction(tr("Summary"), this, SIGNAL(summarySelected()));

        budgetAction->setEnabled(false);
        expensesAction->setEnabled(false);
        scheduledAction->setEnabled(false);
        summaryAction->setEnabled(false);
}

QSize MainWindowMaemo::minimumSizeHint() const
{
        return QSize(800, 454);
}

QSize MainWindowMaemo::sizeHint() const
{
        return QSize(800, 454);
}

void MainWindowMaemo::setMonthData(MonthData *data)
{
        month = data;
        /* set data to the graph as well */
        graph->setModel(data);
        connect(month, SIGNAL(expensesChanged()), this, SLOT(expensesChanged()));
        connect(month, SIGNAL(budgetChanged()), this, SLOT(budgetChanged()));

        updateAll();

        budgetAction->setEnabled(true);
        expensesAction->setEnabled(true);
        scheduledAction->setEnabled(true);
        summaryAction->setEnabled(true);
}

void MainWindowMaemo::updateAccountLabel()
{
        setWindowTitle(tr("Account: %1").arg(month->account()->name()));
}

void MainWindowMaemo::expensesChanged()
{
        updateTotalLabel();
        updateSavedLabel();
        updateGraph();
}

void MainWindowMaemo::budgetChanged()
{
        updateBudgetLabel();
        updateSavedLabel();
        updateGraph();
}

void MainWindowMaemo::updateAll()
{
        updateAccountLabel();
        updateDateLabel();
        updateBudgetLabel();
        updateTotalLabel();
        updateSavedLabel();
        updateGraph();
}

void MainWindowMaemo::updateDateLabel()
{
        QString label = QString("<b>%1 %2</b>").arg(QDate::longMonthName(month->month())).arg(month->year());
        if (graph->accumulated()) {
                label.append(QString("   (%1)").arg(tr("accumulated view")));
        } else {
                label.append(QString("   (%1)").arg(tr("daily view")));
        }
        dateLabel->setText(label);
}

void MainWindowMaemo::updateBudgetLabel()
{
        budgetLabel->setNum(month->budget());
}

void MainWindowMaemo::updateTotalLabel()
{
        totalLabel->setNum(month->totalExpense());
}

void MainWindowMaemo::updateSavedLabel()
{
        double diff;

        diff = month->budget() - month->totalExpense();

        if (diff >= 0) {
                savedLabel->setText(QString("<font color='green'><b>+%1</b></font>").arg(diff));
        } else {
                savedLabel->setText(QString("<font color='red'><b>%1</b></font>").arg(diff));
        }
}

void MainWindowMaemo::updateGraph()
{
        graph->repaint();
}

void MainWindowMaemo::mousePressEvent(QMouseEvent *event)
{
        pressXPosition = event->x();
}

void MainWindowMaemo::mouseReleaseEvent(QMouseEvent *event)
{
        if (qAbs(event->x() - pressXPosition) > GESTURE_MIN_DISTANCE) {
                if (event->x() > pressXPosition) {
                        emit previousMonth();
                } else {
                        emit nextMonth();
                }
        } else {
                if (month != NULL) {
                        graph->changeView();
                        updateDateLabel();
                }
        }
}

void MainWindowMaemo::message(const QString& text)
{
        QMaemo5InformationBox::information(this, text);
}
