#ifndef EXPENSESGRAPHMODEL_H
#define EXPENSESGRAPHMODEL_H

#include <QObject>

class ExpensesGraphModel : public QObject
{
        Q_OBJECT
 public:
        ExpensesGraphModel(QObject *parent = 0);

        virtual double budget() = 0;
        virtual double totalExpense() = 0;
        virtual double maxExpense() = 0;
        virtual double maxBudget() = 0;
        virtual bool isCurrent() = 0;
        virtual int xDivisions() = 0;
        virtual double reference(int i) = 0;
        virtual double value(int i) = 0;
        virtual int label(int i) = 0;

        void enableExpenseNotifications(bool enable);

 signals:
        void expensesChanged();
        void budgetChanged();

 protected:
        bool notifyExpenses;
        bool pendingNotifications;
};

#endif
