#include "accountdetailsdialogdesktop.h"
#include "confirmationdialogdesktop.h"
#include <QHBoxLayout>
#include <QFormLayout>
#include <QVBoxLayout>
#include <QDialogButtonBox>
#include <QDebug>
#include <QPushButton>
#include <QMessageBox>

AccountDetailsDialogDesktop::AccountDetailsDialogDesktop(QStandardItemModel *accounts,
                                                         int row,
                                                         Account *activeAccount,
                                                         QWidget *parent,
                                                         Qt::WindowFlags f)
        : AccountDetailsDialog (parent, f)
{
        _row = row;
        setWindowTitle(tr("Account details"));

        QVBoxLayout *layout = new QVBoxLayout(this);

        QFormLayout *form = new QFormLayout ();
        layout->addLayout (form, 0);

        accountId = accounts->item(row, 0)->text().toInt();
        accountName = accounts->item(row, 1)->text();
        accountBudget = accounts->item(row, 2)->text().toDouble();

        QLabel *name = new QLabel();
        name->setText(accountName);
        form->addRow (new QLabel(tr("Name")), name);

        _budget = new QLineEdit();
        _budget->setText(accounts->item(row, 2)->text());
        form->addRow (new QLabel(tr("Default budget")), _budget);

        box = new QDialogButtonBox (QDialogButtonBox::Cancel, Qt::Horizontal);
        if (activeAccount->id() != accountId) {
                QPushButton *activateButton = new QPushButton(tr("Select"));
                box->addButton(activateButton, QDialogButtonBox::ActionRole);
                connect(activateButton, SIGNAL(clicked()), this, SLOT(activateClicked()));
        }

        QPushButton *saveButton = new QPushButton(tr("Save"));
        box->addButton(saveButton, QDialogButtonBox::ActionRole);

        if (activeAccount->id() != accountId) {
                QPushButton *deleteButton = new QPushButton(tr("Delete"));
                box->addButton(deleteButton, QDialogButtonBox::ActionRole);
                connect(deleteButton, SIGNAL(clicked()), this, SLOT(deleteClicked()));
        }

        layout->addWidget (box, 0, Qt::AlignBottom);

        connect(box, SIGNAL(rejected()), this, SLOT(reject()));
        connect(saveButton, SIGNAL(clicked()), this, SLOT(saveClicked()));
}

AccountDetailsDialogDesktop::AccountDetailsDialogDesktop(QWidget *parent,
                                                         Qt::WindowFlags f)
        : AccountDetailsDialog (parent, f)
{
        setWindowTitle(tr("Create new account"));

        QVBoxLayout *layout = new QVBoxLayout(this);

        QFormLayout *form = new QFormLayout ();
        layout->addLayout (form, 1);

        _name = new QLineEdit();
        form->addRow (new QLabel(tr("Name")), _name);
        _budget = new QLineEdit();
        form->addRow (new QLabel(tr("Default budget")), _budget);

        box = new QDialogButtonBox (QDialogButtonBox::Cancel, Qt::Horizontal);
        QPushButton *saveButton = new QPushButton(tr("Save"));
        box->addButton(saveButton, QDialogButtonBox::ActionRole);
        layout->addWidget (box, 0, Qt::AlignBottom);

        connect(box, SIGNAL(rejected()), this, SLOT(reject()));
        connect(saveButton, SIGNAL(clicked()), this, SLOT(newClicked()));
}

void AccountDetailsDialogDesktop::saveClicked()
{
        if (_budget->text() == "") {
                QMessageBox msgBox(this);
                msgBox.setText(tr("Default budget cannot be empty"));
                msgBox.exec();
                return;
        }

        double budget = _budget->text().toDouble();

        if (budget <= 0) {
                QMessageBox msgBox(this);
                msgBox.setText(tr("Invalid budget format"));
                msgBox.exec();
                return;
        }

        accept();
        emit updateAccountConfirmed(new Account(accountId, accountName, budget));
}

void AccountDetailsDialogDesktop::deleteClicked()
{
        QString message(tr("When deleting an account, all the expenses associated to it "
                           "will also be deleted.\n\n"
                           "Are you sure you want to delete the account?"));

        if (ConfirmationDialogDesktop::askConfirmation(message, this)) {
                accept();
                emit deleteAccountConfirmed(new Account(accountId,"",0));
        }
}

void AccountDetailsDialogDesktop::activateClicked()
{
        accept();
        emit selectAccountConfirmed(new Account(accountId,accountName,accountBudget));
}

void AccountDetailsDialogDesktop::newClicked()
{
        if (_name->text() == "") {
                QMessageBox msgBox(this);
                msgBox.setText(tr("Name field cannot be empty"));
                msgBox.exec();
                return;
        }

        if (_budget->text() == "") {
                QMessageBox msgBox(this);
                msgBox.setText(tr("Default budget cannot be empty"));
                msgBox.exec();
                return;
        }

        double budget = _budget->text().toDouble();

        if (budget <= 0) {
                QMessageBox msgBox(this);
                msgBox.setText(tr("Invalid budget format"));
                msgBox.exec();
                return;
        }

        emit newAccountConfirmed(new Account(0,_name->text(), budget));

        accept();
}

QSize AccountDetailsDialogDesktop::minimumSizeHint() const
{
        return QSize(300, 100);
}

QSize AccountDetailsDialogDesktop::sizeHint() const
{
        return QSize(300, 100);
}
