#ifndef CONCEPTSCHART_H
#define CONCEPTSCHART_H

#include <QWidget>
#include <QList>
#include "summarydata.h"


class ConceptsChart : public QWidget
{
        Q_OBJECT
 public:
        ConceptsChart(QWidget *parent = 0);

        QSize minimumSizeHint() const;
        QSize sizeHint() const;

        void setPadding(int padding);
        void setSummaryData(SummaryData *data);

 protected:
        void paintEvent(QPaintEvent *event);

 private:
        void drawPie(QPainter &painter);
        void drawLegend(QPainter &painter, int i);
        void nextColor(int &red, int &green, int &blue);

        int _padding;
        SummaryData *_data;
        int xStart, yStart;
        int sceneWidth, sceneHeight;
        int pieHolderWidth, pieHolderHeight;
        int xEnd, yEnd;
        int legendXStart;
        int legendWidth;
        int legendCols;
        int legendColWidth;
        int colorStep;
};


#endif
