#include "settingsdlg.h"
#include "SiBApplication.h"
#include "Settings.h"
#include "folderdialog.h"

SettingsDlg::SettingsDlg( QWidget *parent )
    : QDialog(parent)
{
    ui.setupUi(this);

    connect( ui.zoomCheckBox, SIGNAL( toggled( bool ) ),
        this, SLOT( zoomEnabled( bool ) ) );
    connect( ui.stretchCheckBox, SIGNAL( toggled( bool ) ),
        this, SLOT( stretchEnabled( bool ) ) );
    connect( ui.frameDropCheckBox, SIGNAL( toggled( bool ) ),
        this, SLOT( frameDropEnabled( bool ) ) );
    connect( ui.selectFolderButton, SIGNAL( clicked() ),
        this, SLOT( selectFolders() ) );

    ui.zoomCheckBox->setChecked( SiBApplication::instance()->settings().zoomEnabled() );
    ui.stretchCheckBox->setChecked( SiBApplication::instance()->settings().stretchEnabled() );
    ui.frameDropCheckBox->setChecked( SiBApplication::instance()->settings().frameDropEnabled() );

    m_updateFileList = false;
}

SettingsDlg::~SettingsDlg()
{
}

bool SettingsDlg::updateFileList()
{
    return m_updateFileList;
}

void SettingsDlg::selectFolders()
{
    FolderDialog folderDialog;
    folderDialog.exec();
    m_updateFileList = true;
}

void SettingsDlg::zoomEnabled( bool enabled )
{
    SiBApplication::instance()->settings().setZoomEnabled( enabled );
}

void SettingsDlg::stretchEnabled( bool enabled )
{
    SiBApplication::instance()->settings().setStretchEnabled( enabled );
    ui.zoomCheckBox->setEnabled( !enabled ); // if stretch is enabled, zoom won't be working
}

void SettingsDlg::frameDropEnabled( bool enabled )
{
    SiBApplication::instance()->settings().setFrameDropEnabled( enabled );
}

