#ifndef PLAYERFACADE_H
#define PLAYERFACADE_H

#include <QObject>
#include <QProcess>

class QFileInfo;
class VideoFile;
class QKeyEvent;

class PlayerFacade : public QObject
{
    Q_OBJECT;

public:
    PlayerFacade( QObject* parent );
    ~PlayerFacade();

private slots:
    void playerStarted();
    void playerExited( int exitCode, QProcess::ExitStatus exitStatus );
    void playerHasOutputData();
    void parseFileInfoOutputData();
    void doPlayFile();

signals:
    void playerStart();
    void playerStop();

public:
    void playFile( VideoFile* file, bool zoom, bool frameDropEnabled );
    bool isPlayerRunning();
    void stop();

    /**
     * Forwards a key press to mplayer.
     */
    void forwardKeyEvent( QKeyEvent* event );

private:



    /**
     * Starts MPlayer to retrieve the video dimensions and
     * then calculates the crop dimensions.
     */
    void setZoomOptions();

private:
    QProcess* m_mplayer;
    VideoFile* m_currentFile; // not owned
    bool m_playerIsRunning;
    QString m_zoomOptions;
    bool m_frameDrop;
};

#endif // PLAYERFACADE_H
