/*
 * Settings.h
 *
 *  Created on: Nov 2, 2009
 *      Author: oli
 */

#ifndef SETTINGS_H_
#define SETTINGS_H_

#include <QtCore/qobject.h>
#include <QSettings>

const QString COMPANY( "sibplayer" );
const QString PRODUCTNAME( "SiBPlayer" );
const QString PREFIX_SEARCHFOLDERS( "Folders" );
const QString PREFIX_FILES( "Files" );
const QString KEY_INIT( "initialized" );
const QString KEY_FOLDER( "folder" );
const QString KEY_FILENAME( "file" );
const QString KEY_FILEPOS( "resume" );
const QString DEFAULT_SEARCHFOLDER( "/home/user/MyDocs/Videos" );

class Settings : public QObject {
    Q_OBJECT

public:
    Settings( QObject* parent );
	virtual ~Settings();
	const QList<QString>& searchFolders();
    void addFolder( QString folder );
    void removeFolder( QString folder );

private:

    void saveSettings();
    void loadSettings();

private:
        QList<QString> m_searchFolders;
        QSettings* m_settings;

        /// Flag that indicates if settings were stored before
        bool m_initialized;
};

#endif /* SETTINGS_H_ */
