#ifndef FAVOURITEWINDOW_H
#define FAVOURITEWINDOW_H

#include <QtGui/QMainWindow>
#include <QMap>

#include "settings.h"

class QWidget;
class QMaemo5ValueButton;
class QMaemo5ListPickSelector;
class QStandardItemModel;
class QHBoxLayout;
class QVBoxLayout;
class QListWidget;
class QListWidgetItem;
class QLineEdit;
class InfoAccess;
class QPushButton;


class FavouriteWindow : public SettingsWindow 
{
    Q_OBJECT

public:
    FavouriteWindow(QMainWindow* parent);

    ~FavouriteWindow();

public slots:

signals:
	void clicked();

private slots:
	void selectRegion(QString region);
	void selectChannel(QString channel);
	void addSearchTitle();
	void removeSelectedChannel();
	void removeSearchTitle(QListWidgetItem* item);
	void showMenu(QListWidgetItem *item);
	void showSelectedListWidget();
	void showSearchTitles();
	void doSave();
	void doCancel();

private: // functions
	void initRegionListModel();
	void initChannelListModel();
	void toggleList(int);

private:
	QMaemo5ValueButton *_regionSelector;
	QMaemo5ListPickSelector	*_regionSelectorList;
	QStandardItemModel *_regionListModel;
	QMaemo5ValueButton *_channelSelector;
	QMaemo5ListPickSelector	*_channelSelectorList;
	QStandardItemModel *_channelListModel;
	QLineEdit	*_searchListEdit;

	QPushButton *_backButton;
	QPushButton *_cancelButton;
	QPushButton *_saveButton;

	QHBoxLayout	*_h1layout;
	QHBoxLayout	*_h2layout;
	QHBoxLayout	*_h3layout;
	QVBoxLayout	*_v1layout;
	QWidget	*_mainwidget;

	QListWidget	*_selectedListWidget;
	QListWidget	*_searchListWidget;

	QAction	*_a1;
	QAction	*_a2;

	InfoAccess *_infoapi;

	QString _region;
	QString _channel;
};

#endif // FAVOURITEWINDOW_H
