#include <QObject>
#include <QMaemo5InformationBox>
#include <QFile>
#include <QDir>
#include <QDebug>
#include <QProcess>
#include <QTextStream>

#include "datadownloader.h"
#include "befiles.h"

BEFiles::BEFiles(QObject *parent) : DataDownloader(parent, "/opt/showtime/data/be/"), HELPERPATH("/opt/showtime/helper/")
{
	_settingsFile = new QFile(QString(DATAPATH) + ".be");
	_channelFile = QString(DATAPATH) + ".be_channel_list";

	initSettings();
}

void BEFiles::initSettings()
{
	// just call the parent init settings
	// nothing region specific 
	DataDownloader::initSettings();
}

QUrl BEFiles::getUrl()
{
	QUrl url;

	QString requestChannelCode = _channelCodeMap[_requestChannel];

	if ( !_useLocal )
		url.setUrl(QString("http://www.xmltvepg.be/rytecxmltvbenl.gz?APP=SHOWTIME") );
	else
		url.setPath(QString(""));

	return url;
}

BEFiles::~BEFiles()
{
}

QString BEFiles::finishedDownload(QString channel, QIODevice *source)
{
	channel = "dummy";
	QString filename = saveZipFile(channel, source); // file will be saved as dummy--currentDate--.xml

	// this method will split the huge single xml file per channel
	// be patient this takes time
	splitXMLTVFile(filename);

	return filename;
}

void BEFiles::setInput(DownloadInput d)
{
	DataDownloader::setInput(d);
}

void BEFiles::sendRecordMsg(QStringList data)
{
}

void BEFiles::sentRecordMsg(int exitCode, QProcess::ExitStatus exitStatus)
{
}
