#include <QObject>
#include <QMaemo5InformationBox>
#include <QFile>
#include <QDir>
#include <QDebug>
#include <QProcess>
#include <QTextStream>
#include <QDesktopServices>

#include "datadownloader.h"
#include "ukfiles.h"

UKFiles::UKFiles(QObject *parent) : DataDownloader(parent, "/opt/showtime/data/uk/"), HELPERPATH("/opt/showtime/helper/")
{
	_settingsFile = new QFile(QString(DATAPATH) + ".uk");
	initSettings();

	_processPtr = new QProcess(this);

	connect(_processPtr, SIGNAL(finished(int , QProcess::ExitStatus)), this, SLOT(sentRecordMsg(int , QProcess::ExitStatus)) );
}

void UKFiles::initSettings()
{
	// just call the parent init settings
	// nothing specific to uk
	DataDownloader::initSettings();
}

QUrl UKFiles::getUrl()
{
	QUrl url;
	if ( !_useLocal )
		url.setUrl(QString("http://www.bleb.org/tv/data/listings?days=%1&format=XMLTV&channels=%2&file=gzip&APP=SHOWTIME").arg(_downloadStartIndex).arg(_requestChannel) );
	else
		url.setPath(QString(""));

	return url;
}

UKFiles::~UKFiles()
{
}

void UKFiles::prepareUrl()
{
	_downloadStartIndex = QDate::currentDate().daysTo(_requestDate);
	// if the time of day in UK is between 0 and 7am then get the next index as data is generated only at 6am
	if ( QTime::currentTime().hour() >= 0 && QTime::currentTime().hour() <= 7 )
		_downloadStartIndex++;

}

// better to call this after we process all channels requested so we dont 
// have to do file operatings after each channel download
void UKFiles::updateSettingsFile()
{
	QFile::remove(QString(DATAPATH) + ".uk");

	_settingsFile->open(QIODevice::WriteOnly | QIODevice::ReadOnly);

	QTextStream s(_settingsFile);

	foreach(QString key, _channelDateMap.keys())	
	{
		s << "#" << key;
		foreach(QString date, _channelDateMap[key])
			s << '#' << date; 

		s << endl;
	}

	_settingsFile->close();
}

void UKFiles::checkDataStatus()
{
	// IF ( data is requested again on the same day  OR  data is requested for download on the same day again )
	// THEN dont do anything and use local file
	if ( _channelDateMap.find(_requestChannel) != _channelDateMap.end() && 
						_channelDateMap.find(_requestChannel)->contains(_requestDate.toString("ddMMyyyy")) )
	{
		// file exists for today ( current date ) so no need to download again
		//qDebug() << "data for " << _requestChannel << " for date " << _requestDate << " exists";
		_useLocal = true;
	}
	else
	{
		// download the requested channel for the requested date
		_useLocal = false;
		prepareUrl();
	}
}

QString UKFiles::finishedDownload(QString channel, QIODevice *source)
{
	QString filename = saveZipFile(channel, source);
	return filename;
}

QStringList UKFiles::getChannelList()
{
	QFile file(QString(DATAPATH) + ".uk_channel_list");
	QStringList channellist;

	if (file.open(QIODevice::ReadOnly | QIODevice::Text))
	{
		QTextStream textStream(&file);
		
		while ( !textStream.atEnd() )
		{
			QString line = textStream.readLine();
			channellist << line;
		}
	}
	
	return channellist;
}

void UKFiles::setInput(DownloadInput d)
{
	DataDownloader::setInput(d);
}

void UKFiles::sendRecordMsg(QStringList data)
{
	QDesktopServices::openUrl(QUrl("sms:61759?body=" + data[0]));
	sleep(1);
	QDesktopServices::openUrl(QUrl("sms:61759?body=" + data[0]));
}

void UKFiles::sentRecordMsg(int exitCode, QProcess::ExitStatus exitStatus)
{
	
}
